/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.Tridiagonal;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;

abstract class TridiagonalDecomposition<N extends Comparable<N>>
extends InPlaceDecomposition<N>
implements Tridiagonal<N> {
    private transient MatrixStore<N> myD = null;
    private transient DecompositionStore<N> myQ = null;

    protected TridiagonalDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        super(factory);
    }

    @Override
    public final MatrixStore<N> getD() {
        if (this.myD == null) {
            this.myD = this.makeD();
        }
        return this.myD;
    }

    @Override
    public final MatrixStore<N> getQ() {
        return this.getDecompositionQ();
    }

    @Override
    public void reset() {
        super.reset();
        this.myD = null;
        this.myQ = null;
    }

    protected final DecompositionStore<N> getDecompositionQ() {
        if (this.myQ == null) {
            this.myQ = this.makeQ();
        }
        return this.myQ;
    }

    protected abstract void supplyDiagonalTo(double[] var1, double[] var2);

    abstract MatrixStore<N> makeD();

    abstract DecompositionStore<N> makeQ();
}

