/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.LUDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawLU;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public interface LU<N extends Comparable<N>>
extends LDU<N>,
MatrixDecomposition.Pivoting<N> {
    public static final Factory<ComplexNumber> COMPLEX = typical -> new LUDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> {
        if (512L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new LUDecomposition.Primitive();
        }
        return new RawLU();
    };
    public static final Factory<Quaternion> QUATERNION = typical -> new LUDecomposition.Quat();
    public static final Factory<RationalNumber> RATIONAL = typical -> new LUDecomposition.Rational();

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, LU<N> decomposition, NumberContext context) {
        MatrixStore<MatrixStore<N>> tmpL = decomposition.getL();
        MatrixStore<N> tmpU = decomposition.getU();
        int[] tmpPivotOrder = decomposition.getPivotOrder();
        return Access2D.equals(matrix.rows(tmpPivotOrder), tmpL.multiply(tmpU), context);
    }

    public MatrixStore<N> getL();

    public MatrixStore<N> getU();

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxL = this.getL();
        MatrixStore<N> mtrxU = this.getU();
        int[] pivotOrder = this.getPivotOrder();
        return (MatrixStore)mtrxL.multiply(mtrxU).row(pivotOrder);
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<LU<N>> {
    }
}

