/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.autoscaling.AutoscalingLicenseChecker;
import org.elasticsearch.xpack.autoscaling.action.CapacityResponseCache;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingCapacityAction;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCalculateCapacityService;
import org.elasticsearch.xpack.autoscaling.capacity.nodeinfo.AutoscalingNodeInfoService;

public class TransportGetAutoscalingCapacityAction
extends TransportMasterNodeAction<GetAutoscalingCapacityAction.Request, GetAutoscalingCapacityAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetAutoscalingCapacityAction.class);
    private final AutoscalingCalculateCapacityService capacityService;
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final AutoscalingNodeInfoService nodeInfoService;
    private final AutoscalingLicenseChecker autoscalingLicenseChecker;
    private final CapacityResponseCache<GetAutoscalingCapacityAction.Response> responseCache = new CapacityResponseCache<GetAutoscalingCapacityAction.Response>(run -> this.threadPool.executor("management").execute((Runnable)run), this::computeCapacity);

    @Inject
    public TransportGetAutoscalingCapacityAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoscalingCalculateCapacityService.Holder capacityServiceHolder, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, AutoscalingNodeInfoService nodeInfoService, AutoscalingLicenseChecker autoscalingLicenseChecker) {
        super("cluster:admin/autoscaling/get_autoscaling_capacity", transportService, clusterService, threadPool, actionFilters, GetAutoscalingCapacityAction.Request::new, GetAutoscalingCapacityAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.snapshotsInfoService = snapshotsInfoService;
        this.nodeInfoService = nodeInfoService;
        this.capacityService = capacityServiceHolder.get();
        this.clusterInfoService = clusterInfoService;
        this.autoscalingLicenseChecker = Objects.requireNonNull(autoscalingLicenseChecker);
        assert (this.capacityService != null);
    }

    protected void masterOperation(Task task, GetAutoscalingCapacityAction.Request request, ClusterState state, ActionListener<GetAutoscalingCapacityAction.Response> listener) {
        if (!this.autoscalingLicenseChecker.isAutoscalingAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"autoscaling"));
            return;
        }
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        this.responseCache.get(() -> ((CancellableTask)cancellableTask).isCancelled(), listener);
    }

    private GetAutoscalingCapacityAction.Response computeCapacity(Runnable ensureNotCancelled) {
        GetAutoscalingCapacityAction.Response response = new GetAutoscalingCapacityAction.Response(this.capacityService.calculate(this.clusterService.state(), this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), this.nodeInfoService.snapshot(), ensureNotCancelled));
        logger.debug("autoscaling capacity response [{}]", (Object)response);
        return response;
    }

    protected ClusterBlockException checkBlock(GetAutoscalingCapacityAction.Request request, ClusterState state) {
        return null;
    }

    int responseCacheQueueSize() {
        return this.responseCache.jobQueueSize();
    }
}

