/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.WaitForSnapshotStep;

public class WaitForSnapshotAction
implements LifecycleAction {
    public static final String NAME = "wait_for_snapshot";
    public static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
    private static final ConstructingObjectParser<WaitForSnapshotAction, Void> PARSER = new ConstructingObjectParser("wait_for_snapshot", a -> new WaitForSnapshotAction((String)a[0]));
    private final String policy;

    public static WaitForSnapshotAction parse(XContentParser parser) {
        return (WaitForSnapshotAction)PARSER.apply(parser, null);
    }

    public WaitForSnapshotAction(String policy) {
        if (!Strings.hasText((String)policy)) {
            throw new IllegalArgumentException("policy name must be specified");
        }
        this.policy = policy;
    }

    public WaitForSnapshotAction(StreamInput in) throws IOException {
        this(in.readString());
    }

    public String getPolicy() {
        return this.policy;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey waitForSnapshotKey = new Step.StepKey(phase, NAME, "wait-for-snapshot");
        return List.of(new WaitForSnapshotStep(waitForSnapshotKey, nextStepKey, client, this.policy));
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.policy);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY_FIELD.getPreferredName(), this.policy);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaitForSnapshotAction that = (WaitForSnapshotAction)o;
        return this.policy.equals(that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.policy);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY_FIELD);
    }
}

