/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.heuristic;

import java.io.IOException;
import java.util.Objects;
import org.apache.commons.math3.util.FastMath;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.NXYSignificanceHeuristic;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.aggs.heuristic.LongBinomialDistribution;
import org.elasticsearch.xpack.ml.aggs.heuristic.MlChiSquaredDistribution;

public class PValueScore
extends NXYSignificanceHeuristic {
    public static final String NAME = "p_value";
    public static final ParseField NORMALIZE_ABOVE = new ParseField("normalize_above", new String[0]);
    public static final ConstructingObjectParser<PValueScore, Void> PARSER = new ConstructingObjectParser("p_value", args -> {
        boolean backgroundIsSuperset = args[0] == null || (Boolean)args[0] != false;
        return new PValueScore(backgroundIsSuperset, (Long)args[1]);
    });
    private static final MlChiSquaredDistribution CHI_SQUARED_DISTRIBUTION;
    private final long normalizeAbove;

    public PValueScore(boolean backgroundIsSuperset, Long normalizeAbove) {
        super(true, backgroundIsSuperset);
        if (normalizeAbove != null && normalizeAbove <= 0L) {
            throw new IllegalArgumentException("[" + NORMALIZE_ABOVE.getPreferredName() + "] must be a positive value, provided [" + normalizeAbove + "]");
        }
        this.normalizeAbove = normalizeAbove == null ? 0L : normalizeAbove;
    }

    public PValueScore(StreamInput in) throws IOException {
        super(true, in.readBoolean());
        this.normalizeAbove = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.backgroundIsSuperset);
        out.writeVLong(this.normalizeAbove);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PValueScore that = (PValueScore)((Object)o);
        return this.normalizeAbove == that.normalizeAbove;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.normalizeAbove);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
        if (this.normalizeAbove > 0L) {
            builder.field(NORMALIZE_ABOVE.getPreferredName(), this.normalizeAbove);
        }
        builder.endObject();
        return builder;
    }

    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        NXYSignificanceHeuristic.Frequencies frequencies = this.computeNxys(subsetFreq, subsetSize, supersetFreq, supersetSize, "PValueScore");
        double docsContainTermInClass = frequencies.N11;
        double allDocsNotInClass = frequencies.N_0;
        double allDocsInClass = frequencies.N_1;
        double docsContainTermNotInClass = frequencies.N10;
        if (docsContainTermInClass * allDocsNotInClass <= allDocsInClass * docsContainTermNotInClass) {
            return 0.0;
        }
        if (allDocsNotInClass == 0.0 || allDocsInClass == 0.0) {
            return 0.0;
        }
        if (this.normalizeAbove > 0L) {
            double factor;
            if (allDocsInClass > (double)this.normalizeAbove) {
                factor = (double)this.normalizeAbove / allDocsInClass;
                allDocsInClass = (long)(allDocsInClass * factor);
                docsContainTermInClass = (long)(docsContainTermInClass * factor);
            }
            if (allDocsNotInClass > (double)this.normalizeAbove) {
                factor = (double)this.normalizeAbove / allDocsNotInClass;
                allDocsNotInClass = (long)(allDocsNotInClass * factor);
                docsContainTermNotInClass = (long)(docsContainTermNotInClass * factor);
            }
        }
        double epsAllDocsInClass = (long)PValueScore.eps(allDocsInClass);
        double epsAllDocsNotInClass = (long)PValueScore.eps(allDocsNotInClass);
        docsContainTermNotInClass += epsAllDocsNotInClass;
        docsContainTermNotInClass = (long)(Math.min(1.05 * docsContainTermNotInClass, (docsContainTermInClass += epsAllDocsInClass) / (allDocsInClass += epsAllDocsInClass) * (allDocsNotInClass += epsAllDocsNotInClass)) + 0.5);
        if (allDocsInClass > 9.223372036854776E18 || docsContainTermInClass > 9.223372036854776E18 || allDocsNotInClass > 9.223372036854776E18 || docsContainTermNotInClass > 9.223372036854776E18) {
            throw new IllegalArgumentException("too many documents in background and foreground sets, further restrict sets for execution");
        }
        double v1 = new LongBinomialDistribution((long)allDocsInClass, docsContainTermInClass / allDocsInClass).logProbability((long)docsContainTermInClass);
        double v2 = new LongBinomialDistribution((long)allDocsNotInClass, docsContainTermNotInClass / allDocsNotInClass).logProbability((long)docsContainTermNotInClass);
        double p2 = (docsContainTermInClass + docsContainTermNotInClass) / (allDocsInClass + allDocsNotInClass);
        double v3 = new LongBinomialDistribution((long)allDocsInClass, p2).logProbability((long)docsContainTermInClass);
        double v4 = new LongBinomialDistribution((long)allDocsNotInClass, p2).logProbability((long)docsContainTermNotInClass);
        double logLikelihoodRatio = v1 + v2 - v3 - v4;
        double pValue = CHI_SQUARED_DISTRIBUTION.survivalFunction(2.0 * logLikelihoodRatio);
        return FastMath.max((double)(-FastMath.log((double)FastMath.max((double)pValue, (double)Double.MIN_NORMAL))), (double)0.0);
    }

    private static double eps(double value) {
        return Math.max(0.05 * value + 0.5, 1.0);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), BACKGROUND_IS_SUPERSET);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), NORMALIZE_ABOVE);
        CHI_SQUARED_DISTRIBUTION = new MlChiSquaredDistribution(1.0);
    }
}

