/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.telemetry;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public record InferenceStats(LongCounter requestCount, LongHistogram inferenceDuration) {
    public InferenceStats {
        Objects.requireNonNull(requestCount);
        Objects.requireNonNull(inferenceDuration);
    }

    public static InferenceStats create(MeterRegistry meterRegistry) {
        return new InferenceStats(meterRegistry.registerLongCounter("es.inference.requests.count.total", "Inference API request counts for a particular service, task type, model ID", "operations"), meterRegistry.registerLongHistogram("es.inference.requests.time", "Inference API request counts for a particular service, task type, model ID", "ms"));
    }

    public static Map<String, Object> modelAttributes(Model model) {
        return InferenceStats.toMap(InferenceStats.modelAttributeEntries(model));
    }

    private static Stream<Map.Entry<String, Object>> modelAttributeEntries(Model model) {
        Stream.Builder<Map.Entry<String, String>> stream = Stream.builder().add(Map.entry("service", model.getConfigurations().getService())).add(Map.entry("task_type", model.getTaskType().toString()));
        if (model.getServiceSettings().modelId() != null) {
            stream.add(Map.entry("model_id", model.getServiceSettings().modelId()));
        }
        return stream.build();
    }

    private static Map<String, Object> toMap(Stream<Map.Entry<String, Object>> stream) {
        return stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, Object> responseAttributes(Model model, @Nullable Throwable t) {
        return InferenceStats.toMap(Stream.concat(InferenceStats.modelAttributeEntries(model), InferenceStats.errorAttributes(t)));
    }

    public static Map<String, Object> responseAttributes(UnparsedModel model, @Nullable Throwable t) {
        Stream<Map.Entry<String, String>> unknownModelAttributes = Stream.builder().add(Map.entry("service", model.service())).add(Map.entry("task_type", model.taskType().toString())).build();
        return InferenceStats.toMap(Stream.concat(unknownModelAttributes, InferenceStats.errorAttributes(t)));
    }

    public static Map<String, Object> responseAttributes(@Nullable Throwable t) {
        return InferenceStats.toMap(InferenceStats.errorAttributes(t));
    }

    private static Stream<Map.Entry<String, Object>> errorAttributes(@Nullable Throwable t) {
        if (t == null) {
            return Stream.of(Map.entry("status_code", 200));
        }
        if (t instanceof ElasticsearchStatusException) {
            ElasticsearchStatusException ese = (ElasticsearchStatusException)t;
            return Stream.builder().add(Map.entry("status_code", ese.status().getStatus())).add(Map.entry("error.type", String.valueOf(ese.status().getStatus()))).build();
        }
        return Stream.of(Map.entry("error.type", t.getClass().getSimpleName()));
    }
}

