/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.queries;

import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.inference.queries.SemanticQueryBuilder;
import org.elasticsearch.xpack.inference.queries.SemanticQueryRewriteInterceptor;

public class SemanticMatchQueryRewriteInterceptor
extends SemanticQueryRewriteInterceptor {
    public static final NodeFeature SEMANTIC_MATCH_QUERY_REWRITE_INTERCEPTION_SUPPORTED = new NodeFeature("search.semantic_match_query_rewrite_interception_supported");

    @Override
    protected String getFieldName(QueryBuilder queryBuilder) {
        assert (queryBuilder instanceof MatchQueryBuilder);
        MatchQueryBuilder matchQueryBuilder = (MatchQueryBuilder)queryBuilder;
        return matchQueryBuilder.fieldName();
    }

    @Override
    protected String getQuery(QueryBuilder queryBuilder) {
        assert (queryBuilder instanceof MatchQueryBuilder);
        MatchQueryBuilder matchQueryBuilder = (MatchQueryBuilder)queryBuilder;
        return (String)matchQueryBuilder.value();
    }

    @Override
    protected QueryBuilder buildInferenceQuery(QueryBuilder queryBuilder, SemanticQueryRewriteInterceptor.InferenceIndexInformationForField indexInformation) {
        return new SemanticQueryBuilder(indexInformation.fieldName(), this.getQuery(queryBuilder), false);
    }

    @Override
    protected QueryBuilder buildCombinedInferenceAndNonInferenceQuery(QueryBuilder queryBuilder, SemanticQueryRewriteInterceptor.InferenceIndexInformationForField indexInformation) {
        assert (queryBuilder instanceof MatchQueryBuilder);
        MatchQueryBuilder matchQueryBuilder = (MatchQueryBuilder)queryBuilder;
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.should(this.createSemanticSubQuery(indexInformation.getInferenceIndices(), matchQueryBuilder.fieldName(), (String)matchQueryBuilder.value()));
        boolQueryBuilder.should(this.createSubQueryForIndices(indexInformation.nonInferenceIndices(), (QueryBuilder)matchQueryBuilder));
        return boolQueryBuilder;
    }

    public String getQueryName() {
        return "match";
    }
}

