/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.ISelection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionActivityTracker;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionProposalBase;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposal;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLEditorQueryCompletionAnalyzer;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCommandCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContentAssistant;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContext;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplateCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesRegistry;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionProcessor
implements IContentAssistProcessor {
    private static final Log log = Log.getLog(SQLCompletionProcessor.class);
    private static final IContextInformationValidator VALIDATOR = new Validator();
    private static boolean lookupTemplates = false;
    private static boolean simpleMode = false;
    private final SQLEditorBase editor;
    private SQLContentAssistant contentAssistant;

    public static boolean isLookupTemplates() {
        return lookupTemplates;
    }

    public static void setLookupTemplates(boolean lookupTemplates) {
        SQLCompletionProcessor.lookupTemplates = lookupTemplates;
    }

    static void setSimpleMode(boolean simpleMode) {
        SQLCompletionProcessor.simpleMode = simpleMode;
    }

    public SQLCompletionProcessor(SQLEditorBase editor) {
        this.editor = editor;
    }

    public void initAssistant(SQLContentAssistant contentAssistant) {
        contentAssistant.addCompletionListener(new CompletionListener());
        this.contentAssistant = contentAssistant;
    }

    /*
     * Exception decompiling
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 12[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<?> computeProposalsWithJobs(@NotNull SQLCompletionRequest request, @NotNull Position completionRequestPosition, @NotNull List<Supplier<ProposalsComputationJobHolder>> completionJobSuppliers) {
        List<ProposalsComputationJobHolder> completionJobs = completionJobSuppliers.stream().map(Supplier::get).collect(Collectors.toList());
        boolean hasRunningJobs = true;
        while (hasRunningJobs) {
            completionJobs.forEach(j -> UIUtils.waitJobCompletion((AbstractJob)j.job));
            hasRunningJobs = false;
            if (completionJobs.stream().anyMatch(j -> j.job.isCanceled())) {
                return Collections.emptyList();
            }
            int currentOffset = completionRequestPosition.getOffset();
            int i = 0;
            while (i < completionJobs.size()) {
                Integer origin = ((ProposalsComputationJobHolder)completionJobs.get(i)).getProposalsOriginOffset();
                if (origin != null) {
                    ProposalsJobResultStatus jobResultStatus = SQLCompletionProcessor.evaluateJobResult(request, origin, currentOffset);
                    switch (jobResultStatus) {
                        case VALID: 
                        case PARTIALLY_VALID: {
                            break;
                        }
                        case INVALID: {
                            completionJobs.set(i, completionJobSuppliers.get(i).get());
                            hasRunningJobs = true;
                            break;
                        }
                        default: {
                            return Collections.emptyList();
                        }
                    }
                }
                ++i;
            }
        }
        return completionJobs.stream().flatMap(j -> j.getProposals().stream()).toList();
    }

    private static ProposalsJobResultStatus evaluateJobResult(SQLCompletionRequest request, int jobProposalsOrigin, int currentCursorPosition) {
        if (jobProposalsOrigin > currentCursorPosition) {
            if (currentCursorPosition < request.getDocumentOffset()) {
                return ProposalsJobResultStatus.ABORT;
            }
            return ProposalsJobResultStatus.INVALID;
        }
        if (jobProposalsOrigin < currentCursorPosition) {
            return ProposalsJobResultStatus.PARTIALLY_VALID;
        }
        return ProposalsJobResultStatus.VALID;
    }

    private ICompletionProposal[] makeCommandProposals(SQLCompletionRequest request, String prefix) {
        String controlCommandPrefix = this.editor.getSyntaxManager().getControlCommandPrefix();
        if (prefix.startsWith(controlCommandPrefix)) {
            prefix = prefix.substring(controlCommandPrefix.length());
        }
        ArrayList<SQLCommandCompletionProposal> commandProposals = new ArrayList<SQLCommandCompletionProposal>();
        for (SQLCommandHandlerDescriptor command : SQLCommandsRegistry.getInstance().getCommandHandlers()) {
            if (!command.getId().startsWith(prefix)) continue;
            commandProposals.add(new SQLCommandCompletionProposal(request, command));
        }
        return commandProposals.toArray(new ICompletionProposal[0]);
    }

    @NotNull
    private ICompletionProposal[] makeTemplateProposals(ITextViewer viewer, SQLCompletionRequest request) {
        String wordPart = request.getWordPart().toLowerCase();
        ArrayList<SQLTemplateCompletionProposal> templateProposals = new ArrayList<SQLTemplateCompletionProposal>();
        Template[] templateArray = this.editor.getTemplatesPage().getTemplateStore().getTemplates();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (template.getName().toLowerCase().startsWith(wordPart) && SQLEditorUtils.isTemplateContextFitsEditorContext(template.getContextTypeId(), this.editor)) {
                SQLContext templateContext = new SQLContext(SQLTemplatesRegistry.getInstance().getTemplateContextRegistry().getContextType(template.getContextTypeId()), viewer.getDocument(), new Position(request.getWordDetector().getStartOffset(), request.getWordDetector().getLength()), this.editor);
                ISelection selection = viewer.getSelectionProvider().getSelection();
                if (selection instanceof TextSelection) {
                    templateContext.setVariable("selection", ((TextSelection)selection).getText());
                }
                templateProposals.add(new SQLTemplateCompletionProposal(template, (TemplateContext)templateContext, (IRegion)new Region(request.getDocumentOffset(), 0), null));
            }
            ++n2;
        }
        templateProposals.sort(Comparator.comparing(TemplateProposal::getDisplayString));
        return templateProposals.toArray(new ICompletionProposal[0]);
    }

    @Nullable
    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        SQLScriptElement statementInfo = this.editor.extractQueryAtPos(documentOffset);
        if (statementInfo == null || CommonUtils.isEmpty((String)statementInfo.getText())) {
            return null;
        }
        IContextInformation[] result = new IContextInformation[]{new ContextInformation(statementInfo.getText(), statementInfo.getText())};
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        char[] cArray;
        boolean useKeystrokes = this.editor.getActivePreferenceStore().getBoolean("SQLEditor.ContentAssistant.auto.keystrokes.activation");
        if (useKeystrokes) {
            cArray = ".abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$".toCharArray();
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 46;
        }
        return cArray;
    }

    @Nullable
    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    @Nullable
    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return VALIDATOR;
    }

    private /* synthetic */ SQLQueryCompletionContext lambda$0(Position position, DBRProgressMonitor monitor) {
        return this.editor.obtainCompletionContext(monitor, position);
    }

    private static /* synthetic */ Integer lambda$1(Position position) {
        return position.getOffset();
    }

    private /* synthetic */ ProposalsComputationJobHolder lambda$2(final SQLEditorQueryCompletionAnalyzer sQLEditorQueryCompletionAnalyzer) {
        return new ProposalsComputationJobHolder(new NewProposalSearchJob(sQLEditorQueryCompletionAnalyzer)){

            @Override
            public List<?> getProposals() {
                return sQLEditorQueryCompletionAnalyzer.getResult();
            }

            @Override
            public Integer getProposalsOriginOffset() {
                return sQLEditorQueryCompletionAnalyzer.getActualContextOffset();
            }
        };
    }

    private /* synthetic */ ProposalsComputationJobHolder lambda$3(SQLCompletionRequest sQLCompletionRequest) {
        final SQLCompletionAnalyzer analyzer = new SQLCompletionAnalyzer(sQLCompletionRequest);
        return new ProposalsComputationJobHolder(new ProposalSearchJob((DBRRunnableParametrized<DBRProgressMonitor>)analyzer)){

            @Override
            public List<?> getProposals() {
                return analyzer.getProposals();
            }

            @Override
            public Integer getProposalsOriginOffset() {
                return null;
            }
        };
    }

    private class CompletionListener
    implements ICompletionListener,
    ICompletionListenerExtension {
        private CompletionListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            SQLCompletionProcessor.setSimpleMode(event.isAutoActivated);
            SQLCompletionProcessor.this.contentAssistant.assistSessionStarted(event);
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            simpleMode = false;
            SQLCompletionProcessor.this.contentAssistant.setLastCompletionOffset(-1);
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            SQLCompletionActivityTracker activityTracker;
            if (proposal instanceof SQLQueryCompletionProposal) {
                SQLQueryCompletionProposal p = (SQLQueryCompletionProposal)proposal;
                v0 = p.getProposalContext().getActivityTracker();
            } else if (proposal instanceof SQLCompletionProposalBase) {
                SQLCompletionProposalBase p = (SQLCompletionProposalBase)proposal;
                v0 = p.getRequest().getActivityTracker();
            } else {
                v0 = activityTracker = null;
            }
            if (activityTracker != null) {
                activityTracker.selectionChanged();
            }
        }

        public void assistSessionRestarted(ContentAssistEvent event) {
            simpleMode = true;
        }
    }

    private class NewProposalSearchJob
    extends AbstractJob {
        private final SQLEditorQueryCompletionAnalyzer analyzer;

        public NewProposalSearchJob(SQLEditorQueryCompletionAnalyzer analyzer) {
            super("Analyzing query for proposals...");
            this.analyzer = analyzer;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                monitor.beginTask("Seeking for SQL completion proposals", 2);
                monitor.worked(1);
                try {
                    monitor.subTask("Find proposals");
                    if (SQLCompletionProcessor.this.editor.getDataSource() != null) {
                        DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)SQLCompletionProcessor.this.editor.getDataSource(), (DBRRunnableParametrized)this.analyzer);
                    } else {
                        this.analyzer.run(monitor);
                    }
                }
                finally {
                    monitor.done();
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
            catch (Throwable e) {
                log.error((Object)e);
                return Status.CANCEL_STATUS;
            }
        }
    }

    private class ProposalSearchJob
    extends AbstractJob {
        private final DBRRunnableParametrized<DBRProgressMonitor> analyzer;

        ProposalSearchJob(DBRRunnableParametrized<DBRProgressMonitor> analyzer) {
            super("Search proposals...");
            this.analyzer = analyzer;
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                monitor.beginTask("Seeking for SQL completion proposals", 1);
                try {
                    monitor.subTask("Find proposals");
                    DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)SQLCompletionProcessor.this.editor.getDataSource(), this.analyzer);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
            catch (Throwable e) {
                log.error((Object)e);
                return Status.CANCEL_STATUS;
            }
        }
    }

    private static abstract class ProposalsComputationJobHolder {
        public final AbstractJob job;

        public ProposalsComputationJobHolder(AbstractJob job) {
            this.job = job;
            this.job.schedule();
        }

        public abstract List<?> getProposals();

        public abstract Integer getProposalsOriginOffset();
    }

    private static enum ProposalsJobResultStatus {
        VALID,
        PARTIALLY_VALID,
        INVALID,
        ABORT;

    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

