// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/apps/drive/labels/v2beta/label_limits.proto

package labels

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Label constraints governing the structure of a Label; such as, the maximum
// number of Fields allowed and maximum length of the label title.
type LabelLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of characters allowed for the title.
	MaxTitleLength int32 `protobuf:"varint,2,opt,name=max_title_length,json=maxTitleLength,proto3" json:"max_title_length,omitempty"`
	// The maximum number of characters allowed for the description.
	MaxDescriptionLength int32 `protobuf:"varint,3,opt,name=max_description_length,json=maxDescriptionLength,proto3" json:"max_description_length,omitempty"`
	// The maximum number of Fields allowed within the label.
	MaxFields int32 `protobuf:"varint,4,opt,name=max_fields,json=maxFields,proto3" json:"max_fields,omitempty"`
	// The maximum number of published Fields that can be deleted.
	MaxDeletedFields int32 `protobuf:"varint,5,opt,name=max_deleted_fields,json=maxDeletedFields,proto3" json:"max_deleted_fields,omitempty"`
	// The maximum number of draft revisions that will be kept before deleting
	// old drafts.
	MaxDraftRevisions int32 `protobuf:"varint,6,opt,name=max_draft_revisions,json=maxDraftRevisions,proto3" json:"max_draft_revisions,omitempty"`
	// The limits for Fields.
	FieldLimits *FieldLimits `protobuf:"bytes,7,opt,name=field_limits,json=fieldLimits,proto3" json:"field_limits,omitempty"`
}

func (x *LabelLimits) Reset() {
	*x = LabelLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelLimits) ProtoMessage() {}

func (x *LabelLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelLimits.ProtoReflect.Descriptor instead.
func (*LabelLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{0}
}

func (x *LabelLimits) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LabelLimits) GetMaxTitleLength() int32 {
	if x != nil {
		return x.MaxTitleLength
	}
	return 0
}

func (x *LabelLimits) GetMaxDescriptionLength() int32 {
	if x != nil {
		return x.MaxDescriptionLength
	}
	return 0
}

func (x *LabelLimits) GetMaxFields() int32 {
	if x != nil {
		return x.MaxFields
	}
	return 0
}

func (x *LabelLimits) GetMaxDeletedFields() int32 {
	if x != nil {
		return x.MaxDeletedFields
	}
	return 0
}

func (x *LabelLimits) GetMaxDraftRevisions() int32 {
	if x != nil {
		return x.MaxDraftRevisions
	}
	return 0
}

func (x *LabelLimits) GetFieldLimits() *FieldLimits {
	if x != nil {
		return x.FieldLimits
	}
	return nil
}

// Field constants governing the structure of a Field; such as, the maximum
// title length, minimum and maximum field values or length, etc.
type FieldLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max length for the id.
	MaxIdLength int32 `protobuf:"varint,1,opt,name=max_id_length,json=maxIdLength,proto3" json:"max_id_length,omitempty"`
	// Limits for Field title.
	MaxDisplayNameLength int32 `protobuf:"varint,2,opt,name=max_display_name_length,json=maxDisplayNameLength,proto3" json:"max_display_name_length,omitempty"`
	// Limits for Field description, also called help text.
	MaxDescriptionLength int32 `protobuf:"varint,3,opt,name=max_description_length,json=maxDescriptionLength,proto3" json:"max_description_length,omitempty"`
	// The relevant limits for the specified Field.Type.
	// Text Field limits.
	TextLimits *TextLimits `protobuf:"bytes,4,opt,name=text_limits,json=textLimits,proto3" json:"text_limits,omitempty"`
	// Long text Field limits.
	LongTextLimits *LongTextLimits `protobuf:"bytes,5,opt,name=long_text_limits,json=longTextLimits,proto3" json:"long_text_limits,omitempty"`
	// Integer Field limits.
	IntegerLimits *IntegerLimits `protobuf:"bytes,6,opt,name=integer_limits,json=integerLimits,proto3" json:"integer_limits,omitempty"`
	// Date Field limits.
	DateLimits *DateLimits `protobuf:"bytes,7,opt,name=date_limits,json=dateLimits,proto3" json:"date_limits,omitempty"`
	// User Field limits.
	UserLimits *UserLimits `protobuf:"bytes,8,opt,name=user_limits,json=userLimits,proto3" json:"user_limits,omitempty"`
	// Selection Field limits.
	SelectionLimits *SelectionLimits `protobuf:"bytes,9,opt,name=selection_limits,json=selectionLimits,proto3" json:"selection_limits,omitempty"`
}

func (x *FieldLimits) Reset() {
	*x = FieldLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldLimits) ProtoMessage() {}

func (x *FieldLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldLimits.ProtoReflect.Descriptor instead.
func (*FieldLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{1}
}

func (x *FieldLimits) GetMaxIdLength() int32 {
	if x != nil {
		return x.MaxIdLength
	}
	return 0
}

func (x *FieldLimits) GetMaxDisplayNameLength() int32 {
	if x != nil {
		return x.MaxDisplayNameLength
	}
	return 0
}

func (x *FieldLimits) GetMaxDescriptionLength() int32 {
	if x != nil {
		return x.MaxDescriptionLength
	}
	return 0
}

func (x *FieldLimits) GetTextLimits() *TextLimits {
	if x != nil {
		return x.TextLimits
	}
	return nil
}

func (x *FieldLimits) GetLongTextLimits() *LongTextLimits {
	if x != nil {
		return x.LongTextLimits
	}
	return nil
}

func (x *FieldLimits) GetIntegerLimits() *IntegerLimits {
	if x != nil {
		return x.IntegerLimits
	}
	return nil
}

func (x *FieldLimits) GetDateLimits() *DateLimits {
	if x != nil {
		return x.DateLimits
	}
	return nil
}

func (x *FieldLimits) GetUserLimits() *UserLimits {
	if x != nil {
		return x.UserLimits
	}
	return nil
}

func (x *FieldLimits) GetSelectionLimits() *SelectionLimits {
	if x != nil {
		return x.SelectionLimits
	}
	return nil
}

// Limits for list-variant of a Field type.
type ListLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum number of values allowed for the Field type.
	MaxEntries int32 `protobuf:"varint,1,opt,name=max_entries,json=maxEntries,proto3" json:"max_entries,omitempty"`
}

func (x *ListLimits) Reset() {
	*x = ListLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLimits) ProtoMessage() {}

func (x *ListLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLimits.ProtoReflect.Descriptor instead.
func (*ListLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{2}
}

func (x *ListLimits) GetMaxEntries() int32 {
	if x != nil {
		return x.MaxEntries
	}
	return 0
}

// Limits for text Field type.
type TextLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum length allowed for a text Field type.
	MinLength int32 `protobuf:"varint,1,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	// Maximum length allowed for a text Field type.
	MaxLength int32 `protobuf:"varint,2,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
}

func (x *TextLimits) Reset() {
	*x = TextLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextLimits) ProtoMessage() {}

func (x *TextLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextLimits.ProtoReflect.Descriptor instead.
func (*TextLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{3}
}

func (x *TextLimits) GetMinLength() int32 {
	if x != nil {
		return x.MinLength
	}
	return 0
}

func (x *TextLimits) GetMaxLength() int32 {
	if x != nil {
		return x.MaxLength
	}
	return 0
}

// Limits for long text Field type.
type LongTextLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum length allowed for a long text Field type.
	MinLength int32 `protobuf:"varint,1,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	// Maximum length allowed for a long text Field type.
	MaxLength int32 `protobuf:"varint,2,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
}

func (x *LongTextLimits) Reset() {
	*x = LongTextLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LongTextLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LongTextLimits) ProtoMessage() {}

func (x *LongTextLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LongTextLimits.ProtoReflect.Descriptor instead.
func (*LongTextLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{4}
}

func (x *LongTextLimits) GetMinLength() int32 {
	if x != nil {
		return x.MinLength
	}
	return 0
}

func (x *LongTextLimits) GetMaxLength() int32 {
	if x != nil {
		return x.MaxLength
	}
	return 0
}

// Limits for integer Field type.
type IntegerLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum value for an integer Field type.
	MinValue int64 `protobuf:"varint,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Maximum value for an integer Field type.
	MaxValue int64 `protobuf:"varint,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
}

func (x *IntegerLimits) Reset() {
	*x = IntegerLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntegerLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntegerLimits) ProtoMessage() {}

func (x *IntegerLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntegerLimits.ProtoReflect.Descriptor instead.
func (*IntegerLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{5}
}

func (x *IntegerLimits) GetMinValue() int64 {
	if x != nil {
		return x.MinValue
	}
	return 0
}

func (x *IntegerLimits) GetMaxValue() int64 {
	if x != nil {
		return x.MaxValue
	}
	return 0
}

// Limits for date Field type.
type DateLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum value for the date Field type.
	MinValue *date.Date `protobuf:"bytes,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Maximum value for the date Field type.
	MaxValue *date.Date `protobuf:"bytes,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
}

func (x *DateLimits) Reset() {
	*x = DateLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateLimits) ProtoMessage() {}

func (x *DateLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateLimits.ProtoReflect.Descriptor instead.
func (*DateLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{6}
}

func (x *DateLimits) GetMinValue() *date.Date {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *DateLimits) GetMaxValue() *date.Date {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

// Limits for selection Field type.
type SelectionLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Limits for list-variant of a Field type.
	ListLimits *ListLimits `protobuf:"bytes,1,opt,name=list_limits,json=listLimits,proto3" json:"list_limits,omitempty"`
	// Maximum ID length for a selection options.
	MaxIdLength int32 `protobuf:"varint,2,opt,name=max_id_length,json=maxIdLength,proto3" json:"max_id_length,omitempty"`
	// Maximum length for display name.
	MaxDisplayNameLength int32 `protobuf:"varint,3,opt,name=max_display_name_length,json=maxDisplayNameLength,proto3" json:"max_display_name_length,omitempty"`
	// The max number of choices.
	MaxChoices int32 `protobuf:"varint,4,opt,name=max_choices,json=maxChoices,proto3" json:"max_choices,omitempty"`
	// Maximum number of deleted choices.
	MaxDeletedChoices int32 `protobuf:"varint,5,opt,name=max_deleted_choices,json=maxDeletedChoices,proto3" json:"max_deleted_choices,omitempty"`
}

func (x *SelectionLimits) Reset() {
	*x = SelectionLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SelectionLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SelectionLimits) ProtoMessage() {}

func (x *SelectionLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SelectionLimits.ProtoReflect.Descriptor instead.
func (*SelectionLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{7}
}

func (x *SelectionLimits) GetListLimits() *ListLimits {
	if x != nil {
		return x.ListLimits
	}
	return nil
}

func (x *SelectionLimits) GetMaxIdLength() int32 {
	if x != nil {
		return x.MaxIdLength
	}
	return 0
}

func (x *SelectionLimits) GetMaxDisplayNameLength() int32 {
	if x != nil {
		return x.MaxDisplayNameLength
	}
	return 0
}

func (x *SelectionLimits) GetMaxChoices() int32 {
	if x != nil {
		return x.MaxChoices
	}
	return 0
}

func (x *SelectionLimits) GetMaxDeletedChoices() int32 {
	if x != nil {
		return x.MaxDeletedChoices
	}
	return 0
}

// Limits for Field.Type.USER.
type UserLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Limits for list-variant of a Field type.
	ListLimits *ListLimits `protobuf:"bytes,1,opt,name=list_limits,json=listLimits,proto3" json:"list_limits,omitempty"`
}

func (x *UserLimits) Reset() {
	*x = UserLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserLimits) ProtoMessage() {}

func (x *UserLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserLimits.ProtoReflect.Descriptor instead.
func (*UserLimits) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP(), []int{8}
}

func (x *UserLimits) GetListLimits() *ListLimits {
	if x != nil {
		return x.ListLimits
	}
	return nil
}

var File_google_apps_drive_labels_v2beta_label_limits_proto protoreflect.FileDescriptor

var file_google_apps_drive_labels_v2beta_label_limits_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a, 0x03, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10,
	0x6d, 0x61, 0x78, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x54, 0x69, 0x74, 0x6c, 0x65,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x34, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x6d, 0x61, 0x78, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a,
	0x6d, 0x61, 0x78, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x6d, 0x61, 0x78, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6d,
	0x61, 0x78, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x78,
	0x5f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x44, 0x72, 0x61, 0x66, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x0c, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0b, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x3a, 0x39, 0xea, 0x41, 0x36, 0x0a,
	0x26, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x0c, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x2f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x97, 0x05, 0x0a, 0x0b, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x64, 0x5f,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x61,
	0x78, 0x49, 0x64, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x35, 0x0a, 0x17, 0x6d, 0x61, 0x78,
	0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x6d, 0x61, 0x78, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x34, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x14, 0x6d, 0x61, 0x78, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x4c, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x65,
	0x78, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x10, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x6f, 0x6e, 0x67, 0x54, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52,
	0x0e, 0x6c, 0x6f, 0x6e, 0x67, 0x54, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12,
	0x55, 0x0a, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65,
	0x72, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x73, 0x12, 0x5b, 0x0a, 0x10, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0f,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x22,
	0x2d, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x4a,
	0x0a, 0x0a, 0x54, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x6d, 0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x6d,
	0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x6d, 0x61, 0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x4e, 0x0a, 0x0e, 0x4c, 0x6f,
	0x6e, 0x67, 0x54, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x6d, 0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x6d,
	0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x6d, 0x61, 0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x49, 0x0a, 0x0d, 0x49, 0x6e,
	0x74, 0x65, 0x67, 0x65, 0x72, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d,
	0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08,
	0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x6d, 0x61, 0x78,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x6c, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x12, 0x2e, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0x8b, 0x02, 0x0a, 0x0f, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x6c, 0x69, 0x73, 0x74, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x64, 0x5f,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x61,
	0x78, 0x49, 0x64, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x35, 0x0a, 0x17, 0x6d, 0x61, 0x78,
	0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x6d, 0x61, 0x78, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65,
	0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11,
	0x6d, 0x61, 0x78, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65,
	0x73, 0x22, 0x5a, 0x0a, 0x0a, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12,
	0x4c, 0x0a, 0x0b, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x52, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x42, 0x87, 0x01,
	0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x42, 0x10, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x3b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0xa2, 0x02, 0x04, 0x44, 0x4c, 0x42, 0x4c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescOnce sync.Once
	file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescData = file_google_apps_drive_labels_v2beta_label_limits_proto_rawDesc
)

func file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescGZIP() []byte {
	file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescData)
	})
	return file_google_apps_drive_labels_v2beta_label_limits_proto_rawDescData
}

var file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_apps_drive_labels_v2beta_label_limits_proto_goTypes = []interface{}{
	(*LabelLimits)(nil),     // 0: google.apps.drive.labels.v2beta.LabelLimits
	(*FieldLimits)(nil),     // 1: google.apps.drive.labels.v2beta.FieldLimits
	(*ListLimits)(nil),      // 2: google.apps.drive.labels.v2beta.ListLimits
	(*TextLimits)(nil),      // 3: google.apps.drive.labels.v2beta.TextLimits
	(*LongTextLimits)(nil),  // 4: google.apps.drive.labels.v2beta.LongTextLimits
	(*IntegerLimits)(nil),   // 5: google.apps.drive.labels.v2beta.IntegerLimits
	(*DateLimits)(nil),      // 6: google.apps.drive.labels.v2beta.DateLimits
	(*SelectionLimits)(nil), // 7: google.apps.drive.labels.v2beta.SelectionLimits
	(*UserLimits)(nil),      // 8: google.apps.drive.labels.v2beta.UserLimits
	(*date.Date)(nil),       // 9: google.type.Date
}
var file_google_apps_drive_labels_v2beta_label_limits_proto_depIdxs = []int32{
	1,  // 0: google.apps.drive.labels.v2beta.LabelLimits.field_limits:type_name -> google.apps.drive.labels.v2beta.FieldLimits
	3,  // 1: google.apps.drive.labels.v2beta.FieldLimits.text_limits:type_name -> google.apps.drive.labels.v2beta.TextLimits
	4,  // 2: google.apps.drive.labels.v2beta.FieldLimits.long_text_limits:type_name -> google.apps.drive.labels.v2beta.LongTextLimits
	5,  // 3: google.apps.drive.labels.v2beta.FieldLimits.integer_limits:type_name -> google.apps.drive.labels.v2beta.IntegerLimits
	6,  // 4: google.apps.drive.labels.v2beta.FieldLimits.date_limits:type_name -> google.apps.drive.labels.v2beta.DateLimits
	8,  // 5: google.apps.drive.labels.v2beta.FieldLimits.user_limits:type_name -> google.apps.drive.labels.v2beta.UserLimits
	7,  // 6: google.apps.drive.labels.v2beta.FieldLimits.selection_limits:type_name -> google.apps.drive.labels.v2beta.SelectionLimits
	9,  // 7: google.apps.drive.labels.v2beta.DateLimits.min_value:type_name -> google.type.Date
	9,  // 8: google.apps.drive.labels.v2beta.DateLimits.max_value:type_name -> google.type.Date
	2,  // 9: google.apps.drive.labels.v2beta.SelectionLimits.list_limits:type_name -> google.apps.drive.labels.v2beta.ListLimits
	2,  // 10: google.apps.drive.labels.v2beta.UserLimits.list_limits:type_name -> google.apps.drive.labels.v2beta.ListLimits
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_apps_drive_labels_v2beta_label_limits_proto_init() }
func file_google_apps_drive_labels_v2beta_label_limits_proto_init() {
	if File_google_apps_drive_labels_v2beta_label_limits_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LongTextLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntegerLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SelectionLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_labels_v2beta_label_limits_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_labels_v2beta_label_limits_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_labels_v2beta_label_limits_proto_depIdxs,
		MessageInfos:      file_google_apps_drive_labels_v2beta_label_limits_proto_msgTypes,
	}.Build()
	File_google_apps_drive_labels_v2beta_label_limits_proto = out.File
	file_google_apps_drive_labels_v2beta_label_limits_proto_rawDesc = nil
	file_google_apps_drive_labels_v2beta_label_limits_proto_goTypes = nil
	file_google_apps_drive_labels_v2beta_label_limits_proto_depIdxs = nil
}
