package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWarningMachines invokes the sas.DescribeWarningMachines API synchronously
func (client *Client) DescribeWarningMachines(request *DescribeWarningMachinesRequest) (response *DescribeWarningMachinesResponse, err error) {
	response = CreateDescribeWarningMachinesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWarningMachinesWithChan invokes the sas.DescribeWarningMachines API asynchronously
func (client *Client) DescribeWarningMachinesWithChan(request *DescribeWarningMachinesRequest) (<-chan *DescribeWarningMachinesResponse, <-chan error) {
	responseChan := make(chan *DescribeWarningMachinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWarningMachines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWarningMachinesWithCallback invokes the sas.DescribeWarningMachines API asynchronously
func (client *Client) DescribeWarningMachinesWithCallback(request *DescribeWarningMachinesRequest, callback func(response *DescribeWarningMachinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWarningMachinesResponse
		var err error
		defer close(result)
		response, err = client.DescribeWarningMachines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWarningMachinesRequest is the request struct for api DescribeWarningMachines
type DescribeWarningMachinesRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	MachineName string           `position:"Query" name:"MachineName"`
	Lang        string           `position:"Query" name:"Lang"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	RiskId      requests.Integer `position:"Query" name:"RiskId"`
	StrategyId  requests.Integer `position:"Query" name:"StrategyId"`
	Uuids       string           `position:"Query" name:"Uuids"`
}

// DescribeWarningMachinesResponse is the response struct for api DescribeWarningMachines
type DescribeWarningMachinesResponse struct {
	*responses.BaseResponse
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	Count           int              `json:"Count" xml:"Count"`
	PageSize        int              `json:"PageSize" xml:"PageSize"`
	TotalCount      int              `json:"TotalCount" xml:"TotalCount"`
	CurrentPage     int              `json:"CurrentPage" xml:"CurrentPage"`
	WarningMachines []WarningMachine `json:"WarningMachines" xml:"WarningMachines"`
}

// CreateDescribeWarningMachinesRequest creates a request to invoke DescribeWarningMachines API
func CreateDescribeWarningMachinesRequest() (request *DescribeWarningMachinesRequest) {
	request = &DescribeWarningMachinesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeWarningMachines", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWarningMachinesResponse creates a response to parse from DescribeWarningMachines response
func CreateDescribeWarningMachinesResponse() (response *DescribeWarningMachinesResponse) {
	response = &DescribeWarningMachinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
