package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserLicense invokes the linkwan.GetUserLicense API synchronously
func (client *Client) GetUserLicense(request *GetUserLicenseRequest) (response *GetUserLicenseResponse, err error) {
	response = CreateGetUserLicenseResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserLicenseWithChan invokes the linkwan.GetUserLicense API asynchronously
func (client *Client) GetUserLicenseWithChan(request *GetUserLicenseRequest) (<-chan *GetUserLicenseResponse, <-chan error) {
	responseChan := make(chan *GetUserLicenseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserLicense(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserLicenseWithCallback invokes the linkwan.GetUserLicense API asynchronously
func (client *Client) GetUserLicenseWithCallback(request *GetUserLicenseRequest, callback func(response *GetUserLicenseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserLicenseResponse
		var err error
		defer close(result)
		response, err = client.GetUserLicense(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserLicenseRequest is the request struct for api GetUserLicense
type GetUserLicenseRequest struct {
	*requests.RpcRequest
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// GetUserLicenseResponse is the response struct for api GetUserLicense
type GetUserLicenseResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetUserLicenseRequest creates a request to invoke GetUserLicense API
func CreateGetUserLicenseRequest() (request *GetUserLicenseRequest) {
	request = &GetUserLicenseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetUserLicense", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUserLicenseResponse creates a response to parse from GetUserLicense response
func CreateGetUserLicenseResponse() (response *GetUserLicenseResponse) {
	response = &GetUserLicenseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
