package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSlrConfiguration invokes the idrsservice.GetSlrConfiguration API synchronously
func (client *Client) GetSlrConfiguration(request *GetSlrConfigurationRequest) (response *GetSlrConfigurationResponse, err error) {
	response = CreateGetSlrConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// GetSlrConfigurationWithChan invokes the idrsservice.GetSlrConfiguration API asynchronously
func (client *Client) GetSlrConfigurationWithChan(request *GetSlrConfigurationRequest) (<-chan *GetSlrConfigurationResponse, <-chan error) {
	responseChan := make(chan *GetSlrConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSlrConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSlrConfigurationWithCallback invokes the idrsservice.GetSlrConfiguration API asynchronously
func (client *Client) GetSlrConfigurationWithCallback(request *GetSlrConfigurationRequest, callback func(response *GetSlrConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSlrConfigurationResponse
		var err error
		defer close(result)
		response, err = client.GetSlrConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSlrConfigurationRequest is the request struct for api GetSlrConfiguration
type GetSlrConfigurationRequest struct {
	*requests.RpcRequest
	UserId string `position:"Query" name:"UserId"`
}

// GetSlrConfigurationResponse is the response struct for api GetSlrConfiguration
type GetSlrConfigurationResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetSlrConfigurationRequest creates a request to invoke GetSlrConfiguration API
func CreateGetSlrConfigurationRequest() (request *GetSlrConfigurationRequest) {
	request = &GetSlrConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "GetSlrConfiguration", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSlrConfigurationResponse creates a response to parse from GetSlrConfiguration response
func CreateGetSlrConfigurationResponse() (response *GetSlrConfigurationResponse) {
	response = &GetSlrConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
