package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEmonGrafanaDashboards invokes the elasticsearch.GetEmonGrafanaDashboards API synchronously
func (client *Client) GetEmonGrafanaDashboards(request *GetEmonGrafanaDashboardsRequest) (response *GetEmonGrafanaDashboardsResponse, err error) {
	response = CreateGetEmonGrafanaDashboardsResponse()
	err = client.DoAction(request, response)
	return
}

// GetEmonGrafanaDashboardsWithChan invokes the elasticsearch.GetEmonGrafanaDashboards API asynchronously
func (client *Client) GetEmonGrafanaDashboardsWithChan(request *GetEmonGrafanaDashboardsRequest) (<-chan *GetEmonGrafanaDashboardsResponse, <-chan error) {
	responseChan := make(chan *GetEmonGrafanaDashboardsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEmonGrafanaDashboards(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEmonGrafanaDashboardsWithCallback invokes the elasticsearch.GetEmonGrafanaDashboards API asynchronously
func (client *Client) GetEmonGrafanaDashboardsWithCallback(request *GetEmonGrafanaDashboardsRequest, callback func(response *GetEmonGrafanaDashboardsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEmonGrafanaDashboardsResponse
		var err error
		defer close(result)
		response, err = client.GetEmonGrafanaDashboards(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEmonGrafanaDashboardsRequest is the request struct for api GetEmonGrafanaDashboards
type GetEmonGrafanaDashboardsRequest struct {
	*requests.RoaRequest
	ProjectId string `position:"Path" name:"ProjectId"`
}

// GetEmonGrafanaDashboardsResponse is the response struct for api GetEmonGrafanaDashboards
type GetEmonGrafanaDashboardsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateGetEmonGrafanaDashboardsRequest creates a request to invoke GetEmonGrafanaDashboards API
func CreateGetEmonGrafanaDashboardsRequest() (request *GetEmonGrafanaDashboardsRequest) {
	request = &GetEmonGrafanaDashboardsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "GetEmonGrafanaDashboards", "/openapi/emon/projects/[ProjectId]/grafana/proxy/api/search", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetEmonGrafanaDashboardsResponse creates a response to parse from GetEmonGrafanaDashboards response
func CreateGetEmonGrafanaDashboardsResponse() (response *GetEmonGrafanaDashboardsResponse) {
	response = &GetEmonGrafanaDashboardsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
