package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataServiceFolders invokes the dataworks_public.ListDataServiceFolders API synchronously
func (client *Client) ListDataServiceFolders(request *ListDataServiceFoldersRequest) (response *ListDataServiceFoldersResponse, err error) {
	response = CreateListDataServiceFoldersResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataServiceFoldersWithChan invokes the dataworks_public.ListDataServiceFolders API asynchronously
func (client *Client) ListDataServiceFoldersWithChan(request *ListDataServiceFoldersRequest) (<-chan *ListDataServiceFoldersResponse, <-chan error) {
	responseChan := make(chan *ListDataServiceFoldersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataServiceFolders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataServiceFoldersWithCallback invokes the dataworks_public.ListDataServiceFolders API asynchronously
func (client *Client) ListDataServiceFoldersWithCallback(request *ListDataServiceFoldersRequest, callback func(response *ListDataServiceFoldersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataServiceFoldersResponse
		var err error
		defer close(result)
		response, err = client.ListDataServiceFolders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataServiceFoldersRequest is the request struct for api ListDataServiceFolders
type ListDataServiceFoldersRequest struct {
	*requests.RpcRequest
	FolderNameKeyword string           `position:"Body" name:"FolderNameKeyword"`
	GroupId           string           `position:"Body" name:"GroupId"`
	PageSize          requests.Integer `position:"Body" name:"PageSize"`
	TenantId          requests.Integer `position:"Body" name:"TenantId"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	PageNumber        requests.Integer `position:"Body" name:"PageNumber"`
}

// ListDataServiceFoldersResponse is the response struct for api ListDataServiceFolders
type ListDataServiceFoldersResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	FolderPagingResult FolderPagingResult `json:"FolderPagingResult" xml:"FolderPagingResult"`
}

// CreateListDataServiceFoldersRequest creates a request to invoke ListDataServiceFolders API
func CreateListDataServiceFoldersRequest() (request *ListDataServiceFoldersRequest) {
	request = &ListDataServiceFoldersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListDataServiceFolders", "", "")
	request.Method = requests.POST
	return
}

// CreateListDataServiceFoldersResponse creates a response to parse from ListDataServiceFolders response
func CreateListDataServiceFoldersResponse() (response *ListDataServiceFoldersResponse) {
	response = &ListDataServiceFoldersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
