package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CustomGonggeLayout invokes the aliyuncvc.CustomGonggeLayout API synchronously
func (client *Client) CustomGonggeLayout(request *CustomGonggeLayoutRequest) (response *CustomGonggeLayoutResponse, err error) {
	response = CreateCustomGonggeLayoutResponse()
	err = client.DoAction(request, response)
	return
}

// CustomGonggeLayoutWithChan invokes the aliyuncvc.CustomGonggeLayout API asynchronously
func (client *Client) CustomGonggeLayoutWithChan(request *CustomGonggeLayoutRequest) (<-chan *CustomGonggeLayoutResponse, <-chan error) {
	responseChan := make(chan *CustomGonggeLayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CustomGonggeLayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CustomGonggeLayoutWithCallback invokes the aliyuncvc.CustomGonggeLayout API asynchronously
func (client *Client) CustomGonggeLayoutWithCallback(request *CustomGonggeLayoutRequest, callback func(response *CustomGonggeLayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CustomGonggeLayoutResponse
		var err error
		defer close(result)
		response, err = client.CustomGonggeLayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CustomGonggeLayoutRequest is the request struct for api CustomGonggeLayout
type CustomGonggeLayoutRequest struct {
	*requests.RpcRequest
	MeetingUUID    string `position:"Body" name:"MeetingUUID"`
	LayoutSolution string `position:"Body" name:"LayoutSolution"`
}

// CustomGonggeLayoutResponse is the response struct for api CustomGonggeLayout
type CustomGonggeLayoutResponse struct {
	*responses.BaseResponse
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCustomGonggeLayoutRequest creates a request to invoke CustomGonggeLayout API
func CreateCustomGonggeLayoutRequest() (request *CustomGonggeLayoutRequest) {
	request = &CustomGonggeLayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "CustomGonggeLayout", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCustomGonggeLayoutResponse creates a response to parse from CustomGonggeLayout response
func CreateCustomGonggeLayoutResponse() (response *CustomGonggeLayoutResponse) {
	response = &CustomGonggeLayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
