/*
 * Decompiled with CFR 0.152.
 */
package mill.scalalib.publish;

import java.io.Serializable;
import mill.api.Logger;
import mill.scalalib.publish.Artifact;
import mill.scalalib.publish.SonatypeHelpers$;
import mill.scalalib.publish.SonatypeHttpApi;
import mill.scalalib.publish.SonatypePublisher$;
import os.Path;
import requests.Response;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u000f\u001f\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tq\u0001\u0011\t\u0011)A\u0005[!A\u0011\b\u0001B\u0001B\u0003%Q\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n%C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003J\u0011!\u0001\u0007A!A!\u0002\u0013Y\u0004\"B1\u0001\t\u0003\u0011\u0007\"B1\u0001\t\u0003\t\b\u0002C)\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fAaa\b\u0001\u0005\u0002\u0005]\u0001bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\rv!CAX=\u0005\u0005\t\u0012AAY\r!ib$!A\t\u0002\u0005M\u0006BB1\u001b\t\u0003\t)\fC\u0005\u00028j\t\n\u0011\"\u0001\u0002:\n\t2k\u001c8bif\u0004X\rU;cY&\u001c\b.\u001a:\u000b\u0005}\u0001\u0013a\u00029vE2L7\u000f\u001b\u0006\u0003C\t\n\u0001b]2bY\u0006d\u0017N\u0019\u0006\u0002G\u0005!Q.\u001b7m\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g\u0003\r)(/\u001b\t\u0003]Ur!aL\u001a\u0011\u0005ABS\"A\u0019\u000b\u0005I\"\u0013A\u0002\u001fs_>$h(\u0003\u00025Q\u00051\u0001K]3eK\u001aL!AN\u001c\u0003\rM#(/\u001b8h\u0015\t!\u0004&A\u0006t]\u0006\u00048\u000f[8u+JL\u0017aC2sK\u0012,g\u000e^5bYN\faa]5h]\u0016$\u0007CA\u0014=\u0013\ti\u0004FA\u0004C_>dW-\u00198\u0002\u000f\u001d\u0004x-\u0011:hgB\u0019\u0001)R\u0017\u000f\u0005\u0005\u001beB\u0001\u0019C\u0013\u0005I\u0013B\u0001#)\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0007M+\u0017O\u0003\u0002EQ\u0005Y!/Z1e)&lWm\\;u!\t9#*\u0003\u0002LQ\t\u0019\u0011J\u001c;\u0002\u001d\r|gN\\3diRKW.Z8vi\u0006\u0019An\\4\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0013\u0013aA1qS&\u00111\u000b\u0015\u0002\u0007\u0019><w-\u001a:\u0002\u0013]|'o[:qC\u000e,\u0007C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u0005=\u001c\u0018B\u0001.X\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0007\u0015tg\u000f\u0005\u0003/;6j\u0013B\u000108\u0005\ri\u0015\r]\u0001\rC^\f\u0017\u000e\u001e+j[\u0016|W\u000f^\u0001\u000fgR\fw-\u001b8h%\u0016dW-Y:f\u0003\u0019a\u0014N\\5u}Qi1-\u001a4hQ&T7\u000e\\7o_B\u0004\"\u0001\u001a\u0001\u000e\u0003yAQ\u0001L\u0007A\u00025BQ\u0001O\u0007A\u00025BQ!O\u0007A\u00025BQAO\u0007A\u0002mBQAP\u0007A\u0002}BQ\u0001S\u0007A\u0002%CQ\u0001T\u0007A\u0002%CQ!T\u0007A\u00029CQ\u0001V\u0007A\u0002UCQaW\u0007A\u0002qCQaX\u0007A\u0002%CQ\u0001Y\u0007A\u0002m\"2b\u0019:tiV4x\u000f_={w\")AF\u0004a\u0001[!)\u0001H\u0004a\u0001[!)\u0011H\u0004a\u0001[!)!H\u0004a\u0001w!)aH\u0004a\u0001\u007f!)\u0001J\u0004a\u0001\u0013\")AJ\u0004a\u0001\u0013\")QJ\u0004a\u0001\u001d\")qL\u0004a\u0001\u0013\"9\u0001M\u0004I\u0001\u0002\u0004Y\u0004F\u0003\b~\u0003\u0003\t\u0019!a\u0002\u0002\nA\u0011qE`\u0005\u0003\u007f\"\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f#!!\u0002\u0002;U\u001bX\rI8uQ\u0016\u0014\beY8ogR\u0014Xo\u0019;pe\u0002Jgn\u001d;fC\u0012\fQa]5oG\u0016\f#!a\u0003\u0002\u00175LG\u000e\u001c\u00111]E\u0002d\u0006O\u000b\u0003\u0003\u001f\u00012\u0001ZA\t\u0013\r\t\u0019B\b\u0002\u0010'>t\u0017\r^=qK\"#H\u000f]!qS\u0006!\u0011\r]5!)!\tI\"a\b\u0002,\u0005U\u0002cA\u0014\u0002\u001c%\u0019\u0011Q\u0004\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003C\t\u0002\u0019AA\u0012\u0003-1\u0017\u000e\\3NCB\u0004\u0018N\\4\u0011\t\u0001+\u0015Q\u0005\t\u0006O\u0005\u001dR+L\u0005\u0004\u0003SA#A\u0002+va2,'\u0007C\u0004\u0002.E\u0001\r!a\f\u0002\u0011\u0005\u0014H/\u001b4bGR\u00042\u0001ZA\u0019\u0013\r\t\u0019D\b\u0002\t\u0003J$\u0018NZ1di\"1\u0011qG\tA\u0002m\nqA]3mK\u0006\u001cX-\u0001\u0006qk\nd\u0017n\u001d5BY2$b!!\u0007\u0002>\u0005}\u0002BBA\u001c%\u0001\u00071\bC\u0004\u0002BI\u0001\r!a\u0011\u0002\u0013\u0005\u0014H/\u001b4bGR\u001c\b#B\u0014\u0002F\u0005%\u0013bAA$Q\tQAH]3qK\u0006$X\r\u001a \u0011\u000f\u001d\n9#a\t\u00020\u0005y\u0001/\u001e2mSND7K\\1qg\"|G\u000f\u0006\u0004\u0002\u001a\u0005=\u00131\r\u0005\b\u0003#\u001a\u0002\u0019AA*\u0003!\u0001\u0018-\u001f7pC\u0012\u001c\b\u0003\u0002!F\u0003+\u0002baJA\u0014[\u0005]\u0003#B\u0014\u0002Z\u0005u\u0013bAA.Q\t)\u0011I\u001d:bsB\u0019q%a\u0018\n\u0007\u0005\u0005\u0004F\u0001\u0003CsR,\u0007bBA!'\u0001\u0007\u0011Q\r\t\u0005\u0001\u0016\u000by#\u0001\u0007qk\nd\u0017n\u001d5U_V\u0013\u0018\u000e\u0006\u0005\u0002\u001a\u0005-\u0014QNA8\u0011\u001d\t\t\u0006\u0006a\u0001\u0003'Bq!!\u0011\u0015\u0001\u0004\t)\u0007C\u0003-)\u0001\u0007Q&\u0001\rqk\nd\u0017n\u001d5SK2,\u0017m]3O_:\u001cH/Y4j]\u001e$b!!\u0007\u0002v\u0005]\u0004bBA)+\u0001\u0007\u00111\u000b\u0005\b\u0003\u0003*\u0002\u0019AA3\u00039\u0001XO\u00197jg\"\u0014V\r\\3bg\u0016$B\"!\u0007\u0002~\u0005}\u0014\u0011QAC\u0003\u000fCa!a\u000e\u0017\u0001\u0004Y\u0004bBA)-\u0001\u0007\u00111\u000b\u0005\u0007\u0003\u00073\u0002\u0019A\u0017\u0002\u001dM$\u0018mZ5oOB\u0013xNZ5mK\"9\u0011\u0011\t\fA\u0002\u0005\u0015\u0004\"B0\u0017\u0001\u0004I\u0015\u0001\u0006:fa>\u0014H\u000fU;cY&\u001c\bNU3tk2$8\u000f\u0006\u0004\u0002\u001a\u00055\u0015q\u0014\u0005\b\u0003\u001f;\u0002\u0019AAI\u00039\u0001XO\u00197jg\"\u0014Vm];miN\u0004B\u0001Q#\u0002\u0014B!\u0011QSAN\u001b\t\t9J\u0003\u0002\u0002\u001a\u0006A!/Z9vKN$8/\u0003\u0003\u0002\u001e\u0006]%\u0001\u0003*fgB|gn]3\t\u000f\u0005\u0005s\u00031\u0001\u0002f\u0005y\u0011m^1jiJ+\u0007o\\*uCR,8\u000f\u0006\u0005\u0002\u001a\u0005\u0015\u0016\u0011VAW\u0011\u0019\t9\u000b\u0007a\u0001[\u000511\u000f^1ukNDa!a+\u0019\u0001\u0004i\u0013!D:uC\u001eLgn\u001a*fa>LE\rC\u0003`1\u0001\u0007\u0011*A\tT_:\fG/\u001f9f!V\u0014G.[:iKJ\u0004\"\u0001\u001a\u000e\u0014\u0005i1CCAAY\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\"!a/+\u0007m\nil\u000b\u0002\u0002@B!\u0011\u0011YAf\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0017!C;oG\",7m[3e\u0015\r\tI\rK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAg\u0003\u0007\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SonatypePublisher {
    private final String uri;
    private final String snapshotUri;
    private final boolean signed;
    private final Seq<String> gpgArgs;
    private final Logger log;
    private final Path workspace;
    private final Map<String, String> env;
    private final int awaitTimeout;
    private final boolean stagingRelease;
    private final SonatypeHttpApi api;

    public static boolean $lessinit$greater$default$10() {
        return SonatypePublisher$.MODULE$.$lessinit$greater$default$10();
    }

    private SonatypeHttpApi api() {
        return this.api;
    }

    public void publish(Seq<Tuple2<Path, String>> fileMapping, Artifact artifact, boolean release) {
        this.publishAll(release, ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(fileMapping), artifact)}));
    }

    public void publishAll(boolean release, Seq<Tuple2<Seq<Tuple2<Path, String>>, Artifact>> artifacts2) {
        Seq<Tuple2<Artifact, Seq<Tuple2<String, byte[]>>>> mappings = SonatypeHelpers$.MODULE$.getArtifactMappings(this.signed, this.gpgArgs, this.workspace, this.env, artifacts2);
        Tuple2 tuple2 = mappings.partition((Function1<Tuple2, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(SonatypePublisher.$anonfun$publishAll$1(x$1)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq snapshots = (Seq)tuple2._1();
        Seq releases = (Seq)tuple2._2();
        Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(snapshots, releases);
        Seq snapshots2 = tuple22._1();
        Seq releases2 = tuple22._2();
        if (snapshots2.nonEmpty()) {
            this.publishSnapshot((Seq)snapshots2.flatMap((Function1<Tuple2, Seq> & Serializable)x$3 -> (Seq)x$3._2()), (Seq)snapshots2.map((Function1<Tuple2, Artifact> & Serializable)x$4 -> (Artifact)x$4._1()));
        }
        Map releaseGroups = releases2.groupBy((Function1<Tuple2, String> & Serializable)x$5 -> ((Artifact)x$5._1()).group());
        releaseGroups.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(SonatypePublisher.$anonfun$publishAll$5(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$10 -> {
            SonatypePublisher.$anonfun$publishAll$6(this, release, releases2, x$10);
            return BoxedUnit.UNIT;
        });
    }

    private void publishSnapshot(Seq<Tuple2<String, byte[]>> payloads, Seq<Artifact> artifacts2) {
        this.publishToUri(payloads, artifacts2, this.snapshotUri);
    }

    private void publishToUri(Seq<Tuple2<String, byte[]>> payloads, Seq<Artifact> artifacts2, String uri) {
        Seq publishResults = (Seq)payloads.map((Function1<Tuple2, Response> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String fileName = (String)tuple2._1();
                byte[] data = (byte[])tuple2._2();
                $this.log.info(new StringBuilder(10).append("Uploading ").append(fileName).toString());
                return this.api().upload(new StringBuilder(1).append(uri).append("/").append(fileName).toString(), data);
            }
            throw new MatchError(tuple2);
        });
        this.reportPublishResults(publishResults, artifacts2);
    }

    private void publishReleaseNonstaging(Seq<Tuple2<String, byte[]>> payloads, Seq<Artifact> artifacts2) {
        this.publishToUri(payloads, artifacts2, this.uri);
    }

    private void publishRelease(boolean release, Seq<Tuple2<String, byte[]>> payloads, String stagingProfile, Seq<Artifact> artifacts2, int awaitTimeout) {
        String profileUri = this.api().getStagingProfileUri(stagingProfile);
        String stagingRepoId = this.api().createStagingRepo(profileUri, stagingProfile);
        String baseUri = new StringBuilder(30).append(this.uri).append("/staging/deployByRepositoryId/").append(stagingRepoId).toString();
        this.publishToUri(payloads, artifacts2, baseUri);
        if (release) {
            this.log.info("Closing staging repository");
            this.api().closeStagingRepo(profileUri, stagingRepoId);
            this.log.info("Waiting for staging repository to close");
            this.awaitRepoStatus("closed", stagingRepoId, awaitTimeout);
            this.log.info("Promoting staging repository");
            this.api().promoteStagingRepo(profileUri, stagingRepoId);
            this.log.info("Waiting for staging repository to release");
            this.awaitRepoStatus("released", stagingRepoId, awaitTimeout);
            this.log.info("Dropping staging repository");
            this.api().dropStagingRepo(profileUri, stagingRepoId);
            this.log.info(new StringBuilder(23).append("Published ").append(((IterableOnceOps)artifacts2.map((Function1<Artifact, String> & Serializable)x$11 -> x$11.id())).mkString(", ")).append(" successfully").toString());
            return;
        }
    }

    private void reportPublishResults(Seq<Response> publishResults, Seq<Artifact> artifacts2) {
        if (publishResults.forall((Function1<Response, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(x$12.is2xx()))) {
            this.log.info(new StringBuilder(22).append("Published ").append(((IterableOnceOps)artifacts2.map((Function1<Artifact, String> & Serializable)x$13 -> x$13.id())).mkString(", ")).append(" to Sonatype").toString());
            return;
        }
        Seq errors = (Seq)((IterableOps)publishResults.filterNot((Function1<Response, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(x$14.is2xx()))).map((Function1<Response, String> & Serializable)response -> new StringBuilder(17).append("Code: ").append(response.statusCode()).append(", message: ").append(response.text()).toString());
        throw new RuntimeException(new StringBuilder(41).append("Failed to publish ").append(((IterableOnceOps)artifacts2.map((Function1<Artifact, String> & Serializable)x$15 -> x$15.id())).mkString(", ")).append(" to Sonatype. Errors: \n").append(errors.mkString("\n")).toString());
    }

    private void awaitRepoStatus(String status, String stagingRepoId, int awaitTimeout) {
        int attemptsLeft = awaitTimeout / 3000;
        while (attemptsLeft > 0 && !this.isRightStatus$1(stagingRepoId, status)) {
            Thread.sleep(3000L);
            if (--attemptsLeft != 0) continue;
            throw new RuntimeException(new StringBuilder(52).append("Couldn't wait for staging repository to be ").append(status).append(". Failing").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$publishAll$1(Tuple2 x$1) {
        return ((Artifact)x$1._1()).isSnapshot();
    }

    public static final /* synthetic */ boolean $anonfun$publishAll$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$publishAll$6(SonatypePublisher $this, boolean release$1, Seq releases$1, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 != null) {
            String group2 = (String)tuple2._1();
            Seq groupReleases = (Seq)tuple2._2();
            if ($this.stagingRelease) {
                $this.publishRelease(release$1, (Seq)groupReleases.flatMap((Function1<Tuple2, Seq> & Serializable)x$6 -> (Seq)x$6._2()), group2, (Seq)releases$1.map((Function1<Tuple2, Artifact> & Serializable)x$7 -> (Artifact)x$7._1()), $this.awaitTimeout);
                return;
            }
            $this.publishReleaseNonstaging((Seq)groupReleases.flatMap((Function1<Tuple2, Seq> & Serializable)x$8 -> (Seq)x$8._2()), (Seq)releases$1.map((Function1<Tuple2, Artifact> & Serializable)x$9 -> (Artifact)x$9._1()));
            return;
        }
        throw new MatchError(tuple2);
    }

    private final boolean isRightStatus$1(String stagingRepoId$1, String status$1) {
        return this.api().getStagingRepoState(stagingRepoId$1).equalsIgnoreCase(status$1);
    }

    public SonatypePublisher(String uri, String snapshotUri, String credentials, boolean signed, Seq<String> gpgArgs, int readTimeout, int connectTimeout, Logger log, Path workspace, Map<String, String> env, int awaitTimeout, boolean stagingRelease) {
        this.uri = uri;
        this.snapshotUri = snapshotUri;
        this.signed = signed;
        this.gpgArgs = gpgArgs;
        this.log = log;
        this.workspace = workspace;
        this.env = env;
        this.awaitTimeout = awaitTimeout;
        this.stagingRelease = stagingRelease;
        this.api = new SonatypeHttpApi(uri, credentials, readTimeout, connectTimeout);
    }

    public SonatypePublisher(String uri, String snapshotUri, String credentials, boolean signed, Seq<String> gpgArgs, int readTimeout, int connectTimeout, Logger log, int awaitTimeout, boolean stagingRelease) {
        this(uri, snapshotUri, credentials, signed, gpgArgs, readTimeout, connectTimeout, log, os.package$.MODULE$.pwd(), package$.MODULE$.env(), awaitTimeout, stagingRelease);
    }
}

