/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.validate.AttributeValidator;
import guru.nidi.graphviz.attribute.validate.ValidatorEngine;
import guru.nidi.graphviz.attribute.validate.ValidatorFormat;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.SerializerImpl;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(Serializer.class);
    private final ValidatorEngine engine;
    private final ValidatorFormat format;
    @Nullable
    private final Consumer<ValidatorMessage> messageConsumer;

    public Serializer() {
        this(ValidatorEngine.UNKNOWN_ENGINE, ValidatorFormat.UNKNOWN_FORMAT, ValidatorMessage.loggingConsumer(LOG));
    }

    private Serializer(ValidatorEngine engine, ValidatorFormat format, @Nullable Consumer<ValidatorMessage> messageConsumer) {
        this.engine = engine;
        this.format = format;
        this.messageConsumer = messageConsumer;
    }

    public Serializer forEngine(ValidatorEngine engine) {
        return new Serializer(engine, this.format, this.messageConsumer);
    }

    public Serializer forFormat(ValidatorFormat format) {
        return new Serializer(this.engine, format, this.messageConsumer);
    }

    public Serializer notValidating() {
        return new Serializer(this.engine, this.format, null);
    }

    public Serializer validating(Consumer<ValidatorMessage> messageConsumer) {
        return new Serializer(this.engine, this.format, messageConsumer);
    }

    public String serialize(Graph graph) {
        return this.serialize((MutableGraph)((Object)graph));
    }

    public String serialize(MutableGraph graph) {
        AttributeValidator validator = new AttributeValidator().forEngine(this.engine).forFormat(this.format);
        return new SerializerImpl(graph, validator, this.messageConsumer).serialize();
    }
}

