/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.nodes;

import coursier.util.shaded.org.jsoup.SerializationException;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Attribute;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.Entities;
import coursier.util.shaded.org.jsoup.nodes.LeafNode;
import java.io.IOException;

public class XmlDeclaration
extends LeafNode {
    private final boolean isProcessingInstruction;

    public XmlDeclaration(String name, boolean isProcessingInstruction) {
        super(name);
        this.isProcessingInstruction = isProcessingInstruction;
    }

    @Override
    public String nodeName() {
        return "#declaration";
    }

    public String name() {
        return this.coreValue();
    }

    public String getWholeDeclaration() {
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.getWholeDeclaration(sb, new Document.OutputSettings());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return StringUtil.releaseBuilder(sb).trim();
    }

    private void getWholeDeclaration(Appendable accum2, Document.OutputSettings out) throws IOException {
        for (Attribute attribute : this.attributes()) {
            String key2 = attribute.getKey();
            String val = attribute.getValue();
            if (key2.equals(this.nodeName())) continue;
            accum2.append(' ');
            accum2.append(key2);
            if (val.isEmpty()) continue;
            accum2.append("=\"");
            Entities.escape(accum2, val, out, 2);
            accum2.append('\"');
        }
    }

    @Override
    void outerHtmlHead(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        accum2.append("<").append(this.isProcessingInstruction ? "!" : "?").append(this.coreValue());
        this.getWholeDeclaration(accum2, out);
        accum2.append(this.isProcessingInstruction ? "!" : "?").append(">");
    }

    @Override
    void outerHtmlTail(Appendable accum2, int depth, Document.OutputSettings out) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public XmlDeclaration clone() {
        return (XmlDeclaration)super.clone();
    }
}

