/********************************************************************************
* File:   		log.h
* Date:   		2002-09-24
* Author: 		Alain Girardet/Dominik Blunk/Fernando Tarín
* Last Modified:	2002-10-24
*
* Description: Write attack & server results to logfile
*
*
* This program is free software; you can redistribute it and/or modify it under
* the terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version. See http://www.fsf.org/copyleft/gpl.txt.
*
* This program is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
* PARTICULAR PURPOSE. See the GNU General Public License for more details.
*
********************************************************************************/

#ifndef WEPDECRYPT_LOG_H
#define WEPDECRYPT_LOG_H

#include "wepdecrypt.h"

extern char logfile[40];

//
// start logging an writes header to logfile
//
void open_log(char *word, char *in);

//
// log cracked bssid with additional information
//
void log_bssid(wlan_packet_list* bssid);

//
// log all uncracked networks
//
void log_uncracked(wlan_packet_list* list, unsigned char * key, unsigned char use_modes);

//
// start logging of the server
//
void server_log_init(char * log_file, int mode, char * path, char * file_name, int port, char * block_size, int network_count);

//
// log messages from server
//
void server_log_message(char * log_file, const unsigned char * message);	

//
// log a decrypted key
//
void server_log_key(char * log_file, const unsigned char * decrypted_key, const unsigned char * decrypted_bssid, int mode);

//
// end logging of the server
//
void server_log_stop(char * log_file);

#endif
