/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.CharacterDataImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.util.Strings;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements Text {
    public TextImpl() {
        this("");
    }

    public TextImpl(String text) {
        this.text = text;
    }

    public boolean isElementContentWhitespace() {
        String t = this.text;
        return t == null || t.trim().equals("");
    }

    public Text replaceWholeText(String content) throws DOMException {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        if (parent == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        return parent.replaceAdjacentTextNodes(this, content);
    }

    public Text splitText(int offset) throws DOMException {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        if (parent == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        String t = this.text;
        if (offset < 0 || offset > t.length()) {
            throw new DOMException(1, "Bad offset: " + offset);
        }
        String content1 = t.substring(0, offset);
        String content2 = t.substring(offset);
        this.text = content1;
        TextImpl newNode = new TextImpl(content2);
        newNode.setOwnerDocument(this.document);
        return (Text)parent.insertAfter(newNode, this);
    }

    public String getWholeText() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        if (parent == null) {
            throw new DOMException(3, "Text node has no parent");
        }
        return parent.getTextContent();
    }

    public String getLocalName() {
        return null;
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeValue() throws DOMException {
        return this.text;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.text = nodeValue;
    }

    public void setTextContent(String textContent) throws DOMException {
        this.text = textContent;
    }

    protected Node createSimilarNode() {
        return new TextImpl(this.text);
    }

    public String toString() {
        String text = this.text;
        int textLength = text == null ? 0 : text.length();
        return "#text[length=" + textLength + ",value=\"" + Strings.truncate(text, 64) + "\",renderState=" + this.getRenderState() + "]";
    }
}

