/*
 * Decompiled with CFR 0.152.
 */
package plugin.jepcommands;

import java.util.Stack;
import java.util.logging.Level;
import org.nfunk.jep.ParseException;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.VariableProcessor;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.util.Logging;
import pcgen.util.PCGenCommand;

public class SkillInfoCommand
extends PCGenCommand {
    public SkillInfoCommand() {
        this.numberOfParameters = 2;
    }

    public String getFunctionName() {
        return "SKILLINFO";
    }

    public void run(Stack inStack) throws ParseException {
        Double result;
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        if (param1 instanceof String && param2 instanceof String) {
            PlayerCharacter pc = null;
            if (this.parent instanceof VariableProcessor) {
                pc = ((VariableProcessor)this.parent).getPc();
            } else if (this.parent instanceof PlayerCharacter) {
                pc = (PlayerCharacter)this.parent;
            }
            if (pc == null) {
                throw new ParseException("Invalid parent (no PC): " + this.parent.getClass().getName());
            }
            Skill aSkill = (Skill)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, param2.toString());
            result = null;
            if (aSkill != null && pc.getDisplay().hasSkill(aSkill)) {
                if ("modifier".equalsIgnoreCase((String)param1)) {
                    result = (double)SkillModifier.modifier((Skill)aSkill, (PlayerCharacter)pc);
                } else if ("rank".equalsIgnoreCase((String)param1)) {
                    result = pc.getDisplay().getRank(aSkill).doubleValue();
                } else if ("total".equalsIgnoreCase((String)param1)) {
                    result = (double)SkillRankControl.getTotalRank((PlayerCharacter)pc, (Skill)aSkill).intValue() + (double)SkillModifier.modifier((Skill)aSkill, (PlayerCharacter)pc).intValue();
                } else if ("totalrank".equalsIgnoreCase((String)param1)) {
                    result = SkillRankControl.getTotalRank((PlayerCharacter)pc, (Skill)aSkill).doubleValue();
                } else if ("stat".equalsIgnoreCase((String)param1)) {
                    result = SkillModifier.getStatMod((Skill)aSkill, (PlayerCharacter)pc);
                } else if ("misc".equalsIgnoreCase((String)param1)) {
                    result = SkillModifier.modifier((Skill)aSkill, (PlayerCharacter)pc) - SkillModifier.getStatMod((Skill)aSkill, (PlayerCharacter)pc);
                } else {
                    Logging.log((Level)Logging.LST_ERROR, (String)("Ignoring unknown parameter '" + param1 + "' in Skillinfo call: skillinfo(\"" + param1 + "\",\"" + param2 + "\")"));
                    result = 0.0;
                }
            } else {
                result = 0.0;
            }
        } else {
            throw new ParseException("Invalid parameter type");
        }
        inStack.push(result);
    }
}

