/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.math.BigDecimal;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class WtToken
extends AbstractNonEmptyToken<Equipment>
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "WT";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Equipment eq, String value) {
        try {
            BigDecimal weight = new BigDecimal(value);
            if (weight.compareTo(BigDecimal.ZERO) < 0) {
                return new ParseResult.Fail(this.getTokenName() + " was expecting a decimal value >= 0 : " + value, context);
            }
            context.getObjectContext().put((CDOMObject)eq, ObjectKey.WEIGHT, (Object)weight);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Expected a Double for " + this.getTokenName() + ": " + value, context);
        }
    }

    public String[] unparse(LoadContext context, Equipment eq) {
        BigDecimal weight = (BigDecimal)context.getObjectContext().getObject((CDOMObject)eq, ObjectKey.WEIGHT);
        if (weight == null) {
            return null;
        }
        if (weight.compareTo(BigDecimal.ZERO) < 0) {
            context.addWriteMessage(this.getTokenName() + " was expecting a decimal value >= 0 : " + weight);
            return null;
        }
        return new String[]{weight.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

