/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes.gui;

import gmgen.GMGenSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.apache.commons.lang.SystemUtils;
import pcgen.gui2.tools.Icons;
import pcgen.util.Logging;
import plugin.notes.NotesPlugin;

public class JIcon
extends JPanel {
    File launch;
    NotesPlugin plugin;
    private JButton button;
    private JLabel label;
    private JMenuItem deleteMI;
    private JMenuItem launchMI;
    private JPopupMenu contextMenu;

    public JIcon(File name, NotesPlugin plugin) {
        this.plugin = plugin;
        this.initComponents();
        if (name.getName().length() > 18) {
            this.label.setText(" " + name.getName().substring(0, 15) + "... ");
        } else {
            this.label.setText(" " + name.getName() + " ");
        }
        this.button.setIcon(this.getIconForType(name.getName()));
        this.button.setToolTipText(name.getName());
        this.launch = name;
    }

    public ImageIcon getIconForType(String filename) {
        String ext = filename.replaceFirst(".*\\.", "");
        if (ext.equalsIgnoreCase("html") || ext.equalsIgnoreCase("htm")) {
            return Icons.createImageIcon("gnome-text-html.png");
        }
        if (ext.equalsIgnoreCase("doc")) {
            return Icons.createImageIcon("win-word.png");
        }
        if (ext.equalsIgnoreCase("pdf")) {
            return Icons.createImageIcon("win-acrobat.png");
        }
        if (ext.equalsIgnoreCase("rtf")) {
            return Icons.createImageIcon("gnome-application-rtf.png");
        }
        if (ext.equalsIgnoreCase("xls")) {
            return Icons.createImageIcon("win-excel.png");
        }
        if (ext.equalsIgnoreCase("ppt")) {
            return Icons.createImageIcon("gnome-application-vnd.ms-powerpoint.png");
        }
        if (ext.equalsIgnoreCase("txt")) {
            return Icons.createImageIcon("gnome-text-plain.png");
        }
        if (ext.equalsIgnoreCase("fcw")) {
            return Icons.createImageIcon("win-cc2.png");
        }
        if (ext.equalsIgnoreCase("zip")) {
            return Icons.createImageIcon("win-zip.png");
        }
        if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("gif") || ext.equalsIgnoreCase("png")) {
            return Icons.createImageIcon("gnome-image-generic.png");
        }
        return Icons.createImageIcon("gnome-generic.png");
    }

    protected void deleteFile() {
        int choice = JOptionPane.showConfirmDialog(GMGenSystem.inst, "Delete file " + this.launch.getPath(), "Delete File?", 0, 3);
        if (choice == 0) {
            try {
                this.launch.delete();
                Container cnt = this.getParent();
                cnt.remove(this);
                if (cnt instanceof JComponent) {
                    JComponent comp = (JComponent)cnt;
                    comp.updateUI();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void launchFile() {
        if (this.plugin.isRecognizedFileType(this.launch)) {
            this.plugin.loadRecognizedFileType(this.launch);
        } else {
            Desktop d;
            boolean opened = false;
            if (Desktop.isDesktopSupported() && (d = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                try {
                    d.open(this.launch);
                    opened = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!opened) {
                if (SystemUtils.IS_OS_UNIX) {
                    String openCmd = SystemUtils.IS_OS_MAC_OSX ? "/usr/bin/open" : "xdg-open";
                    String filePath = this.launch.getAbsolutePath();
                    String[] args = new String[]{openCmd, filePath};
                    Logging.debugPrintLocalised("Runtime.getRuntime().exec: [{0}] [{1}]", args[0], args[1]);
                    try {
                        Runtime.getRuntime().exec(args);
                    }
                    catch (IOException e) {
                        Logging.errorPrint(e.getMessage(), e);
                    }
                }
                if (SystemUtils.IS_OS_WINDOWS) {
                    try {
                        String start = " rundll32 url.dll,FileProtocolHandler file://" + this.launch.getAbsoluteFile();
                        Runtime.getRuntime().exec(start);
                    }
                    catch (Exception e) {
                        Logging.errorPrint(e.getMessage(), e);
                    }
                }
            }
        }
    }

    private void buttonActionPerformed(ActionEvent evt) {
    }

    private void buttonFocusGained(FocusEvent evt) {
        this.setBackground(SystemColor.textHighlight);
        this.button.setBackground(SystemColor.textHighlight);
    }

    private void buttonFocusLost(FocusEvent evt) {
        this.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.button.setBackground((Color)UIManager.getDefaults().get("Button.background"));
    }

    private void buttonKeyReleased(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 127) {
            this.deleteFile();
        } else if (key == 10) {
            this.launchFile();
        }
    }

    private void buttonMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            this.launchFile();
        }
    }

    private void buttonMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.contextMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void deleteMIActionPerformed(ActionEvent evt) {
        this.deleteFile();
    }

    private void initComponents() {
        this.contextMenu = new JPopupMenu();
        this.launchMI = new JMenuItem();
        this.deleteMI = new JMenuItem();
        this.button = new JButton();
        this.label = new JLabel();
        this.launchMI.setText("Launch File (enter)");
        this.launchMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIcon.this.launchMIActionPerformed(evt);
            }
        });
        this.contextMenu.add(this.launchMI);
        this.deleteMI.setText("Delete File (del)");
        this.deleteMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIcon.this.deleteMIActionPerformed(evt);
            }
        });
        this.contextMenu.add(this.deleteMI);
        this.setLayout(new BorderLayout());
        this.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.button.setBackground((Color)UIManager.getDefaults().get("Button.background"));
        this.button.setBorder(null);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIcon.this.buttonActionPerformed(evt);
            }
        });
        this.button.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                JIcon.this.buttonFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                JIcon.this.buttonFocusLost(evt);
            }
        });
        this.button.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JIcon.this.buttonKeyReleased(evt);
            }
        });
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JIcon.this.buttonMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JIcon.this.buttonMouseReleased(evt);
            }
        });
        this.add((Component)this.button, "North");
        this.label.setBackground(new Color(204, 204, 204));
        this.add((Component)this.label, "Center");
    }

    private void launchMIActionPerformed(ActionEvent evt) {
        this.launchFile();
    }
}

