/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbstractExportToken;
import pcgen.util.enumeration.Load;

public class BaseMovementToken
extends AbstractExportToken {
    @Override
    public String getTokenName() {
        return "BASEMOVEMENT";
    }

    @Override
    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        String retString = "";
        if (display.getRace() != null && !display.getRace().equals(Globals.s_EMPTYRACE)) {
            StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
            aTok.nextToken();
            String moveType = "WALK";
            Load load = Load.LIGHT;
            boolean flag = true;
            if (aTok.hasMoreElements()) {
                moveType = aTok.nextToken();
                try {
                    int movNum = Integer.parseInt(moveType);
                    if (movNum < display.getNumberOfMovements()) {
                        moveType = display.getMovementValues().get(movNum).getName();
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (aTok.hasMoreElements()) {
                String loadName = aTok.nextToken();
                for (Load aLoad : Load.values()) {
                    if (!loadName.equals(aLoad.toString())) continue;
                    load = aLoad;
                }
            }
            if (aTok.hasMoreElements()) {
                flag = "TRUE".equalsIgnoreCase(aTok.nextToken());
            }
            retString = BaseMovementToken.getBaseMovementToken(display, moveType, load, flag);
        }
        return retString;
    }

    public static String getBaseMovementToken(CharacterDisplay display, String moveType, Load load, boolean displayFlag) {
        if (!display.hasMovement(moveType)) {
            return "";
        }
        int baseMovement = display.getBaseMovement(moveType, load);
        if (displayFlag) {
            return moveType + " " + Globals.getGameModeUnitSet().displayDistanceInUnitSet(baseMovement) + Globals.getGameModeUnitSet().getDistanceUnit();
        }
        return Globals.getGameModeUnitSet().displayDistanceInUnitSet(baseMovement);
    }
}

