/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import pcgen.util.CollectionMap;

public abstract class AbstractCollectionMap<K, V, C extends Collection<V>>
extends AbstractMap<K, C>
implements CollectionMap<K, V, C> {
    private volatile Collection<V> values = null;

    @Override
    public boolean add(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(K key, Collection<? extends V> values) {
        Collection collection = (Collection)this.get(key);
        return collection != null && collection.addAll(values);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object key : this.keySet()) {
            if (!((Collection)this.get(key)).contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object key, Object value) {
        Collection collection = (Collection)this.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Object key, Collection<?> c) {
        Collection collection = (Collection)this.get(key);
        return collection != null && collection.removeAll(c);
    }

    @Override
    public boolean retainAll(Object key, Collection<?> c) {
        Collection collection = (Collection)this.get(key);
        return collection != null && collection.retainAll(c);
    }

    @Override
    public int size(Object key) {
        Collection collection = (Collection)this.get(key);
        if (collection != null) {
            return collection.size();
        }
        return 0;
    }

    @Override
    public Collection<V> getAll() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<C> ci;
                        private Iterator<V> vi;
                        {
                            this.ci = AbstractCollectionMap.this.values().iterator();
                            this.vi = null;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.ci.hasNext() || this.vi != null && this.vi.hasNext();
                        }

                        @Override
                        public V next() {
                            if (this.vi == null || !this.vi.hasNext()) {
                                this.vi = ((Collection)this.ci.next()).iterator();
                            }
                            return this.vi.next();
                        }

                        @Override
                        public void remove() {
                            this.vi.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    int size = 0;
                    for (Collection collection : AbstractCollectionMap.this.values()) {
                        size += collection.size();
                    }
                    return size;
                }

                @Override
                public boolean contains(Object v) {
                    return AbstractCollectionMap.this.containsValue(v);
                }
            };
        }
        return this.values;
    }
}

