/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.util.LinkedList;
import org.apache.commons.lang.math.Fraction;
import pcgen.system.PCGenTask;
import pcgen.system.PCGenTaskEvent;
import pcgen.system.PCGenTaskListener;

public class PCGenTaskExecutor
extends PCGenTask
implements PCGenTaskListener {
    private LinkedList<PCGenTask> tasks = new LinkedList();
    private PCGenTask currentTask = null;
    private Fraction progressMultiplier = null;
    private Fraction baseProgress = Fraction.ZERO;

    public void addPCGenTask(PCGenTask task) {
        this.tasks.add(task);
    }

    @Override
    public void execute() {
        this.progressMultiplier = Fraction.getFraction(1, this.tasks.size());
        while (!this.tasks.isEmpty()) {
            this.currentTask = this.tasks.poll();
            this.setValues(this.currentTask.getMessage(), this.baseProgress.getNumerator(), this.baseProgress.getDenominator());
            this.currentTask.addPCGenTaskListener(this);
            this.currentTask.execute();
            this.currentTask.removePCGenTaskListener(this);
            this.baseProgress = this.baseProgress.add(this.progressMultiplier);
        }
    }

    @Override
    public void progressChanged(PCGenTaskEvent event) {
        if (this.currentTask.getMaximum() == 0) {
            return;
        }
        Fraction progress = Fraction.getFraction(this.currentTask.getProgress(), this.currentTask.getMaximum());
        progress = progress.multiplyBy(this.progressMultiplier);
        progress = this.baseProgress.add(progress);
        this.setValues(this.currentTask.getMessage(), progress.getNumerator(), progress.getDenominator());
    }

    @Override
    public void errorOccurred(PCGenTaskEvent event) {
        this.sendErrorMessage(event.getErrorRecord());
    }
}

