/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.Version;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.PCStringKey;
import pcgen.core.AbilityCategory;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.Follower;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.SkillDisplay;
import pcgen.core.utils.CoreUtility;
import pcgen.io.ExportException;
import pcgen.io.FORNode;
import pcgen.io.FileAccess;
import pcgen.io.IIFNode;
import pcgen.io.exporttoken.AbilityListToken;
import pcgen.io.exporttoken.AbilityToken;
import pcgen.io.exporttoken.BonusToken;
import pcgen.io.exporttoken.EqToken;
import pcgen.io.exporttoken.EqTypeToken;
import pcgen.io.exporttoken.GameModeToken;
import pcgen.io.exporttoken.MovementToken;
import pcgen.io.exporttoken.SkillToken;
import pcgen.io.exporttoken.SkillpointsToken;
import pcgen.io.exporttoken.StatToken;
import pcgen.io.exporttoken.Token;
import pcgen.io.exporttoken.TotalToken;
import pcgen.io.exporttoken.WeaponToken;
import pcgen.io.exporttoken.WeaponhToken;
import pcgen.io.freemarker.EquipSetLoopDirective;
import pcgen.io.freemarker.LoopDirective;
import pcgen.io.freemarker.PCBooleanFunction;
import pcgen.io.freemarker.PCHasVarFunction;
import pcgen.io.freemarker.PCStringDirective;
import pcgen.io.freemarker.PCVarFunction;
import pcgen.output.publish.OutputDB;
import pcgen.system.PluginLoader;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;

public final class ExportHandler {
    private static final Float JEP_TRUE = new Float(1.0);
    private static Map<String, Token> tokenMap = new HashMap<String, Token>();
    private static boolean tokenMapPopulated;
    private boolean existsOnly;
    private boolean noMoreItems;
    private boolean manualWhitespace;
    private File templateFile;
    private final Map<Object, Object> loopVariables = new HashMap<Object, Object>();
    private final Map<Object, Object> loopParameters = new HashMap<Object, Object>();
    private String csheetTag2 = "\\";
    private boolean skipMath;
    private boolean canWrite = true;
    private boolean checkBefore;
    private boolean inLabel;
    private ExportEngine exportEngine;

    public ExportHandler(File templateFile) {
        ExportHandler.populateTokenMap();
        this.setTemplateFile(templateFile);
        this.decideExportEngine();
    }

    public void replaceTokenSkipMath(PlayerCharacter aPC, String aString, BufferedWriter output) {
        boolean oldSkipMath = this.skipMath;
        this.skipMath = true;
        this.replaceToken(aString, output, aPC);
        this.skipMath = oldSkipMath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PlayerCharacter aPC, BufferedWriter out) throws ExportException {
        if (this.templateFile == null) {
            throw new IllegalStateException("Template file must not be null");
        }
        if (this.exportEngine == ExportEngine.FREEMARKER) {
            FileAccess.setCurrentOutputFilter(this.templateFile.getName().substring(0, this.templateFile.getName().length() - 4));
            this.exportCharacterUsingFreemarker(aPC, out);
            return;
        }
        FileAccess.setCurrentOutputFilter(this.templateFile.getName());
        BufferedReader br = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(this.templateFile);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            StringBuilder template = this.prepareTemplate(br);
            StringTokenizer tokenizer = new StringTokenizer(template.toString(), Constants.LINE_SEPARATOR, false);
            FileAccess fileAccess = new FileAccess();
            FORNode root = this.parseFORsAndIIFs(tokenizer);
            this.loopVariables.put(null, "0");
            this.existsOnly = false;
            this.noMoreItems = false;
            this.loopFOR(root, 0, 0, 1, out, fileAccess, aPC);
            this.loopVariables.clear();
        }
        catch (IOException exc) {
            Logging.errorPrint("Error in ExportHandler::write", exc);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Logging.errorPrint("Error closing off the character sheet template in ExportHandler::write", e);
                }
            }
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException e) {
                    Logging.errorPrint("Error flushing the output in ExportHandler::write", e);
                }
            }
        }
        this.csheetTag2 = "\\";
    }

    private void exportCharacterUsingFreemarker(PlayerCharacter aPC, BufferedWriter outputWriter) throws ExportException {
        Configuration cfg = new Configuration();
        try {
            cfg.setDirectoryForTemplateLoading(this.templateFile.getParentFile());
            cfg.setIncompatibleImprovements(new Version("2.3.20"));
            Template template = cfg.getTemplate(this.templateFile.getName());
            cfg.setSharedVariable("pcstring", (TemplateModel)new PCStringDirective(aPC, this));
            cfg.setSharedVariable("pcvar", (TemplateModel)new PCVarFunction(aPC));
            cfg.setSharedVariable("pcboolean", (TemplateModel)new PCBooleanFunction(aPC, this));
            cfg.setSharedVariable("pchasvar", (TemplateModel)new PCHasVarFunction(aPC, this));
            cfg.setSharedVariable("loop", (TemplateModel)new LoopDirective());
            cfg.setSharedVariable("equipsetloop", (TemplateModel)new EquipSetLoopDirective(aPC));
            GameMode gamemode = SettingsHandler.getGame();
            Map<String, Object> pc = OutputDB.buildDataModel(aPC.getCharID());
            Map<String, Object> mode = OutputDB.buildModeDataModel(gamemode);
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("pcgen", OutputDB.getGlobal());
            input.put("pc", ObjectWrapper.DEFAULT_WRAPPER.wrap(pc));
            input.put("gamemode", mode);
            input.put("gamemodename", gamemode.getName());
            template.process(input, (Writer)outputWriter);
        }
        catch (IOException exc) {
            String message = "Error exporting character using template " + this.templateFile;
            Logging.errorPrint(message, exc);
            throw new ExportException(exc, message + " : " + exc.getLocalizedMessage());
        }
        catch (TemplateException e) {
            String message = "Error exporting character using template " + this.templateFile;
            Logging.errorPrint(message, e);
            throw new ExportException(e, message + " : " + e.getLocalizedMessage());
        }
        finally {
            if (outputWriter != null) {
                try {
                    outputWriter.flush();
                }
                catch (Exception e2) {}
            }
        }
    }

    private StringBuilder prepareTemplate(BufferedReader br) throws IOException {
        Pattern pat = Pattern.compile(Pattern.quote("||"));
        String rep = Matcher.quoteReplacement("| |");
        StringBuilder inputLine = new StringBuilder();
        String aString = br.readLine();
        while (aString != null) {
            Matcher mat = pat.matcher(aString);
            inputLine.append(mat.replaceAll(rep));
            inputLine.append(Constants.LINE_SEPARATOR);
            aString = br.readLine();
        }
        return inputLine;
    }

    public void write(Collection<PlayerCharacter> PCs, BufferedWriter out) {
        this.write(PCs.toArray(new PlayerCharacter[PCs.size()]), out);
    }

    private void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    private void decideExportEngine() {
        this.exportEngine = ExportEngine.PCGEN;
        if (this.templateFile != null && this.templateFile.getName().toLowerCase().endsWith(".ftl")) {
            this.exportEngine = ExportEngine.FREEMARKER;
        }
    }

    private int getVarValue(String varString, PlayerCharacter aPC) {
        String valueString;
        String vString = varString;
        vString = this.processCountEquipmentTokens(vString, aPC);
        vString = this.processStringLengthTokens(vString, aPC);
        if (varString.startsWith("${") && varString.endsWith("}")) {
            String jepString = varString.substring(2, varString.length() - 1);
            valueString = jepString.replace(';', ',');
        } else {
            valueString = vString;
        }
        Float floatValue = aPC.getVariableValue(valueString, "");
        return floatValue.intValue();
    }

    private String processCountEquipmentTokens(String vString, PlayerCharacter aPC) {
        int countIndex = vString.indexOf("COUNT[EQ");
        while (countIndex >= 0) {
            int i;
            char chC = vString.charAt(countIndex + 8);
            if ((chC == '.' || chC >= '0' && chC <= '9') && (i = vString.indexOf(93, countIndex + 8)) >= 0) {
                String aString = vString.substring(countIndex + 6, i);
                EqToken token = null;
                token = aString.indexOf("EQTYPE") > -1 ? new EqTypeToken() : new EqToken();
                String baString = token.getToken(aString, aPC, this);
                vString = vString.substring(0, countIndex) + baString + vString.substring(i + 1);
            }
            countIndex = vString.indexOf("COUNT[EQ", countIndex + 1);
        }
        return vString;
    }

    private String processStringLengthTokens(String vString, PlayerCharacter aPC) {
        int strlenIndex = vString.indexOf("STRLEN[", 0);
        while (strlenIndex >= 0) {
            int i = vString.indexOf(93, strlenIndex + 7);
            if (i >= 0) {
                String aString = vString.substring(strlenIndex + 7, i);
                StringWriter sWriter = new StringWriter();
                BufferedWriter aWriter = new BufferedWriter(sWriter);
                this.replaceToken(aString, aWriter, aPC);
                sWriter.flush();
                try {
                    aWriter.flush();
                }
                catch (IOException e) {
                    Logging.errorPrint("Error flushing outputstream in ExportHandler::getVarValue", e);
                }
                String result = sWriter.toString();
                vString = vString.substring(0, strlenIndex) + result.length() + vString.substring(i + 1);
            }
            strlenIndex = vString.indexOf("STRLEN[", strlenIndex + 1);
        }
        return vString;
    }

    public static void addToTokenMap(Token newToken) {
        Token test = tokenMap.put(newToken.getTokenName(), newToken);
        if (test != null) {
            Logging.errorPrint("More than one Output Token has the same Token Name: '" + newToken.getTokenName() + "'");
        }
    }

    public static PluginLoader getPluginLoader() {
        return new PluginLoader(){

            @Override
            public void loadPlugin(Class<?> clazz) throws Exception {
                Token pl = (Token)clazz.newInstance();
                ExportHandler.addToTokenMap(pl);
            }

            public Class[] getPluginClasses() {
                return new Class[]{Token.class};
            }
        };
    }

    private String replaceVariables(String expr, Map<Object, Object> variables) {
        ArrayList<Object> keys = new ArrayList<Object>(variables.keySet());
        Collections.sort(keys, new VariableComparator());
        for (Object anObject : variables.keySet()) {
            if (anObject == null) continue;
            String fString = anObject.toString();
            String rString = variables.get(fString).toString();
            expr = expr.replaceAll(Pattern.quote(fString), rString);
        }
        return expr;
    }

    private boolean evaluateExpression(String expr, PlayerCharacter aPC) {
        StringWriter sRightWriter;
        StringWriter sLeftWriter;
        String rightToken;
        String leftToken;
        block24: {
            if (expr.indexOf(".AND.") > 0) {
                String part1 = expr.substring(0, expr.indexOf(".AND."));
                String part2 = expr.substring(expr.indexOf(".AND.") + 5);
                return this.evaluateExpression(part1, aPC) && this.evaluateExpression(part2, aPC);
            }
            if (expr.indexOf(".OR.") > 0) {
                String part1 = expr.substring(0, expr.indexOf(".OR."));
                String part2 = expr.substring(expr.indexOf(".OR.") + 4);
                return this.evaluateExpression(part1, aPC) || this.evaluateExpression(part2, aPC);
            }
            String expr1 = expr;
            expr1 = this.replaceVariables(expr1, this.loopParameters);
            if ((expr1 = this.replaceVariables(expr1, this.loopVariables)).startsWith("HASVAR:")) {
                return aPC.getVariableValue(expr1 = expr1.substring(7).trim(), "").intValue() > 0;
            }
            if (expr1.startsWith("HASFEAT:")) {
                expr1 = expr1.substring(8).trim();
                return aPC.hasAbilityKeyed(AbilityCategory.FEAT, expr1);
            }
            if (expr1.startsWith("HASSA:")) {
                expr1 = expr1.substring(6).trim();
                return aPC.hasSpecialAbility(expr1);
            }
            if (expr1.startsWith("HASEQUIP:")) {
                return aPC.getEquipmentNamed(expr1 = expr1.substring(9).trim()) != null;
            }
            if (expr1.startsWith("SPELLCASTER:")) {
                return this.processSpellcasterExpression(expr1, aPC);
            }
            if (expr1.startsWith("EVEN:")) {
                int i = 0;
                try {
                    i = Integer.parseInt(expr1.substring(5).trim());
                }
                catch (NumberFormatException exc) {
                    Logging.errorPrint("EVEN:" + i);
                    return true;
                }
                return i % 2 == 0;
            }
            if (expr1.endsWith("UNTRAINED") && !expr1.startsWith("SKILLSIT.")) {
                List<Skill> pcSkills;
                int i;
                StringTokenizer aTok = new StringTokenizer(expr1, ".");
                String fString = aTok.nextToken();
                CDOMObject aSkill = null;
                if (fString.length() > 5 && (i = Integer.parseInt(fString.substring(5))) <= (pcSkills = SkillDisplay.getSkillListInOutputOrder(aPC)).size() - 1) {
                    aSkill = pcSkills.get(i);
                }
                if (aSkill == null) {
                    return false;
                }
                return aSkill.getSafe(ObjectKey.USE_UNTRAINED) != false;
            }
            Float res = aPC.getVariableProcessor().getJepOnlyVariableValue(null, expr1, "", 0);
            if (res != null) {
                return res.equals(JEP_TRUE);
            }
            StringTokenizer aTok = new StringTokenizer(expr1, ":");
            int tokenCount = aTok.countTokens();
            if (tokenCount == 1) {
                leftToken = expr1;
                rightToken = "TRUE";
            } else {
                if (tokenCount != 2) {
                    Logging.errorPrint("evaluateExpression: Incorrect syntax (missing parameter)");
                    return false;
                }
                leftToken = aTok.nextToken();
                rightToken = aTok.nextToken();
            }
            sLeftWriter = new StringWriter();
            BufferedWriter leftWriter = new BufferedWriter(sLeftWriter);
            this.replaceToken(leftToken, leftWriter, aPC);
            sLeftWriter.flush();
            sRightWriter = new StringWriter();
            BufferedWriter rightWriter = new BufferedWriter(sRightWriter);
            this.replaceToken(rightToken, rightWriter, aPC);
            sRightWriter.flush();
            try {
                leftWriter.flush();
                rightWriter.flush();
            }
            catch (IOException ignore) {
                if (!Logging.isDebugMode()) break block24;
                Logging.debugPrint("Could not flush output buffer in evaluateExpression", ignore);
            }
        }
        String leftString = sLeftWriter.toString();
        if (leftToken.startsWith("VAR.")) {
            leftString = aPC.getVariableValue(leftToken.substring(4), "").toString();
        }
        String rightString = sRightWriter.toString();
        if (rightToken.startsWith("VAR.")) {
            rightString = aPC.getVariableValue(rightToken.substring(4), "").toString();
        }
        try {
            int left = Integer.parseInt(leftString);
            int right = Integer.parseInt(rightString);
            return left == right;
        }
        catch (NumberFormatException e) {
            if (rightString.startsWith("=")) {
                return leftString.equals(rightString.substring(1));
            }
            return 0 <= leftString.toUpperCase().indexOf(rightString.toUpperCase());
        }
    }

    private boolean processSpellcasterExpression(String expr1, PlayerCharacter aPC) {
        String fString = expr1.substring(12).trim();
        if (fString.indexOf(61) != -1) {
            StringTokenizer aTok = new StringTokenizer(fString, "=", false);
            int i = Integer.parseInt(aTok.nextToken());
            String cs = aTok.nextToken();
            ArrayList<PCClass> cList = aPC.getClassList();
            if (i >= cList.size()) {
                return false;
            }
            PCClass aClass = (PCClass)cList.get(i);
            if (cs.equalsIgnoreCase(aClass.getSpellType())) {
                return true;
            }
            if (cs.equalsIgnoreCase(aClass.getKeyName())) {
                return true;
            }
            if ("!Prepare".equalsIgnoreCase(cs) && aClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue()) {
                return true;
            }
            if ("Prepare".equalsIgnoreCase(cs) && !aClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue()) {
                return true;
            }
        } else {
            for (PCClass pcClass : aPC.getClassSet()) {
                if (fString.equalsIgnoreCase(pcClass.getSpellType())) {
                    return true;
                }
                if (fString.equalsIgnoreCase(pcClass.getKeyName())) {
                    return true;
                }
                if ("!Prepare".equalsIgnoreCase(fString) && pcClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue()) {
                    return true;
                }
                if (!"Prepare".equalsIgnoreCase(fString) || pcClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue()) continue;
                return true;
            }
        }
        Logging.errorPrint("Should have exited before this in ExportHandler::processSpellcasterExpression");
        return false;
    }

    private void evaluateIIF(IIFNode node, BufferedWriter output, FileAccess fa, PlayerCharacter aPC) {
        String aString = node.expr().replaceAll(Pattern.quote(";"), ",");
        if (this.evaluateExpression(aString, aPC)) {
            this.evaluateIIFChildren(node.trueChildren(), output, fa, aPC);
        } else {
            this.evaluateIIFChildren(node.falseChildren(), output, fa, aPC);
        }
    }

    private void evaluateIIFChildren(List<?> children, BufferedWriter output, FileAccess fa, PlayerCharacter aPC) {
        for (Object aChild : children) {
            if (aChild instanceof FORNode) {
                FORNode nextFor = (FORNode)aChild;
                this.loopVariables.put(nextFor.var(), 0);
                this.existsOnly = nextFor.exists();
                String minString = nextFor.min();
                String maxString = nextFor.max();
                String stepString = nextFor.step();
                minString = this.replaceVariables(minString, this.loopParameters);
                minString = this.replaceVariables(minString, this.loopVariables);
                maxString = this.replaceVariables(maxString, this.loopParameters);
                maxString = this.replaceVariables(maxString, this.loopVariables);
                stepString = this.replaceVariables(stepString, this.loopParameters);
                stepString = this.replaceVariables(stepString, this.loopVariables);
                int minValue = this.getVarValue(minString, aPC);
                int maxValue = this.getVarValue(maxString, aPC);
                int stepValue = this.getVarValue(stepString, aPC);
                String var = nextFor.var();
                this.loopParameters.put(var + "!MIN", minValue);
                this.loopParameters.put(var + "!MAX", maxValue);
                this.loopParameters.put(var + "!STEP", stepValue);
                this.loopFOR(nextFor, minValue, maxValue, stepValue, output, fa, aPC);
                this.loopParameters.remove(var + "!MIN");
                this.loopParameters.remove(var + "!MAX");
                this.loopParameters.remove(var + "!STEP");
                this.existsOnly = nextFor.exists();
                this.loopVariables.remove(nextFor.var());
                continue;
            }
            if (aChild instanceof IIFNode) {
                this.evaluateIIF((IIFNode)aChild, output, fa, aPC);
                continue;
            }
            String lineString = (String)aChild;
            lineString = this.replaceVariables(lineString, this.loopParameters);
            lineString = this.replaceVariables(lineString, this.loopVariables);
            this.replaceLine(lineString, output, aPC);
            if (!this.canWrite || this.manualWhitespace) continue;
            FileAccess.newLine(output);
        }
    }

    private void loopFOR(FORNode node, int start, int end, int step, BufferedWriter output, FileAccess fa, PlayerCharacter aPC) {
        int x = start;
        while ((step < 0 ? x >= end : x <= end) && !this.processLoop(node, output, fa, aPC, x)) {
            x += step;
        }
    }

    private boolean processLoop(FORNode node, BufferedWriter output, FileAccess fa, PlayerCharacter aPC, int index) {
        this.loopVariables.put(node.var(), index);
        int numberOfChildrenNodes = node.children().size();
        for (int y = 0; y < numberOfChildrenNodes; ++y) {
            if (node.children().get(y) instanceof FORNode) {
                FORNode nextFor = (FORNode)node.children().get(y);
                this.loopVariables.put(nextFor.var(), 0);
                this.existsOnly = nextFor.exists();
                String minString = nextFor.min();
                String maxString = nextFor.max();
                String stepString = nextFor.step();
                minString = this.replaceVariables(minString, this.loopParameters);
                minString = this.replaceVariables(minString, this.loopVariables);
                maxString = this.replaceVariables(maxString, this.loopParameters);
                maxString = this.replaceVariables(maxString, this.loopVariables);
                stepString = this.replaceVariables(stepString, this.loopParameters);
                stepString = this.replaceVariables(stepString, this.loopVariables);
                int varMin = this.getVarValue(minString, aPC);
                int varMax = this.getVarValue(maxString, aPC);
                int varStep = this.getVarValue(stepString, aPC);
                String var = nextFor.var();
                this.loopParameters.put(var + "!MIN", varMin);
                this.loopParameters.put(var + "!MAX", varMax);
                this.loopParameters.put(var + "!STEP", varMax);
                this.loopFOR(nextFor, varMin, varMax, varStep, output, fa, aPC);
                this.loopParameters.remove(var + "!MIN");
                this.loopParameters.remove(var + "!MAX");
                this.loopParameters.remove(var + "!STEP");
                this.existsOnly = node.exists();
                this.loopVariables.remove(nextFor.var());
                continue;
            }
            if (node.children().get(y) instanceof IIFNode) {
                this.evaluateIIF((IIFNode)node.children().get(y), output, fa, aPC);
                continue;
            }
            String lineString = (String)node.children().get(y);
            lineString = this.replaceVariables(lineString, this.loopParameters);
            lineString = this.replaceVariables(lineString, this.loopVariables);
            this.noMoreItems = false;
            this.replaceLine(lineString, output, aPC);
            if (this.canWrite && !this.manualWhitespace) {
                FileAccess.newLine(output);
            }
            if (!this.existsOnly || !this.noMoreItems) continue;
            return true;
        }
        return false;
    }

    private String mathMode(String aString, PlayerCharacter aPC) {
        String str = aString;
        str = this.processBracketedTokens(str, aPC);
        str = str.replaceAll(Pattern.quote("["), "(");
        str = str.replaceAll(Pattern.quote("]"), ")");
        String delimiter = "+-/*";
        String valString = "";
        boolean ADDITION_MODE = false;
        boolean SUBTRACTION_MODE = true;
        int MULTIPLICATION_MODE = 2;
        int DIVISION_MODE = 3;
        int mode = 0;
        int nextMode = 0;
        boolean REGULAR_MODE = false;
        boolean INTVAL_MODE = true;
        int SIGN_MODE = 2;
        int NO_ZERO_MODE = 3;
        int endMode = 0;
        boolean attackRoutine = false;
        String attackData = "";
        Float total = new Float(0.0);
        for (int i = 0; i < str.length(); ++i) {
            String bString;
            valString = valString + str.substring(i, i + 1);
            if (i != str.length() - 1 && ("+-/*".lastIndexOf(str.charAt(i)) <= -1 || i <= 0 || str.charAt(i - 1) == '.')) continue;
            if ("+-/*".lastIndexOf(str.charAt(i)) > -1) {
                valString = valString.substring(0, valString.length() - 1);
            }
            if (i < str.length()) {
                if (valString.endsWith(".TRUNC")) {
                    if (attackRoutine) {
                        Logging.errorPrint("Math Mode Error: Not allowed to use .TRUNC in Attack Mode.");
                    } else {
                        valString = String.valueOf(Float.valueOf(this.mathMode(valString.substring(0, valString.length() - 6), aPC)).intValue());
                    }
                }
                if (valString.endsWith(".INTVAL")) {
                    if (attackRoutine) {
                        Logging.errorPrint("Math Mode Error: Using .INTVAL in Attack Mode.");
                    } else {
                        valString = this.mathMode(valString.substring(0, valString.length() - 7), aPC);
                    }
                    endMode = 1;
                }
                if (valString.endsWith(".SIGN")) {
                    valString = this.mathMode(valString.substring(0, valString.length() - 5), aPC);
                    endMode = 2;
                }
                if (valString.endsWith(".NOZERO")) {
                    valString = this.mathMode(valString.substring(0, valString.length() - 7), aPC);
                    endMode = 3;
                }
                if (str.length() > 0 && str.charAt(i) == '+') {
                    nextMode = 0;
                } else if (str.length() > 0 && str.charAt(i) == '-') {
                    nextMode = 1;
                } else if (str.length() > 0 && str.charAt(i) == '*') {
                    nextMode = 2;
                } else if (str.length() > 0 && str.charAt(i) == '/') {
                    nextMode = 3;
                }
                StringWriter sWriter = new StringWriter();
                BufferedWriter aWriter = new BufferedWriter(sWriter);
                this.replaceTokenSkipMath(aPC, valString, aWriter);
                sWriter.flush();
                try {
                    aWriter.flush();
                }
                catch (IOException e) {
                    Logging.errorPrint("Failed to flush oputput in MathMode.", e);
                }
                bString = sWriter.toString();
                try {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
                    DecimalFormat decimalFormat = new DecimalFormat("#,##0.##", decimalFormatSymbols);
                    valString = String.valueOf(decimalFormat.parse(bString));
                }
                catch (ParseException e) {
                    valString = bString;
                }
                if (!attackRoutine && Pattern.matches("^([-+]\\d+/)*[-+]\\d+$", valString)) {
                    attackRoutine = true;
                    attackData = valString;
                    valString = "";
                }
            }
            try {
                if (valString.length() > 0) {
                    if (attackRoutine) {
                        StringTokenizer bTok = new StringTokenizer(attackData, "/");
                        if (bTok.countTokens() > 0) {
                            String newAttackData = "";
                            block21: while (bTok.hasMoreTokens()) {
                                bString = bTok.nextToken();
                                float bf = Float.parseFloat(bString);
                                float vf = Float.parseFloat(valString);
                                switch (mode) {
                                    case 0: {
                                        float addf = bf + vf;
                                        newAttackData = newAttackData + "/+" + Integer.toString((int)addf);
                                        continue block21;
                                    }
                                    case 1: {
                                        float subf = bf - vf;
                                        newAttackData = newAttackData + "/+" + Integer.toString((int)subf);
                                        continue block21;
                                    }
                                    case 2: {
                                        float multf = bf * vf;
                                        newAttackData = newAttackData + "/+" + Integer.toString((int)multf);
                                        continue block21;
                                    }
                                    case 3: {
                                        float divf = bf / vf;
                                        newAttackData = newAttackData + "/+" + Integer.toString((int)divf);
                                        continue block21;
                                    }
                                }
                                Logging.errorPrint("In mathMode the mode " + mode + " is unsupported.");
                            }
                            attackData = newAttackData.substring(1).replaceAll(Pattern.quote("+-"), "-");
                        }
                    } else {
                        switch (mode) {
                            case 0: {
                                total = new Float(total.doubleValue() + Double.parseDouble(valString));
                                break;
                            }
                            case 1: {
                                total = new Float(total.doubleValue() - Double.parseDouble(valString));
                                break;
                            }
                            case 2: {
                                total = new Float(total.doubleValue() * Double.parseDouble(valString));
                                break;
                            }
                            case 3: {
                                total = new Float(total.doubleValue() / Double.parseDouble(valString));
                                break;
                            }
                            default: {
                                Logging.errorPrint("In mathMode the mode " + mode + " is unsupported.");
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException exc) {
                StringWriter sWriter = new StringWriter();
                BufferedWriter aWriter = new BufferedWriter(sWriter);
                this.replaceTokenSkipMath(aPC, str, aWriter);
                sWriter.flush();
                try {
                    aWriter.flush();
                }
                catch (IOException e) {
                    Logging.errorPrint("Math Mode Error: Could not flush output.");
                }
                return sWriter.toString();
            }
            mode = nextMode;
            nextMode = 0;
            valString = "";
        }
        if (attackRoutine) {
            return attackData;
        }
        if (endMode == 1) {
            return Integer.toString(total.intValue());
        }
        if (endMode == 2) {
            return Delta.toString(total.intValue());
        }
        if (endMode == 3) {
            int totalIntValue = total.intValue();
            if (totalIntValue == 0) {
                return "";
            }
            return Delta.toString(totalIntValue);
        }
        return total.toString();
    }

    private String processBracketedTokens(String str, PlayerCharacter aPC) {
        while (str.lastIndexOf(40) != -1) {
            int x = CoreUtility.innerMostStringStart(str);
            int y = CoreUtility.innerMostStringEnd(str);
            if (y < x) {
                Logging.debugPrint("End is before start for string processing.  We are skipping the processing of this item.");
                break;
            }
            String bString = str.substring(x + 1, y);
            if (x > 0 && str.charAt(x - 1) == ' ' && (str.charAt(y + 1) == '.' || y == str.length() - 1)) {
                str = str.substring(0, x) + "[" + bString + "]" + str.substring(y + 1);
                continue;
            }
            str = str.substring(0, x) + this.mathMode(bString, aPC) + str.substring(y + 1);
        }
        return str;
    }

    private void outputNonToken(String nonToken, Writer output) {
        if (this.canWrite && nonToken.length() != 0) {
            String finalToken = null;
            finalToken = this.manualWhitespace ? nonToken.replaceAll("[ \\t]", "") : nonToken;
            FileAccess.write(output, finalToken);
        }
    }

    private FORNode parseFORsAndIIFs(StringTokenizer tokens) {
        FORNode root = new FORNode(null, "0", "0", "1", false);
        while (tokens.hasMoreTokens()) {
            String line = tokens.nextToken();
            if (line.startsWith("|FOR")) {
                StringTokenizer newFor = new StringTokenizer(line, ",");
                if (newFor.countTokens() > 1) {
                    newFor.nextToken();
                    if (newFor.nextToken().startsWith("%")) {
                        root.addChild(this.parseFORs(line, tokens));
                        continue;
                    }
                    root.addChild(line);
                    continue;
                }
                root.addChild(line);
                continue;
            }
            if (line.startsWith("|IIF(") && line.lastIndexOf(44) == -1) {
                String expr = line.substring(5, line.lastIndexOf(41));
                root.addChild(this.parseIIFs(expr, tokens));
                continue;
            }
            root.addChild(line);
        }
        return root;
    }

    private FORNode parseFORs(String forLine, StringTokenizer tokens) {
        List<String> forVars = ExportHandler.getParameters(forLine);
        String var = forVars.get(1);
        String min = forVars.get(2);
        String max = forVars.get(3);
        String step = forVars.get(4);
        String eTest = forVars.get(5);
        boolean exists = false;
        if (eTest.length() > 0 && eTest.charAt(0) == '1' || eTest.length() > 0 && eTest.charAt(0) == '2') {
            exists = true;
        }
        FORNode node = new FORNode(var, min, max, step, exists);
        while (tokens.hasMoreTokens()) {
            String line = tokens.nextToken();
            if (line.startsWith("|FOR")) {
                StringTokenizer newFor = new StringTokenizer(line, ",");
                newFor.nextToken();
                if (newFor.nextToken().startsWith("%")) {
                    node.addChild(this.parseFORs(line, tokens));
                    continue;
                }
                node.addChild(line);
                continue;
            }
            if (line.startsWith("|IIF(") && line.lastIndexOf(44) == -1) {
                String expr = line.substring(5, line.lastIndexOf(41));
                node.addChild(this.parseIIFs(expr, tokens));
                continue;
            }
            if (line.startsWith("|ENDFOR|")) {
                return node;
            }
            node.addChild(line);
        }
        return node;
    }

    public static List<String> getParameters(String forToken) {
        String[] splitStr = forToken.split(",");
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean inFormula = false;
        for (String string : splitStr) {
            if (string.indexOf("(") >= 0 && string.indexOf(")") < string.indexOf("(")) {
                inFormula = true;
                buf.append(string);
                continue;
            }
            if (inFormula && string.indexOf(")") >= 0) {
                inFormula = false;
                buf.append(",");
                buf.append(string);
                result.add(buf.toString());
                buf = new StringBuilder();
                continue;
            }
            if (inFormula) {
                buf.append(",");
                buf.append(string);
                continue;
            }
            result.add(string);
        }
        return result;
    }

    private IIFNode parseIIFs(String expr, StringTokenizer tokens) {
        IIFNode node = new IIFNode(expr);
        boolean trueCase = true;
        while (tokens.hasMoreTokens()) {
            String line = tokens.nextToken();
            if (line.startsWith("|FOR")) {
                StringTokenizer newFor = new StringTokenizer(line, ",");
                newFor.nextToken();
                if (newFor.nextToken().startsWith("%")) {
                    if (trueCase) {
                        node.addTrueChild(this.parseFORs(line, tokens));
                        continue;
                    }
                    node.addFalseChild(this.parseFORs(line, tokens));
                    continue;
                }
                if (trueCase) {
                    node.addTrueChild(line);
                    continue;
                }
                node.addFalseChild(line);
                continue;
            }
            if (line.startsWith("|IIF(") && line.lastIndexOf(44) == -1) {
                String newExpr = line.substring(5, line.lastIndexOf(41));
                if (trueCase) {
                    node.addTrueChild(this.parseIIFs(newExpr, tokens));
                    continue;
                }
                node.addFalseChild(this.parseIIFs(newExpr, tokens));
                continue;
            }
            if (line.startsWith("|ELSE|")) {
                trueCase = false;
                continue;
            }
            if (line.startsWith("|ENDIF|")) {
                return node;
            }
            if (trueCase) {
                node.addTrueChild(line);
                continue;
            }
            node.addFalseChild(line);
        }
        return node;
    }

    private static void populateTokenMap() {
        if (!tokenMapPopulated) {
            ExportHandler.addToTokenMap(new AbilityToken());
            ExportHandler.addToTokenMap(new AbilityListToken());
            ExportHandler.addToTokenMap(new BonusToken());
            ExportHandler.addToTokenMap(new EqToken());
            ExportHandler.addToTokenMap(new EqTypeToken());
            ExportHandler.addToTokenMap(new GameModeToken());
            ExportHandler.addToTokenMap(new MovementToken());
            ExportHandler.addToTokenMap(new SkillToken());
            ExportHandler.addToTokenMap(new SkillpointsToken());
            ExportHandler.addToTokenMap(new StatToken());
            ExportHandler.addToTokenMap(new TotalToken());
            ExportHandler.addToTokenMap(new WeaponToken());
            ExportHandler.addToTokenMap(new WeaponhToken());
            tokenMapPopulated = true;
        }
    }

    private void replaceLine(String aLine, BufferedWriter output, PlayerCharacter aPC) {
        int lastIndex = aLine.lastIndexOf(124);
        if (lastIndex < 0 && aLine.length() > 0) {
            this.outputNonToken(aLine, output);
        }
        if (lastIndex >= 1) {
            StringTokenizer aTok = new StringTokenizer(aLine, "|", false);
            boolean inPipe = false;
            if (aLine.charAt(0) == '|') {
                inPipe = true;
            }
            boolean lastIsPipe = false;
            if (aLine.charAt(aLine.length() - 1) == '|') {
                lastIsPipe = true;
            }
            while (aTok.hasMoreTokens()) {
                String tok = aTok.nextToken();
                if (inPipe) {
                    if (aTok.hasMoreTokens() || lastIsPipe) {
                        this.replaceToken(tok, output, aPC);
                    }
                } else {
                    this.outputNonToken(tok, output);
                }
                if (!aTok.hasMoreTokens()) continue;
                inPipe = !inPipe;
            }
        }
    }

    public int replaceToken(String aString, BufferedWriter output, PlayerCharacter aPC) {
        try {
            if (this.isPlainText(aString)) {
                return 0;
            }
            if ("%".equals(aString)) {
                this.inLabel = false;
                this.canWrite = true;
                return 0;
            }
            if (aString.startsWith("${") && aString.endsWith("}")) {
                String jepString = aString.substring(2, aString.length() - 1);
                String variableValue = aPC.getVariableValue(jepString, "").toString();
                FileAccess.write(output, variableValue);
                return aString.trim().length();
            }
            FileAccess.maxLength(-1);
            if (this.isFilterToken(aString)) {
                return this.dealWithFilteredTokens(aString, aPC);
            }
            String tokenString = aString;
            if (this.isValidSubToken(tokenString)) {
                tokenString = this.replaceSubToken(tokenString);
            }
            ExportHandler.populateTokenMap();
            StringTokenizer tok = new StringTokenizer(tokenString, ".,", false);
            String firstToken = tok.nextToken();
            String testString = tokenString;
            if (testString.indexOf(44) > -1) {
                testString = testString.substring(0, testString.indexOf(44));
            }
            if (testString.indexOf(126) > -1) {
                testString = testString.substring(0, testString.indexOf(126));
            }
            int len = 1;
            if (this.isForOrDForToken(tokenString)) {
                this.processLoopToken(tokenString, output, aPC);
                return 0;
            }
            if (tokenString.startsWith("OIF(")) {
                this.replaceTokenOIF(tokenString, output, aPC);
            } else {
                if (this.containsMathematicalToken(testString) && !this.skipMath) {
                    FileAccess.maxLength(-1);
                    FileAccess.write(output, this.mathMode(tokenString, aPC));
                    return 0;
                }
                if (tokenString.startsWith("CSHEETTAG2.")) {
                    this.csheetTag2 = tokenString.substring(11, 12);
                    FileAccess.maxLength(-1);
                    return 0;
                }
                if (tokenMap.get(firstToken) != null) {
                    Token token = tokenMap.get(firstToken);
                    if (token.isEncoded()) {
                        FileAccess.encodeWrite(output, token.getToken(tokenString, aPC, this));
                    } else {
                        FileAccess.write(output, token.getToken(tokenString, aPC, this));
                    }
                } else {
                    len = tokenString.trim().length();
                    if (this.manualWhitespace) {
                        tokenString = tokenString.replaceAll("[ \\t]", "");
                        if (len > 0) {
                            FileAccess.write(output, tokenString);
                        }
                    } else {
                        FileAccess.write(output, tokenString);
                    }
                }
            }
            FileAccess.maxLength(-1);
            return len;
        }
        catch (Exception exc) {
            Logging.errorPrint("Error replacing " + aString, exc);
            return 0;
        }
    }

    private boolean isPlainText(String aString) {
        if (!this.canWrite && aString.length() > 0 && aString.charAt(0) != '%') {
            return true;
        }
        return aString.length() == 0;
    }

    private boolean isFilterToken(String aString) {
        return aString.length() > 0 && aString.charAt(0) == '%' && aString.length() > 1 && aString.lastIndexOf(60) == -1 && aString.lastIndexOf(62) == -1;
    }

    private boolean isValidSubToken(String tokenString) {
        return tokenString.indexOf("SUB") == 0 && tokenString.indexOf(".") > 3;
    }

    boolean isForOrDForToken(String tokenString) {
        return tokenString.startsWith("FOR.") || tokenString.startsWith("DFOR.");
    }

    private boolean containsMathematicalToken(String testString) {
        return testString.indexOf(43) >= 0 || testString.indexOf(45) >= 0 || testString.indexOf(".INTVAL") >= 0 || testString.indexOf(".SIGN") >= 0 || testString.indexOf(".NOZERO") >= 0 || testString.indexOf(".TRUNC") >= 0 || testString.indexOf(42) >= 0 || testString.indexOf(47) >= 0;
    }

    private String replaceSubToken(String tokenString) {
        int maxLength;
        int iEnd = tokenString.indexOf(".");
        try {
            maxLength = Integer.parseInt(tokenString.substring(3, iEnd));
        }
        catch (NumberFormatException ex) {
            Logging.errorPrint("Number format error: " + tokenString);
            maxLength = -1;
        }
        if (maxLength > 0) {
            tokenString = tokenString.substring(iEnd + 1);
            FileAccess.maxLength(maxLength);
        }
        return tokenString;
    }

    private void processLoopToken(String tokenString, BufferedWriter output, PlayerCharacter aPC) {
        FileAccess.maxLength(-1);
        this.existsOnly = false;
        this.noMoreItems = false;
        this.checkBefore = false;
        this.replaceTokenForDfor(tokenString, output, aPC);
        this.existsOnly = false;
        this.noMoreItems = false;
    }

    private int dealWithFilteredTokens(String aString, PlayerCharacter aPC) {
        StringTokenizer aTok;
        this.canWrite = true;
        int merge = this.getEquipmentMergingStrategy(aString);
        if (aString.substring(1).startsWith("GAMEMODE:")) {
            if (aString.substring(10).endsWith(GameModeToken.getGameModeToken())) {
                this.canWrite = false;
            }
            return 0;
        }
        CharacterDisplay display = aPC.getDisplay();
        if ("REGION".equals(aString.substring(1))) {
            if (display.getRegionString().equals("None")) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("NOTES".equals(aString.substring(1))) {
            if (aPC.getDisplay().getNotesCount() <= 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("SKILLPOINTS".equals(aString.substring(1))) {
            if (SkillpointsToken.getUnusedSkillPoints(aPC) == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if (aString.substring(1).startsWith("TEMPLATE")) {
            int index;
            StringTokenizer aTok2 = new StringTokenizer(aString.substring(1), ".");
            ArrayList<PCTemplate> tList = new ArrayList<PCTemplate>(aPC.getTemplateSet());
            String fString = aTok2.nextToken();
            if (aTok2.hasMoreTokens()) {
                index = Integer.parseInt(aTok2.nextToken());
            } else {
                if ("TEMPLATE".equals(fString)) {
                    if (tList.isEmpty()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                Logging.errorPrint("Old syntax %TEMPLATEx will be replaced for %TEMPLATE.x");
                index = Integer.parseInt(aString.substring(9));
            }
            if (index >= tList.size()) {
                this.canWrite = false;
                return 0;
            }
            PCTemplate template = (PCTemplate)tList.get(index);
            if (!template.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_EXPORT)) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("FOLLOWER".equals(aString.substring(1))) {
            if (!aPC.hasFollowers()) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("FOLLOWEROF".equals(aString.substring(1))) {
            if (aPC.getMasterPC() == null) {
                this.canWrite = false;
            }
            return 0;
        }
        if (aString.substring(1).startsWith("FOLLOWERTYPE.")) {
            ArrayList<Follower> aList = new ArrayList<Follower>();
            for (Follower follower : aPC.getFollowerList()) {
                for (PlayerCharacter pc : Globals.getPCList()) {
                    if (!pc.getFileName().equals(follower.getFileName())) continue;
                    aList.add(follower);
                }
            }
            StringTokenizer aTok3 = new StringTokenizer(aString, ".");
            aTok3.nextToken();
            String typeString = aTok3.nextToken();
            for (int i = aList.size() - 1; i >= 0; --i) {
                Follower fol = (Follower)aList.get(i);
                if (fol.getType().getKeyName().equalsIgnoreCase(typeString)) continue;
                aList.remove(i);
            }
            if (aList.isEmpty()) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("PROHIBITEDLIST".equals(aString.substring(1))) {
            for (PCClass pcClass : aPC.getClassSet()) {
                if (aPC.getLevel(pcClass) <= 0 || !pcClass.containsListFor(ListKey.PROHIBITED_SPELLS) && !aPC.containsProhibitedSchools(pcClass)) continue;
                return 0;
            }
            this.canWrite = false;
            return 0;
        }
        if ("CATCHPHRASE".equals(aString.substring(1))) {
            String catchPhrase = display.getCatchPhrase();
            if (catchPhrase.equals("None")) {
                this.canWrite = false;
            } else if (catchPhrase.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("LOCATION".equals(aString.substring(1))) {
            String location = display.getLocation();
            if (location.equals("None")) {
                this.canWrite = false;
            } else if (location.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("RESIDENCE".equals(aString.substring(1))) {
            String residence = aPC.getSafeStringFor(PCStringKey.RESIDENCE);
            if (residence.equals("None")) {
                this.canWrite = false;
            } else if (residence.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("PHOBIAS".equals(aString.substring(1))) {
            String phobias = display.getSafeStringFor(PCStringKey.PHOBIAS);
            if (phobias.equals("None")) {
                this.canWrite = false;
            } else if (phobias.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("INTERESTS".equals(aString.substring(1))) {
            String interests = display.getInterests();
            if (interests.equals("None")) {
                this.canWrite = false;
            } else if (interests.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("SPEECHTENDENCY".equals(aString.substring(1))) {
            String speechTendency = display.getSpeechTendency();
            if (speechTendency.equals("None")) {
                this.canWrite = false;
            } else if (speechTendency.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("PERSONALITY1".equals(aString.substring(1))) {
            String trait1 = display.getTrait1();
            if (trait1.equals("None")) {
                this.canWrite = false;
            } else if (trait1.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("PERSONALITY2".equals(aString.substring(1))) {
            String trait2 = display.getTrait2();
            if (trait2.equals("None")) {
                this.canWrite = false;
            } else if (trait2.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("MISC.FUNDS".equals(aString.substring(1))) {
            if (aPC.getSafeStringFor(PCStringKey.ASSETS).equals("None")) {
                this.canWrite = false;
            } else if (aPC.getSafeStringFor(PCStringKey.ASSETS).trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("COMPANIONS".equals(aString.substring(1)) || "MISC.COMPANIONS".equals(aString.substring(1))) {
            if (aPC.getSafeStringFor(PCStringKey.COMPANIONS).equals("None")) {
                this.canWrite = false;
            } else if (aPC.getSafeStringFor(PCStringKey.COMPANIONS).trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("MISC.MAGIC".equals(aString.substring(1))) {
            if (aPC.getSafeStringFor(PCStringKey.MAGIC).equals("None")) {
                this.canWrite = false;
            } else if (aPC.getSafeStringFor(PCStringKey.MAGIC).trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("DESC".equals(aString.substring(1))) {
            String description = display.getSafeStringFor(PCStringKey.DESCRIPTION);
            if (description.equals("None")) {
                this.canWrite = false;
            } else if (description.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("BIO".equals(aString.substring(1))) {
            String bio = display.getBio();
            if (bio.equals("None")) {
                this.canWrite = false;
            } else if (bio.trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("SUBREGION".equals(aString.substring(1))) {
            if (display.getSubRegion().equals("None")) {
                this.canWrite = false;
            }
            return 0;
        }
        if (aString.substring(1).startsWith("TEMPBONUS.")) {
            aTok = new StringTokenizer(aString.substring(1), ".");
            aTok.nextToken();
            int index = -1;
            if (aTok.hasMoreTokens()) {
                index = Integer.parseInt(aTok.nextToken());
            }
            if (index > aPC.getNamedTempBonusList().size()) {
                this.canWrite = false;
                return 0;
            }
            if (aPC.getUseTempMods()) {
                this.canWrite = true;
                return 1;
            }
        }
        if (aString.substring(1).startsWith("ARMOR.ITEM")) {
            int count;
            aTok = new StringTokenizer(aString.substring(1), ".");
            aTok.nextToken();
            String fString = aTok.nextToken();
            ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
            for (Equipment eq : aPC.getEquipmentListInOutputOrder()) {
                if (!eq.hasBonusWithInfo(aPC, "AC") || eq.isArmor() || eq.isShield()) continue;
                aArrayList.add(eq);
            }
            if (aTok.hasMoreTokens()) {
                count = Integer.parseInt(aTok.nextToken());
            } else {
                Logging.errorPrint("Old syntax %ARMOR.ITEMx will be replaced for %ARMOR.ITEM.x");
                count = Integer.parseInt(fString.substring(fString.length() - 1));
            }
            if (count > aArrayList.size()) {
                this.canWrite = false;
            }
            return 0;
        }
        if (aString.substring(1).startsWith("ARMOR.SHIELD")) {
            int count;
            aTok = new StringTokenizer(aString.substring(1), ".");
            aTok.nextToken();
            String fString = aTok.nextToken();
            List<Equipment> aArrayList = aPC.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
            if (aTok.hasMoreTokens()) {
                count = Integer.parseInt(aTok.nextToken());
            } else {
                Logging.errorPrint("Old syntax %ARMOR.SHIELDx will be replaced for %ARMOR.SHIELD.x");
                count = Integer.parseInt(fString.substring(fString.length() - 1));
            }
            if (count > aArrayList.size()) {
                this.canWrite = false;
            }
            return 0;
        }
        if (aString.substring(1).startsWith("ARMOR")) {
            int count;
            aTok = new StringTokenizer(aString.substring(1), ".");
            String fString = aTok.nextToken();
            List<Equipment> aArrayList = aPC.getEquipmentOfTypeInOutputOrder("ARMOR", 3);
            List<Equipment> shieldList = aPC.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
            for (int z = 0; z < shieldList.size(); ++z) {
                aArrayList.remove(shieldList.get(z));
            }
            if (aTok.hasMoreTokens()) {
                count = Integer.parseInt(aTok.nextToken());
            } else {
                Logging.errorPrint("Old syntax %ARMORx will be replaced for %ARMOR.x");
                count = Integer.parseInt(fString.substring(fString.length() - 1));
            }
            if (count > aArrayList.size()) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("WEAPONPROF".equals(aString.substring(1))) {
            if (!SettingsHandler.getWeaponProfPrintout()) {
                this.canWrite = false;
            }
            return 0;
        }
        if (aString.substring(1).startsWith("WEAPON")) {
            int count;
            aTok = new StringTokenizer(aString.substring(1), ".");
            String fString = aTok.nextToken();
            List<Equipment> aArrayList = aPC.getExpandedWeapons(merge);
            if (aTok.hasMoreTokens()) {
                count = Integer.parseInt(aTok.nextToken());
            } else {
                Logging.errorPrint("Old syntax %WEAPONx will be replaced for %WEAPON.x");
                count = Integer.parseInt(fString.substring(fString.length() - 1));
            }
            if (count >= aArrayList.size()) {
                this.canWrite = false;
            }
            return 0;
        }
        if (aString.substring(1).startsWith("DOMAIN")) {
            int index;
            aTok = new StringTokenizer(aString.substring(1), ".");
            String fString = aTok.nextToken();
            if (aTok.hasMoreTokens()) {
                index = Integer.parseInt(aTok.nextToken());
            } else {
                Logging.errorPrint("Old syntax %DOMAINx will be replaced for %DOMAIN.x");
                index = Integer.parseInt(fString.substring(6));
            }
            this.canWrite = index <= display.getDomainCount();
            return 0;
        }
        if (aString.substring(1).startsWith("SPELLLISTBOOK")) {
            if (SettingsHandler.getPrintSpellsWithPC()) {
                int i = aString.charAt(14) == '.' ? 15 : 14;
                return this.replaceTokenSpellListBook(aString.substring(i), aPC);
            }
            this.canWrite = false;
            return 0;
        }
        if (aString.substring(1).startsWith("VAR.")) {
            this.replaceTokenVar(aString, aPC);
            return 0;
        }
        if (aString.substring(1).startsWith("COUNT[")) {
            if (this.getVarValue(aString.substring(1), aPC) > 0) {
                this.canWrite = true;
                return 1;
            }
            this.canWrite = false;
            return 0;
        }
        aTok = new StringTokenizer(aString.substring(1), ",", false);
        boolean found = false;
        while (aTok.hasMoreTokens()) {
            PCClass aClass;
            String cString = aTok.nextToken();
            StringTokenizer bTok = new StringTokenizer(cString, "=", false);
            String bString = bTok.nextToken();
            int i = 0;
            if (bTok.hasMoreTokens()) {
                i = Integer.parseInt(bTok.nextToken());
            }
            boolean bl = found = (aClass = aPC.getClassKeyed(bString)) != null;
            if (aClass == null) {
                this.canWrite = false;
            } else {
                boolean bl2 = this.canWrite = aPC.getLevel(aClass) >= i;
            }
            if (!bString.startsWith("SPELLLISTCLASS")) continue;
            bString = bString.charAt(14) == '.' ? bString.substring(15) : bString.substring(14);
            found = true;
            PObject aObject = aPC.getSpellClassAtIndex(Integer.parseInt(bString));
            this.canWrite = aObject != null;
        }
        if (found) {
            this.inLabel = true;
            return 0;
        }
        this.canWrite = false;
        this.inLabel = true;
        Logging.debugPrint("Return 0 (don't write/no replacement) for an undetermined filter token.");
        return 0;
    }

    private int getEquipmentMergingStrategy(String aString) {
        int merge = 0;
        if (aString.indexOf("MERGENONE") > 0) {
            merge = 1;
        }
        if (aString.indexOf("MERGELOC") > 0) {
            merge = 2;
        }
        return merge;
    }

    private void replaceTokenForDfor(String aString, BufferedWriter output, PlayerCharacter aPC) {
        StringTokenizer aTok = aString.startsWith("DFOR.") ? new StringTokenizer(aString.substring(5), ",", false) : new StringTokenizer(aString.substring(4), ",", false);
        int cMin = 0;
        int cMax = 100;
        int cStep = 1;
        int cStepLine = 1;
        int cStepLineMax = 0;
        String cString = "";
        String cStartLineString = "";
        String cEndLineString = "";
        boolean isDFor = false;
        int i = 0;
        while (aTok.hasMoreTokens()) {
            String tokA = aTok.nextToken();
            switch (i) {
                case 0: {
                    cMin = this.getVarValue(tokA, aPC);
                    break;
                }
                case 1: {
                    cMax = this.getVarValue(tokA, aPC);
                    break;
                }
                case 2: {
                    cStep = this.getVarValue(tokA, aPC);
                    if (!aString.startsWith("DFOR.")) break;
                    isDFor = true;
                    cStepLineMax = this.getVarValue(aTok.nextToken(), aPC);
                    cStepLine = this.getVarValue(aTok.nextToken(), aPC);
                    break;
                }
                case 3: {
                    cString = tokA;
                    break;
                }
                case 4: {
                    cStartLineString = tokA;
                    break;
                }
                case 5: {
                    cEndLineString = tokA;
                    break;
                }
                case 6: {
                    boolean bl = this.existsOnly = !"0".equals(tokA);
                    if (!"2".equals(tokA)) break;
                    this.checkBefore = true;
                    break;
                }
                default: {
                    Logging.errorPrint("ExportHandler.replaceTokenForDfor can't handle token number " + i + " this probably means you've passed in too many parameters.");
                }
            }
            ++i;
        }
        if ("COMMA".equals(cStartLineString)) {
            cStartLineString = ",";
        }
        if ("COMMA".equals(cEndLineString)) {
            cEndLineString = ",";
        }
        if ("NONE".equals(cStartLineString)) {
            cStartLineString = "";
        }
        if ("NONE".equals(cEndLineString)) {
            cEndLineString = "";
        }
        if ("CRLF".equals(cStartLineString)) {
            cStartLineString = Constants.LINE_SEPARATOR;
        }
        if ("CRLF".equals(cEndLineString)) {
            cEndLineString = Constants.LINE_SEPARATOR;
        }
        int x = 0;
        for (int iStart = cMin; iStart < cMax; iStart += cStep) {
            if (x == 0) {
                FileAccess.write(output, cStartLineString);
            }
            ++x;
            int iNow = iStart;
            if (!isDFor) {
                cStepLineMax = iNow + cStep;
            }
            if (cStepLineMax > cMax && !isDFor) {
                cStepLineMax = cMax;
            }
            while (iNow < cStepLineMax || isDFor && iNow < cMax) {
                boolean insideToken = false;
                if (cString.startsWith(this.csheetTag2)) {
                    insideToken = true;
                }
                aTok = new StringTokenizer(cString, this.csheetTag2, false);
                int j = 0;
                while (aTok.hasMoreTokens()) {
                    String eString = aTok.nextToken();
                    String gString = "";
                    String hString = eString;
                    int index = 0;
                    while (hString.indexOf(37, index) > 0 && (index = hString.indexOf(37, index)) != -1) {
                        if (index < hString.length() - 1 && hString.charAt(index + 1) != '.') {
                            ++index;
                            continue;
                        }
                        String fString = hString.substring(0, index);
                        if (index + 1 < eString.length()) {
                            gString = hString.substring(index + 1);
                        }
                        hString = fString + Integer.toString(iNow) + gString;
                    }
                    if ("%0".equals(eString) || "%1".equals(eString)) {
                        int cInt = iNow + Integer.parseInt(eString.substring(1));
                        FileAccess.write(output, Integer.toString(cInt));
                    } else if (insideToken) {
                        this.replaceToken(hString, output, aPC);
                    } else {
                        boolean oldSkipMath = this.skipMath;
                        this.skipMath = true;
                        this.replaceToken(hString, output, aPC);
                        this.skipMath = oldSkipMath;
                    }
                    if (this.checkBefore && this.noMoreItems) {
                        iNow = cMax;
                        iStart = cMax;
                        if (j != 0) break;
                        this.existsOnly = false;
                        break;
                    }
                    ++j;
                    insideToken = !insideToken;
                }
                iNow += cStepLine;
                if (cStepLine != 0) continue;
                break;
            }
            if (cStepLine <= 0 && (cStepLine != 0 || x != cStep) && this.existsOnly != this.noMoreItems) continue;
            FileAccess.write(output, cEndLineString);
            x = 0;
            if (!this.existsOnly || !this.noMoreItems) continue;
            return;
        }
    }

    private void replaceTokenOIF(String aString, Writer output, PlayerCharacter aPC) {
        int iStart;
        int iParenCount = 0;
        String[] tokenizedString = new String[3];
        int iParamCount = 0;
        block5: for (int i = iStart = 4; i < aString.length() && iParamCount != 3; ++i) {
            switch (aString.charAt(i)) {
                case '(': {
                    ++iParenCount;
                    continue block5;
                }
                case ')': {
                    if (--iParenCount != -1) continue block5;
                    if (iParamCount == 2) {
                        tokenizedString[iParamCount] = aString.substring(iStart, i).trim();
                        ++iParamCount;
                        iStart = i + 1;
                        continue block5;
                    }
                    Logging.errorPrint("OIF: not enough parameters (" + Integer.toString(iParamCount) + ')');
                    for (int j = 0; j < iParamCount; ++j) {
                        Logging.errorPrint("  " + Integer.toString(j) + ':' + tokenizedString[j]);
                    }
                    continue block5;
                }
                case ',': {
                    if (iParenCount != 0) continue block5;
                    if (iParamCount < 2) {
                        tokenizedString[iParamCount] = aString.substring(iStart, i).trim();
                        iStart = i + 1;
                    } else {
                        Logging.errorPrint("OIF: too many parameters");
                    }
                    ++iParamCount;
                    continue block5;
                }
            }
        }
        String remainder = "";
        if (iParamCount != 3) {
            Logging.errorPrint("OIF: invalid parameter count: " + iParamCount);
        } else {
            remainder = aString.substring(iStart);
            int i = 0;
            i = this.evaluateExpression(tokenizedString[0], aPC) ? 1 : 2;
            FileAccess.write(output, tokenizedString[i]);
        }
        if (remainder.length() > 0) {
            Logging.errorPrint("OIF: extra characters on line: " + remainder);
            FileAccess.write(output, remainder);
        }
    }

    private int replaceTokenSpellListBook(String aString, PlayerCharacter aPC) {
        int sbookNum = 0;
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        int classNum = Integer.parseInt(aTok.nextToken());
        int levelNum = Integer.parseInt(aTok.nextToken());
        if (aTok.hasMoreTokens()) {
            sbookNum = Integer.parseInt(aTok.nextToken());
        }
        String bookName = Globals.getDefaultSpellBook();
        if (sbookNum > 0) {
            bookName = aPC.getDisplay().getSpellBookNames().get(sbookNum);
        }
        this.canWrite = false;
        PObject aObject = aPC.getSpellClassAtIndex(classNum);
        if (aObject != null) {
            List<CharacterSpell> aList = aPC.getCharacterSpells(aObject, null, bookName, levelNum);
            this.canWrite = !aList.isEmpty();
        }
        return 0;
    }

    private void replaceTokenVar(String aString, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(aString.substring(5), ".", false);
        String varName = aTok.nextToken();
        String bString = "EQ";
        boolean intVal = false;
        boolean maxVal = true;
        if (aTok.hasMoreTokens()) {
            bString = aTok.nextToken();
        }
        while ("INTVAL".equals(bString) || "MINVAL".equals(bString)) {
            if ("INTVAL".equals(bString)) {
                intVal = true;
            } else if ("MINVAL".equals(bString)) {
                maxVal = false;
            }
            if (aTok.hasMoreTokens()) {
                bString = aTok.nextToken();
                continue;
            }
            Logging.errorPrint("Missing comparison type in VAR filter " + aString + " assuming NEQ");
            bString = "NEQ";
        }
        String value = "0";
        if (aTok.hasMoreTokens()) {
            value = aTok.nextToken();
        }
        Float varval = aPC.getVariable(varName, maxVal);
        if (intVal) {
            varval = Float.valueOf((float)Math.floor(varval.floatValue()));
        }
        Float valval = aPC.getVariableValue(value, "");
        if ("GTEQ".equals(bString)) {
            this.canWrite = varval.doubleValue() >= valval.doubleValue();
        } else if ("GT".equals(bString)) {
            this.canWrite = varval.doubleValue() > valval.doubleValue();
        } else if ("LTEQ".equals(bString)) {
            this.canWrite = varval.doubleValue() <= valval.doubleValue();
        } else if ("LT".equals(bString)) {
            this.canWrite = varval.doubleValue() < valval.doubleValue();
        } else if ("NEQ".equals(bString)) {
            this.canWrite = !CoreUtility.doublesEqual(varval.doubleValue(), valval.doubleValue());
        } else {
            Logging.errorPrint("Unknown comparison type: " + bString + " in VAR filter " + aString + " assuming NEQ");
            this.canWrite = !CoreUtility.doublesEqual(varval.doubleValue(), valval.doubleValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(PlayerCharacter[] PCs, BufferedWriter out) {
        FileAccess.setCurrentOutputFilter(this.templateFile.getName());
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.templateFile), "UTF-8"));
            boolean betweenPipes = false;
            StringBuilder textBetweenPipes = new StringBuilder();
            Pattern pat1 = Pattern.compile("^\\Q|");
            Pattern pat2 = Pattern.compile("\\Q|\\E$");
            String aLine = br.readLine();
            while (aLine != null) {
                int lastPipeIndex = aLine.lastIndexOf(124);
                if (!betweenPipes && lastPipeIndex == -1) {
                    if (this.manualWhitespace) {
                        aLine = aLine.replaceAll("[ \\t]", "");
                        FileAccess.write(out, aLine);
                    } else {
                        FileAccess.write(out, aLine);
                        FileAccess.newLine(out);
                    }
                } else if (betweenPipes && lastPipeIndex == -1 || !betweenPipes && lastPipeIndex == 0) {
                    textBetweenPipes.append(aLine.substring(lastPipeIndex + 1));
                    betweenPipes = true;
                } else {
                    Matcher mat1 = pat1.matcher(textBetweenPipes);
                    Matcher mat2 = pat2.matcher(textBetweenPipes);
                    boolean startsWithPipe = mat1.find();
                    boolean endsWithPipe = mat2.find();
                    if (!betweenPipes && startsWithPipe) {
                        betweenPipes = true;
                    }
                    if ((betweenPipes = this.processPipedLine(PCs, aLine, textBetweenPipes, out, betweenPipes)) && endsWithPipe) {
                        betweenPipes = false;
                    }
                }
                aLine = br.readLine();
            }
        }
        catch (IOException exc) {
            Logging.errorPrint("Error in ExportHandler::write", exc);
        }
        finally {
            block22: {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ignore) {
                        if (!Logging.isDebugMode()) break block22;
                        Logging.debugPrint("Couldn't close file in ExportHandler::write", ignore);
                    }
                }
            }
        }
    }

    private boolean processPipedLine(PlayerCharacter[] PCs, String aLine, StringBuilder buf, BufferedWriter out, boolean between) {
        StringTokenizer aTok = new StringTokenizer(aLine, "|", false);
        boolean noPipes = false;
        if (aTok.countTokens() == 1) {
            noPipes = true;
        }
        boolean betweenPipes = between;
        while (aTok.hasMoreTokens()) {
            String tok = aTok.nextToken();
            if (!betweenPipes) {
                if (this.manualWhitespace) {
                    tok = tok.replaceAll("[ \\t]", "");
                }
                FileAccess.write(out, tok);
            } else if (!noPipes && !aTok.hasMoreTokens()) {
                buf.append(tok);
            } else {
                buf.append(tok);
                String aString = buf.toString();
                int l = buf.length();
                buf.delete(0, l);
                if (aString.startsWith("FOR.")) {
                    this.doPartyForToken(PCs, out, aString);
                } else {
                    int charNum;
                    Matcher mat = Pattern.compile("^(\\d+)").matcher(aString);
                    int n = charNum = mat.matches() ? Integer.parseInt(mat.group()) : -1;
                    if (charNum >= 0 && charNum < Globals.getPCList().size()) {
                        PlayerCharacter currPC = PCs[charNum];
                        this.replaceToken(aString, out, currPC);
                    } else if (aString.startsWith("EXPORT")) {
                        this.replaceToken(aString, out, null);
                    }
                }
            }
            if (!aTok.hasMoreTokens() && !noPipes) continue;
            betweenPipes = !betweenPipes;
        }
        return betweenPipes;
    }

    private void doPartyForToken(PlayerCharacter[] PCs, BufferedWriter out, String tokenString) {
        PartyForParser forParser = new PartyForParser(tokenString, PCs.length);
        int x = 0;
        for (int i = forParser.min().intValue(); i < forParser.max(); ++i) {
            boolean breakloop;
            String[] tokens;
            if (x == 0) {
                FileAccess.write(out, forParser.startOfLine());
            }
            PlayerCharacter currPC = 0 <= i && i < PCs.length ? PCs[i] : null;
            for (String tok : tokens = forParser.tokenString().split("\\\\\\\\")) {
                if (tok.startsWith("%.")) {
                    if (currPC == null) continue;
                    this.replaceToken(tok.substring(2), out, currPC);
                    continue;
                }
                FileAccess.write(out, tok);
            }
            boolean bl = breakloop = forParser.existsOnly() && currPC == null;
            if (++x != forParser.step() && !breakloop) continue;
            x = 0;
            FileAccess.write(out, forParser.endOfLine());
            if (breakloop) break;
        }
    }

    public final void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public final boolean getCheckBefore() {
        return this.checkBefore;
    }

    public final boolean getInLabel() {
        return this.inLabel;
    }

    public final boolean getExistsOnly() {
        return this.existsOnly;
    }

    public final void setNoMoreItems(boolean noMoreItems) {
        this.noMoreItems = noMoreItems;
    }

    public final boolean isManualWhitespace() {
        return this.manualWhitespace;
    }

    public final void setManualWhitespace(boolean manualWhitespace) {
        this.manualWhitespace = manualWhitespace;
    }

    public static String getTokenString(PlayerCharacter aPC, String aString) {
        StringTokenizer tok = new StringTokenizer(aString, ".,", false);
        String firstToken = tok.nextToken();
        ExportHandler.populateTokenMap();
        Token token = tokenMap.get(firstToken);
        if (token != null) {
            return token.getToken(aString, aPC, null);
        }
        return "";
    }

    private static final class PartyForParser {
        final PStringTokenizer pTok;
        private final Integer cMin;
        private final Integer cMax;
        private final Integer cStep;
        private final String tokenString;
        private final String stringForStartOfLine;
        private final String stringForEndOfLine;
        private final boolean existsOnly;

        PartyForParser(String aString, Integer numOfPCs) {
            this.pTok = new PStringTokenizer(aString.substring(4), ",", "\\\\", "\\\\");
            this.cMin = this.pTok.hasMoreTokens() ? Delta.decode(this.pTok.nextToken()) : 0;
            Integer max = this.pTok.hasMoreTokens() ? Delta.decode(this.pTok.nextToken()) : 100;
            this.cStep = this.pTok.hasMoreTokens() ? Delta.decode(this.pTok.nextToken()) : 1;
            this.tokenString = this.pTok.hasMoreTokens() ? this.pTok.nextToken() : "";
            this.stringForStartOfLine = this.pTok.hasMoreTokens() ? this.pTok.nextToken() : "";
            this.stringForEndOfLine = this.pTok.hasMoreTokens() ? this.pTok.nextToken() : "";
            this.existsOnly = this.pTok.hasMoreTokens() && !"0".equals(this.pTok.nextToken());
            Integer n = this.cMax = max >= numOfPCs && this.existsOnly ? numOfPCs : max;
            if (this.pTok.hasMoreTokens()) {
                StringBuilder sBuf = new StringBuilder();
                sBuf.append("In Party.print there is an unhandled case in a ");
                sBuf.append("switch (the value is ").append(this.pTok.nextToken());
                sBuf.append(".");
                String log = sBuf.toString();
                Logging.errorPrint(log);
            }
        }

        public Integer min() {
            return this.cMin;
        }

        public Integer max() {
            return this.cMax;
        }

        public Integer step() {
            return this.cStep;
        }

        public String tokenString() {
            return this.tokenString;
        }

        public String startOfLine() {
            return this.stringForStartOfLine;
        }

        public String endOfLine() {
            return this.stringForEndOfLine;
        }

        public boolean existsOnly() {
            return this.existsOnly;
        }
    }

    private static final class PStringTokenizer {
        private String _andThat = "";
        private String _delimiter = "";
        private String _forThisString = "";
        private String _ignoreBetweenThis = "";

        PStringTokenizer(String forThisString, String delimiter, String ignoreBetweenThis, String andThat) {
            this._forThisString = forThisString;
            this._delimiter = delimiter;
            this._ignoreBetweenThis = ignoreBetweenThis;
            this._andThat = andThat;
        }

        public boolean hasMoreTokens() {
            return this._forThisString.length() > 0;
        }

        public String nextToken() {
            String aString;
            if (this._forThisString.lastIndexOf(this._delimiter) == -1) {
                aString = this._forThisString;
                this._forThisString = "";
            } else {
                int i;
                StringBuilder b = new StringBuilder();
                boolean ignores = false;
                for (i = 0; i < this._forThisString.length() && (!this._forThisString.substring(i).startsWith(this._delimiter) || ignores); ++i) {
                    if (this._forThisString.substring(i).startsWith(this._ignoreBetweenThis) && !ignores) {
                        ignores = true;
                    } else if (this._forThisString.substring(i).startsWith(this._andThat)) {
                        ignores = false;
                    }
                    b.append(this._forThisString.substring(i, i + 1));
                }
                aString = b.toString();
                this._forThisString = this._forThisString.substring(i + 1);
            }
            return aString;
        }
    }

    private class VariableComparator
    implements Comparator<Object> {
        private VariableComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s2;
            String s1 = o1 == null ? "" : o1.toString();
            String string = s2 = o2 == null ? "" : o2.toString();
            if (s1.length() > s2.length()) {
                return -1;
            }
            if (s1.length() < s2.length()) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    private static enum ExportEngine {
        PCGEN,
        FREEMARKER;

    }
}

