/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.summary;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.StatFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.tabs.Utilities;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.PrettyIntegerFormat;
import pcgen.gui2.util.table.TableCellUtilities;

public class StatTableModel
extends AbstractTableModel
implements ReferenceListener<Integer> {
    public static final String EDITABLE_COLUMN_ID = "EDITABLE";
    private static final String ABILITY_COLUMN_ID = "ABILITY";
    private static final String MOVEDOWN = "movedown";
    private static final int ABILITY_NAME = 0;
    private static final int EDITABLE_SCORE = 3;
    private static final int RACE_ADJ = 4;
    private static final int MISC_ADJ = 5;
    private static final int FINAL_ABILITY_SCORE = 1;
    private static final int ABILITY_MOD = 2;
    private final CharacterFacade character;
    private final ListFacade<StatFacade> stats;
    private final StatRenderer renderer = new StatRenderer();
    private final SpinnerEditor editor = new SpinnerEditor();
    private final JTable table;

    public StatTableModel(CharacterFacade character, JTable jtable) {
        this.character = character;
        this.table = jtable;
        this.stats = character.getDataSet().getStats();
        int min = Integer.MAX_VALUE;
        for (StatFacade sf : this.stats) {
            min = Math.min(sf.getMinValue(), min);
        }
        this.editor.setMinValue(min);
        final JTextField field = this.editor.getTextField();
        InputMap map = field.getInputMap(0);
        map.put(KeyStroke.getKeyStroke(10, 0), MOVEDOWN);
        map.put(KeyStroke.getKeyStroke(9, 0), MOVEDOWN);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = StatTableModel.this.table.getEditingRow();
                int col = StatTableModel.this.table.getEditingColumn();
                StatTableModel.this.table.getCellEditor().stopCellEditing();
                int nextRow = row + 1;
                StatTableModel.this.startEditingNextRow(StatTableModel.this.table, col, nextRow, field);
            }
        };
        field.getActionMap().put(MOVEDOWN, action);
    }

    private void startEditingNextRow(JTable statsTable, int col, int nextRow, JTextField textField) {
        if (nextRow >= 0 && nextRow < this.getRowCount() && col >= 0 && col < this.getColumnCount()) {
            statsTable.editCellAt(nextRow, col);
            textField.requestFocusInWindow();
        }
    }

    @Override
    public int getRowCount() {
        return this.stats.getSize();
    }

    public static void initializeTable(JTable statsTable) {
        JTableHeader tableHeader = statsTable.getTableHeader();
        tableHeader.setResizingAllowed(false);
        tableHeader.setReorderingAllowed(false);
        statsTable.setAutoCreateColumnsFromModel(false);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = Utilities.createTableColumn(0, "Ability", new AbilityHeaderCellRenderer(), true);
        column.setIdentifier(ABILITY_COLUMN_ID);
        columnModel.addColumn(column);
        String htmlText = "<html><div align=\"center\">Final<br>Score</div></html>";
        column = Utilities.createTableColumn(1, htmlText, new FixedHeaderCellRenderer(htmlText), false);
        column.setCellRenderer(new ValueRenderer());
        columnModel.addColumn(column);
        ModRenderer renderer = new ModRenderer();
        htmlText = "<html><div align=\"center\">Ability<br>Mod</div></html>";
        column = Utilities.createTableColumn(2, htmlText, new FixedHeaderCellRenderer(htmlText), false);
        column.setCellRenderer(renderer);
        columnModel.addColumn(column);
        htmlText = "<html><div align=\"center\">Editable<br>Score</div></html>";
        column = Utilities.createTableColumn(3, htmlText, new FixedHeaderCellRenderer(htmlText), false);
        column.setIdentifier(EDITABLE_COLUMN_ID);
        columnModel.addColumn(column);
        htmlText = "<html><div align=\"center\">Race<br>Adj</div></html>";
        column = Utilities.createTableColumn(4, htmlText, new FixedHeaderCellRenderer(htmlText), false);
        column.setCellRenderer(renderer);
        columnModel.addColumn(column);
        htmlText = "<html><div align=\"center\">Misc<br>Adj</div></html>";
        column = Utilities.createTableColumn(5, htmlText, new FixedHeaderCellRenderer(htmlText), false);
        column.setCellRenderer(renderer);
        columnModel.addColumn(column);
        statsTable.setColumnModel(columnModel);
        statsTable.setAutoResizeMode(0);
        statsTable.setShowVerticalLines(false);
        statsTable.setCellSelectionEnabled(false);
        statsTable.setFocusable(false);
        statsTable.setRowHeight(27);
        statsTable.setOpaque(false);
        tableHeader.setFont(FontManipulation.title(statsTable.getFont()));
        FontManipulation.large(statsTable);
    }

    public void install() {
        this.table.setModel(this);
        this.table.setDefaultRenderer(Object.class, this.renderer);
        TableColumn abilityColumn = this.table.getColumn(ABILITY_COLUMN_ID);
        int columnIndex = abilityColumn.getModelIndex();
        int maxWidth = 0;
        for (StatFacade aStat : this.stats) {
            Component cell = this.renderer.getTableCellRendererComponent(this.table, aStat, false, false, -1, columnIndex);
            maxWidth = Math.max(maxWidth, cell.getPreferredSize().width);
        }
        abilityColumn.setPreferredWidth(maxWidth + 4);
        TableColumn column = this.table.getColumn(EDITABLE_COLUMN_ID);
        column.setCellRenderer(new TableCellUtilities.SpinnerRenderer());
        column.setCellEditor(this.editor);
        Dimension size = this.table.getPreferredSize();
        size.width = this.table.getTableHeader().getPreferredSize().width;
        JScrollPane scrollPane = (JScrollPane)this.table.getParent().getParent();
        int vbarWidth = scrollPane.getVerticalScrollBar().getPreferredSize().width;
        size.width += vbarWidth;
        this.table.setPreferredScrollableViewportSize(size);
        scrollPane.setRowHeaderView(Box.createHorizontalStrut(vbarWidth));
        for (StatFacade aStat : this.stats) {
            this.character.getScoreBaseRef(aStat).addReferenceListener(this);
        }
    }

    public void uninstall() {
        if (this.table.isEditing() && !this.editor.stopCellEditing()) {
            this.editor.cancelCellEditing();
        }
        for (StatFacade aStat : this.stats) {
            this.character.getScoreBaseRef(aStat).removeReferenceListener(this);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Object.class;
        }
        return Integer.class;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        StatFacade stat = this.stats.getElementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return stat;
            }
            case 2: {
                return this.character.getModTotal(stat);
            }
            case 3: {
                return this.character.getScoreBase(stat);
            }
            case 4: {
                return this.character.getScoreRaceBonus(stat);
            }
            case 1: {
                return this.character.getScoreTotalString(stat);
            }
            case 5: {
                return this.character.getScoreOtherBonus(stat);
            }
        }
        return 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Number number = (Number)aValue;
        this.character.setScoreBase(this.stats.getElementAt(rowIndex), number.intValue());
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public void referenceChanged(ReferenceEvent<Integer> e) {
        this.fireTableDataChanged();
    }

    private class StatRenderer
    extends JLabel
    implements TableCellRenderer {
        private StatRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(FontManipulation.title(jTable.getFont()));
            this.setBackground(jTable.getBackground());
            this.setForeground(jTable.getForeground());
            StatFacade stat = (StatFacade)value;
            this.setText(stat.getName());
            return this;
        }
    }

    public static class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ChangeListener {
        protected final JSpinner spinner = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));

        public void setMinValue(int minValue) {
            SpinnerNumberModel spinnerModel = (SpinnerNumberModel)this.spinner.getModel();
            spinnerModel.setMinimum(Integer.valueOf(minValue));
        }

        public JTextField getTextField() {
            return ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            this.spinner.addChangeListener(this);
            return this.spinner;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.stopCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            try {
                this.spinner.removeChangeListener(this);
                this.spinner.commitEdit();
            }
            catch (ParseException ex) {
                return false;
            }
            return super.stopCellEditing();
        }
    }

    private static class ValueRenderer
    extends JLabel
    implements TableCellRenderer {
        public ValueRenderer() {
            this.setHorizontalAlignment(4);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 7));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(FontManipulation.title(table.getFont()));
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
            this.setText((String)value);
            return this;
        }
    }

    private static class ModRenderer
    extends JLabel
    implements TableCellRenderer {
        private DecimalFormat formatter = PrettyIntegerFormat.getFormat();

        public ModRenderer() {
            this.setHorizontalAlignment(4);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 7));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Font tableFont = table.getFont();
            if (column < 3) {
                this.setFont(FontManipulation.bold(tableFont));
            } else {
                this.setFont(FontManipulation.plain(tableFont));
            }
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
            Integer mod = (Integer)value;
            if (mod == 0 && column > 3) {
                this.setText("\u2014");
            } else {
                this.setText(this.formatter.format(mod.longValue()));
            }
            return this;
        }
    }

    private static class FixedHeaderCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public FixedHeaderCellRenderer(String text) {
            this.setText(text);
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 10));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                return this;
            }
            return table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class AbilityHeaderCellRenderer
    implements TableCellRenderer {
        private AbilityHeaderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)comp;
            label.setHorizontalAlignment(0);
            return label;
        }
    }
}

