/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.display.CharacterDisplay;
import pcgen.facade.core.LanguageChooserFacade;
import pcgen.facade.core.LanguageFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.gui2.facade.CharacterFacadeImpl;

public final class LanguageChooserFacadeImpl
implements LanguageChooserFacade {
    private final PlayerCharacter theCharacter;
    private final CharacterDisplay charDisplay;
    private ChooseDriver source;
    private String name;
    private DefaultListFacade<LanguageFacade> availableList;
    private DefaultListFacade<LanguageFacade> selectedList;
    private DefaultListFacade<LanguageFacade> originalSelectedList;
    private DefaultReferenceFacade<Integer> numSelectionsRemain;
    private CharacterFacadeImpl pcFacade;

    public LanguageChooserFacadeImpl(CharacterFacadeImpl pcFacade, String name, ChooseDriver source) {
        this.pcFacade = pcFacade;
        this.theCharacter = pcFacade.getTheCharacter();
        this.charDisplay = this.theCharacter.getDisplay();
        this.name = name;
        this.source = source;
        this.availableList = new DefaultListFacade();
        this.selectedList = new DefaultListFacade();
        this.originalSelectedList = new DefaultListFacade();
        this.numSelectionsRemain = new DefaultReferenceFacade<Integer>(0);
    }

    private void buildLanguageList() {
        if (this.source == null || !(this.source instanceof Skill)) {
            this.buildBonusLangList();
        } else {
            this.buildObjectLangList();
        }
    }

    private void buildBonusLangList() {
        boolean atFirstLvl;
        CNAbility cna = this.theCharacter.getBonusLanguageAbility();
        Ability a = cna.getAbility();
        ArrayList availLangs = new ArrayList();
        ChooseInformation<?> chooseInfo = a.get(ObjectKey.CHOOSE_INFO);
        availLangs.addAll(chooseInfo.getSet(this.theCharacter));
        List<Object> selLangs = chooseInfo.getChoiceActor().getCurrentlySelected(cna, this.theCharacter);
        if (selLangs == null) {
            selLangs = Collections.emptyList();
        }
        availLangs.removeAll(this.charDisplay.getLanguageSet());
        this.refreshLangListContents(availLangs, this.availableList);
        this.refreshLangListContents(selLangs, this.selectedList);
        this.refreshLangListContents(selLangs, this.originalSelectedList);
        boolean allowBonusLangAfterFirst = Globals.checkRule("INTBONUSLANG");
        boolean bl = atFirstLvl = this.theCharacter.getTotalLevels() <= 1;
        if (allowBonusLangAfterFirst || atFirstLvl) {
            int bonusLangMax = this.theCharacter.getBonusLanguageCount();
            this.numSelectionsRemain.setReference(bonusLangMax - selLangs.size());
        } else {
            this.numSelectionsRemain.setReference(0);
        }
    }

    private void buildObjectLangList() {
        ArrayList availLangs = new ArrayList();
        ChooseInformation<?> chooseInfo = this.source.getChooseInfo();
        availLangs.addAll(chooseInfo.getSet(this.theCharacter));
        List<?> selLangs = chooseInfo.getChoiceActor().getCurrentlySelected(this.source, this.theCharacter);
        if (selLangs == null) {
            selLangs = new ArrayList();
        }
        Set<Language> languageSet = this.charDisplay.getLanguageSet();
        availLangs.removeAll(languageSet);
        this.refreshLangListContents(availLangs, this.availableList);
        this.refreshLangListContents(selLangs, this.selectedList);
        this.refreshLangListContents(selLangs, this.originalSelectedList);
        int numSelections = 0;
        if (this.source instanceof Skill) {
            numSelections = SkillRankControl.getTotalRank(this.theCharacter, (Skill)this.source).intValue() - this.selectedList.getSize();
        } else {
            ChoiceManagerList<?> aMan = ChooserUtilities.getConfiguredController(this.source, this.theCharacter, null, new ArrayList<String>());
            numSelections = aMan.getNumEffectiveChoices(selLangs, new ArrayList<String>(), this.theCharacter);
        }
        this.numSelectionsRemain.setReference(numSelections);
    }

    private void refreshLangListContents(List<? extends Language> langList, DefaultListFacade<LanguageFacade> langListFacade) {
        Collections.sort(langList);
        langListFacade.clearContents();
        for (Language language : langList) {
            langListFacade.addElement(language);
        }
    }

    @Override
    public void addSelected(LanguageFacade language) {
        if (this.numSelectionsRemain.getReference() <= 0) {
            return;
        }
        this.selectedList.addElement(language);
        this.availableList.removeElement(language);
        this.numSelectionsRemain.setReference(this.numSelectionsRemain.getReference() - 1);
    }

    @Override
    public void removeSelected(LanguageFacade language) {
        this.selectedList.removeElement(language);
        this.availableList.addElement(language);
        this.numSelectionsRemain.setReference(this.numSelectionsRemain.getReference() + 1);
    }

    @Override
    public ListFacade<LanguageFacade> getAvailableList() {
        this.buildLanguageList();
        return this.availableList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReferenceFacade<Integer> getRemainingSelections() {
        return this.numSelectionsRemain;
    }

    @Override
    public ListFacade<LanguageFacade> getSelectedList() {
        return this.selectedList;
    }

    @Override
    public void commit() {
        ChoiceManagerList choiceManager = ChooserUtilities.getChoiceManager(this.source, this.theCharacter);
        ArrayList<Language> selected = new ArrayList<Language>(this.selectedList.getSize());
        for (LanguageFacade langFacade : this.selectedList) {
            selected.add((Language)langFacade);
        }
        choiceManager.applyChoices(this.theCharacter, selected);
        this.pcFacade.refreshLanguageList();
    }

    @Override
    public void rollback() {
        this.buildLanguageList();
    }
}

