/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.gui2.converter.event.TaskStrategyMessage;
import pcgen.gui2.converter.panel.ConvertSubPanel;
import pcgen.system.PCGenSettings;

public class WriteDirectoryPanel
extends ConvertSubPanel {
    private File path = null;
    private SpringLayout layout = new SpringLayout();
    private final JLabel fileLabel;
    private final JLabel warningLabel;
    private FilenameFilter pccFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File parentDir, String fileName) {
            if (".svn".equals(fileName)) {
                return false;
            }
            if (StringUtils.endsWithIgnoreCase(fileName, ".pcc")) {
                return true;
            }
            return new File(parentDir, fileName).isDirectory();
        }
    };
    private List<Campaign> campaignList;

    public WriteDirectoryPanel() {
        this.fileLabel = new JLabel();
        this.warningLabel = new JLabel();
    }

    public String getPath() {
        return this.path.getAbsolutePath();
    }

    @Override
    public boolean performAnalysis(CDOMObject pc) {
        TaskStrategyMessage.sendStatus(this, "Finding Data Directories");
        this.campaignList = pc.getListFor(ListKey.CAMPAIGN);
        this.path = pc.get(ObjectKey.WRITE_DIRECTORY);
        if (this.path != null) {
            this.fileLabel.setText(this.path.getAbsolutePath());
        } else {
            PCGenSettings context = PCGenSettings.getInstance();
            String outputPathName = context.initProperty("pcgen.convert.outputPath", SystemUtils.USER_DIR);
            this.path = new File(outputPathName);
        }
        pc.put(ObjectKey.WRITE_DIRECTORY, this.path);
        this.fireProgressEvent(0);
        return true;
    }

    @Override
    public boolean autoAdvance(CDOMObject pc) {
        return false;
    }

    @Override
    public boolean returnAllowed() {
        return true;
    }

    @Override
    public void setupDisplay(JPanel panel, final CDOMObject pc) {
        panel.setLayout(this.layout);
        JLabel label = new JLabel("Please select the Directory where Converted files should be written: ");
        JButton button = new JButton("Browse...");
        button.setMnemonic('r');
        button.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setDialogType(0);
                chooser.setCurrentDirectory(WriteDirectoryPanel.this.path.getParentFile());
                chooser.setSelectedFile(WriteDirectoryPanel.this.path);
                while (true) {
                    int open;
                    if ((open = chooser.showOpenDialog(null)) == 0) {
                        File fileToOpen = chooser.getSelectedFile();
                        if (fileToOpen.isDirectory() && fileToOpen.canRead() && fileToOpen.canWrite()) {
                            WriteDirectoryPanel.this.path = fileToOpen;
                            pc.put(ObjectKey.WRITE_DIRECTORY, WriteDirectoryPanel.this.path);
                            WriteDirectoryPanel.this.fileLabel.setText(WriteDirectoryPanel.this.path.getAbsolutePath());
                            PCGenSettings context = PCGenSettings.getInstance();
                            context.setProperty("pcgen.convert.outputPath", WriteDirectoryPanel.this.path.getAbsolutePath());
                            WriteDirectoryPanel.this.showWarning();
                            return;
                        }
                        JOptionPane.showMessageDialog(null, "Selection must be a valid (readable & writeable) Directory");
                        chooser.setCurrentDirectory(WriteDirectoryPanel.this.path.getParentFile());
                        continue;
                    }
                    if (open == 1) return;
                }
            }
        });
        panel.add(label);
        panel.add(this.fileLabel);
        panel.add(button);
        panel.add(this.warningLabel);
        this.showWarning();
        this.layout.putConstraint("North", (Component)label, 50, "North", (Component)panel);
        this.layout.putConstraint("North", (Component)this.fileLabel, 75 + label.getPreferredSize().height, "North", (Component)panel);
        this.layout.putConstraint("North", (Component)button, 75 + label.getPreferredSize().height, "North", (Component)panel);
        this.layout.putConstraint("West", (Component)label, 25, "West", (Component)panel);
        this.layout.putConstraint("West", (Component)this.fileLabel, 25, "West", (Component)panel);
        this.layout.putConstraint("East", (Component)button, -50, "East", (Component)panel);
        this.layout.putConstraint("North", (Component)this.warningLabel, 20, "South", (Component)this.fileLabel);
        this.layout.putConstraint("West", (Component)this.warningLabel, 25, "West", (Component)panel);
        this.fileLabel.setText(this.path.getAbsolutePath());
    }

    private void showWarning() {
        List<Campaign> existingCampaigns = this.getExistingPccs();
        StringBuilder warning = new StringBuilder("<html>");
        if (existingCampaigns.size() > 0) {
            int i = 1;
            int maxCampaigns = 15;
            warning.append("<b>Warning</b>: Some converted campaigns already exist in this ");
            warning.append("destination folder and will be skipped:\n<UL>");
            for (Campaign camp : existingCampaigns) {
                if (i >= 15 && existingCampaigns.size() > 15) {
                    warning.append("<li>" + (existingCampaigns.size() - 15 + 1) + " more campaigns.</li>");
                    break;
                }
                warning.append("<li>");
                warning.append(camp.getName());
                warning.append("</li>");
                ++i;
            }
            warning.append("</ul>");
        }
        warning.append("</html>");
        this.warningLabel.setText(warning.toString());
    }

    private List<Campaign> getExistingPccs() {
        ArrayList<File> existingFiles = new ArrayList<File>();
        this.findPCCFiles(this.path, existingFiles);
        ArrayList<Campaign> matchingCampaigns = new ArrayList<Campaign>();
        block0: for (Campaign camp : this.campaignList) {
            File campFile = new File(camp.getSourceURI());
            for (File file : existingFiles) {
                if (!file.getName().equals(campFile.getName())) continue;
                matchingCampaigns.add(camp);
                continue block0;
            }
        }
        return matchingCampaigns;
    }

    private void findPCCFiles(File aDirectory, List<File> existingFiles) {
        if (!aDirectory.exists() || !aDirectory.isDirectory()) {
            return;
        }
        for (File file : aDirectory.listFiles(this.pccFileFilter)) {
            if (file.isDirectory()) {
                this.findPCCFiles(file, existingFiles);
                continue;
            }
            existingFiles.add(file);
        }
    }
}

