/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter;

import java.util.Collection;
import pcgen.cdom.base.CDOMObject;
import pcgen.gui2.converter.event.TokenProcessEvent;
import pcgen.gui2.converter.event.TokenProcessor;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.EditorLoadContext;
import pcgen.util.Logging;

public class DefaultTokenProcessor
implements TokenProcessor {
    @Override
    public String process(TokenProcessEvent tpe) {
        try {
            EditorLoadContext context = tpe.getContext();
            CDOMObject obj = tpe.getPrimary();
            if (context.processToken(obj, tpe.getKey(), tpe.getValue())) {
                context.commit();
            } else {
                context.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
            Collection<String> output = context.unparse(obj);
            if (output == null || output.isEmpty()) {
                return "Unable to unparse: " + tpe.getKey() + ":" + tpe.getValue();
            }
            boolean needTab = false;
            for (String s : output) {
                if (needTab) {
                    tpe.append('\t');
                }
                needTab = true;
                tpe.append(s);
            }
            tpe.consume();
        }
        catch (PersistenceLayerException e) {
            e.printStackTrace();
        }
        return null;
    }
}

