/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import java.awt.Color;
import java.io.File;
import pcgen.facade.core.CharacterFacade;
import pcgen.system.PropertyContext;

public final class UIPropertyContext
extends PropertyContext {
    public static final String CUSTOM_ITEM_COLOR = "customItemColor";
    public static final String NOT_QUALIFIED_COLOR = "notQualifiedColor";
    public static final String AUTOMATIC_COLOR = "automaticColor";
    public static final String VIRTUAL_COLOR = "virtualColor";
    public static final String QUALIFIED_COLOR = "qualifiedColor";
    public static final String SOURCE_STATUS_RELEASE_COLOR = "sourceStatusReleaseColor";
    public static final String SOURCE_STATUS_ALPHA_COLOR = "sourceStatusAlphaColor";
    public static final String SOURCE_STATUS_BETA_COLOR = "sourceStatusBetaColor";
    public static final String SOURCE_STATUS_TEST_COLOR = "sourceStatusTestColor";
    public static final String ALWAYS_OPEN_EXPORT_FILE = "alwaysOpenExportFile";
    public static final String DEFAULT_OS_TYPE = "defaultOSType";
    public static final String DEFAULT_PDF_OUTPUT_SHEET = "defaultPdfOutputSheet";
    public static final String DEFAULT_HTML_OUTPUT_SHEET = "defaultHtmlOutputSheet";
    public static final String SAVE_OUTPUT_SHEET_WITH_PC = "saveOutputSheetWithPC";
    public static final String CLEANUP_TEMP_FILES = "cleanupTempFiles";
    public static final String SKIP_SOURCE_SELECTION = "SourceSelectionDialog.skipOnStart";
    public static final String SOURCE_USE_BASIC_KEY = "SourceSelectionDialog.useBasic";
    public static final String SINGLE_CHOICE_ACTION = "singleChoiceAction";
    public static final String C_PROP_INITIAL_TAB = "initialTab";
    private static UIPropertyContext instance = null;

    private UIPropertyContext() {
        super("UIConfig.ini");
        this.setColor(CUSTOM_ITEM_COLOR, Color.BLUE);
        this.setColor(NOT_QUALIFIED_COLOR, Color.RED);
        this.setColor(AUTOMATIC_COLOR, Color.decode("0xB2B200"));
        this.setColor(VIRTUAL_COLOR, Color.MAGENTA);
        this.setColor(QUALIFIED_COLOR, Color.BLACK);
    }

    private UIPropertyContext(String name, UIPropertyContext parent) {
        super(name, parent);
    }

    @Override
    public UIPropertyContext createChildContext(String childName) {
        return new UIPropertyContext(childName, this);
    }

    public static UIPropertyContext createContext(String name) {
        return UIPropertyContext.getInstance().createChildContext(name);
    }

    public static UIPropertyContext getInstance() {
        if (instance == null) {
            instance = new UIPropertyContext();
        }
        return instance;
    }

    public Color getColor(String key) {
        String prop = this.getProperty(key);
        if (prop == null) {
            return null;
        }
        return new Color(Integer.parseInt(prop, 16));
    }

    public Color getColor(String key, Color defaultValue) {
        String prop = this.getProperty(key, Integer.toString(defaultValue.getRGB(), 16));
        return new Color(Integer.parseInt(prop, 16));
    }

    public void setColor(String key, Color color) {
        this.setProperty(key, Integer.toString(color.getRGB(), 16));
    }

    public Color initColor(String key, Color defaultValue) {
        String prop = this.initProperty(key, Integer.toString(defaultValue.getRGB(), 16));
        return new Color(Integer.parseInt(prop, 16));
    }

    public static Color getCustomItemColor() {
        return UIPropertyContext.getInstance().getColor(CUSTOM_ITEM_COLOR);
    }

    public static void setCustomItemColor(Color color) {
        UIPropertyContext.getInstance().setColor(CUSTOM_ITEM_COLOR, color);
    }

    public static void setQualifiedColor(Color color) {
        UIPropertyContext.getInstance().setColor(QUALIFIED_COLOR, color);
    }

    public static Color getQualifiedColor() {
        return UIPropertyContext.getInstance().getColor(QUALIFIED_COLOR);
    }

    public static void setNotQualifiedColor(Color color) {
        UIPropertyContext.getInstance().setColor(NOT_QUALIFIED_COLOR, color);
    }

    public static Color getNotQualifiedColor() {
        return UIPropertyContext.getInstance().getColor(NOT_QUALIFIED_COLOR);
    }

    public static void setAutomaticColor(Color color) {
        UIPropertyContext.getInstance().setColor(AUTOMATIC_COLOR, color);
    }

    public static Color getAutomaticColor() {
        return UIPropertyContext.getInstance().getColor(AUTOMATIC_COLOR);
    }

    public static void setVirtualColor(Color color) {
        UIPropertyContext.getInstance().setColor(VIRTUAL_COLOR, color);
    }

    public static Color getVirtualColor() {
        return UIPropertyContext.getInstance().getColor(VIRTUAL_COLOR);
    }

    public static void setSourceStatusReleaseColor(Color color) {
        UIPropertyContext.getInstance().setColor(SOURCE_STATUS_RELEASE_COLOR, color);
    }

    public static Color getSourceStatusReleaseColor() {
        return UIPropertyContext.getInstance().initColor(SOURCE_STATUS_RELEASE_COLOR, Color.black);
    }

    public static void setSourceStatusAlphaColor(Color color) {
        UIPropertyContext.getInstance().setColor(SOURCE_STATUS_ALPHA_COLOR, color);
    }

    public static Color getSourceStatusAlphaColor() {
        return UIPropertyContext.getInstance().initColor(SOURCE_STATUS_ALPHA_COLOR, Color.red);
    }

    public static void setSourceStatusBetaColor(Color color) {
        UIPropertyContext.getInstance().setColor(SOURCE_STATUS_BETA_COLOR, color);
    }

    public static Color getSourceStatusBetaColor() {
        return UIPropertyContext.getInstance().initColor(SOURCE_STATUS_BETA_COLOR, new Color(128, 0, 0));
    }

    public static void setSourceStatusTestColor(Color color) {
        UIPropertyContext.getInstance().setColor(SOURCE_STATUS_TEST_COLOR, color);
    }

    public static Color getSourceStatusTestColor() {
        return UIPropertyContext.getInstance().initColor(SOURCE_STATUS_TEST_COLOR, Color.magenta);
    }

    public static int getSingleChoiceAction() {
        return UIPropertyContext.getInstance().initInt(SINGLE_CHOICE_ACTION, 0);
    }

    public static void setSingleChoiceAction(int action) {
        UIPropertyContext.getInstance().setInt(SINGLE_CHOICE_ACTION, action);
    }

    public static String createCharacterPropertyKey(CharacterFacade character, String key) {
        return UIPropertyContext.createFilePropertyKey(character.getFileRef().getReference(), key);
    }

    public static String createFilePropertyKey(File file, String key) {
        if (file == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        return path + "." + key;
    }
}

