/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;
import pcgen.core.pclevelinfo.PCLevelInfo;

public class KitStat
extends BaseKit {
    private Map<CDOMSingleRef<PCStat>, Formula> statMap = new HashMap<CDOMSingleRef<PCStat>, Formula>();

    public String toString() {
        TreeSet<String> set = new TreeSet<String>();
        for (Map.Entry<CDOMSingleRef<PCStat>, Formula> me : this.statMap.entrySet()) {
            set.add(me.getKey().getLSTformat(false) + '=' + me.getValue());
        }
        return StringUtil.join(set, (String)"|");
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        block0: for (Map.Entry<CDOMSingleRef<PCStat>, Formula> me : this.statMap.entrySet()) {
            PCStat mapStat = me.getKey().resolvesTo();
            int sVal = me.getValue().resolve(aPC, "").intValue();
            for (PCStat currentStat : aPC.getStatSet()) {
                if (aPC.isNonAbility(currentStat) || !currentStat.equals(mapStat)) continue;
                aPC.setStat(currentStat, sVal);
                if (!"INT".equals(currentStat.getKeyName())) continue block0;
                this.recalculateSkillPoints(aPC);
                continue block0;
            }
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        this.testApply(null, aPC, null);
    }

    @Override
    public String getObjectName() {
        return "Stats";
    }

    private void recalculateSkillPoints(PlayerCharacter aPC) {
        Set<PCClass> classes = aPC.getClassSet();
        aPC.calcActiveBonuses();
        if (classes != null && classes.size() != 0) {
            for (PCClass pcClass : classes) {
                aPC.setSkillPool(pcClass, 0);
                for (int j = 0; j < aPC.getLevelInfoSize(); ++j) {
                    PCLevelInfo pcl = aPC.getLevelInfo(j);
                    if (!pcl.getClassKeyName().equals(pcClass.getKeyName())) continue;
                    int spMod = aPC.recalcSkillPointMod(pcClass, j + 1);
                    int alreadySpent = pcl.getSkillPointsGained(aPC) - pcl.getSkillPointsRemaining();
                    pcl.setSkillPointsGained(aPC, spMod);
                    pcl.setSkillPointsRemaining(pcl.getSkillPointsGained(aPC) - alreadySpent);
                    Integer currentPool = aPC.getSkillPool(pcClass);
                    int newSkillPool = (currentPool == null ? 0 : currentPool) + spMod;
                    aPC.setSkillPool(pcClass, newSkillPool);
                }
            }
        }
    }

    public void addStat(CDOMSingleRef<PCStat> stat, Formula statValue) {
        if (this.statMap.put(stat, statValue) != null) {
            throw new IllegalArgumentException("Cannot redefine stat: " + stat);
        }
    }

    public boolean isEmpty() {
        return this.statMap.isEmpty();
    }
}

