/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.analysis.TotalWeightFacet;
import pcgen.cdom.facet.model.SizeFacet;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.util.enumeration.Load;

public class LoadFacet {
    private static final Formula LOADSCORE_FORMULA = FormulaFactory.getFormulaFor("LOADSCORE");
    private FormulaResolvingFacet formulaResolvingFacet;
    private TotalWeightFacet totalWeightFacet;
    private SizeFacet sizeFacet;
    private BonusCheckingFacet bonusCheckingFacet;

    public Load getLoadType(CharID id) {
        Float weight = this.totalWeightFacet.getTotalWeight(id);
        double dbl = (double)weight.floatValue() / this.getMaxLoad(id).doubleValue();
        Float lightMult = SettingsHandler.getGame().getLoadInfo().getLoadMultiplier("LIGHT");
        if (lightMult != null && dbl <= lightMult.doubleValue()) {
            return Load.LIGHT;
        }
        Float mediumMult = SettingsHandler.getGame().getLoadInfo().getLoadMultiplier("MEDIUM");
        if (mediumMult != null && dbl <= mediumMult.doubleValue()) {
            return Load.MEDIUM;
        }
        Float heavyMult = SettingsHandler.getGame().getLoadInfo().getLoadMultiplier("HEAVY");
        if (heavyMult != null && dbl <= heavyMult.doubleValue()) {
            return Load.HEAVY;
        }
        return Load.OVERLOAD;
    }

    public Float getMaxLoad(CharID id) {
        return this.getMaxLoad(id, 1.0);
    }

    public Float getMaxLoad(CharID id, double mult) {
        int loadScore = this.formulaResolvingFacet.resolve(id, LOADSCORE_FORMULA, "").intValue();
        BigDecimal loadValue = SettingsHandler.getGame().getLoadInfo().getLoadScoreValue(loadScore);
        String formula = SettingsHandler.getGame().getLoadInfo().getLoadModifierFormula();
        if (formula != null) {
            formula = formula.replaceAll(Pattern.quote("$$SCORE$$"), Double.toString(loadValue.doubleValue() * mult * this.getLoadMultForSize(id)));
            return Float.valueOf(this.formulaResolvingFacet.resolve(id, FormulaFactory.getFormulaFor(formula), "").intValue());
        }
        return new Float(loadValue.doubleValue() * mult * this.getLoadMultForSize(id));
    }

    private double getLoadMultForSize(CharID id) {
        SizeAdjustment sadj = this.sizeFacet.get(id);
        double mult = SettingsHandler.getGame().getLoadInfo().getSizeAdjustment(sadj).doubleValue();
        return mult += this.bonusCheckingFacet.getBonus(id, "LOADMULT", "TYPE=SIZE");
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setTotalWeightFacet(TotalWeightFacet totalWeightFacet) {
        this.totalWeightFacet = totalWeightFacet;
    }

    public void setSizeFacet(SizeFacet sizeFacet) {
        this.sizeFacet = sizeFacet;
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }
}

