/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.StatValueFacet;
import pcgen.cdom.facet.VariableCheckingFacet;
import pcgen.cdom.facet.analysis.NonStatStatFacet;
import pcgen.cdom.facet.analysis.NonStatToStatFacet;
import pcgen.cdom.facet.analysis.StatLockFacet;
import pcgen.cdom.facet.analysis.StatMaxValueFacet;
import pcgen.cdom.facet.analysis.StatMinValueFacet;
import pcgen.cdom.facet.analysis.UnlockedStatFacet;
import pcgen.core.PCStat;

public class StatCalcFacet {
    private StatValueFacet statValueFacet = FacetLibrary.getFacet(StatValueFacet.class);
    private StatLockFacet statLockFacet = FacetLibrary.getFacet(StatLockFacet.class);
    private UnlockedStatFacet unlockedStatFacet = FacetLibrary.getFacet(UnlockedStatFacet.class);
    private NonStatStatFacet nonStatStatFacet = FacetLibrary.getFacet(NonStatStatFacet.class);
    private NonStatToStatFacet nonStatToStatFacet = FacetLibrary.getFacet(NonStatToStatFacet.class);
    private StatMinValueFacet statMinValueFacet = FacetLibrary.getFacet(StatMinValueFacet.class);
    private StatMaxValueFacet statMaxValueFacet = FacetLibrary.getFacet(StatMaxValueFacet.class);
    private VariableCheckingFacet variableCheckingFacet = FacetLibrary.getFacet(VariableCheckingFacet.class);
    private BonusCheckingFacet bonusCheckingFacet = FacetLibrary.getFacet(BonusCheckingFacet.class);

    public int getTotalStatFor(CharID id, PCStat stat) {
        int y = this.getBaseStatFor(id, stat);
        if (!this.nonStatToStatFacet.contains(id, stat) && this.nonStatStatFacet.contains(id, stat)) {
            return 10;
        }
        int minStatValue = Integer.MIN_VALUE;
        Number val = this.statMinValueFacet.getStatMinValue(id, stat);
        if (val != null) {
            minStatValue = val.intValue();
        }
        int maxStatValue = Integer.MAX_VALUE;
        val = this.statMaxValueFacet.getStatMaxValue(id, stat);
        if (val != null) {
            maxStatValue = val.intValue();
        }
        if (!this.unlockedStatFacet.contains(id, stat) && (val = this.statLockFacet.getLockedStat(id, stat)) != null) {
            int total = val.intValue() + (int)this.bonusCheckingFacet.getBonus(id, "LOCKEDSTAT", stat.getKeyName());
            total = Math.min(maxStatValue, total);
            return Math.max(minStatValue, total);
        }
        y = (int)((double)y + this.bonusCheckingFacet.getBonus(id, "STAT", stat.getKeyName()));
        y = Math.min(maxStatValue, y);
        return Math.max(minStatValue, y);
    }

    public int getBaseStatFor(CharID id, PCStat stat) {
        if (!this.nonStatToStatFacet.contains(id, stat) && this.nonStatStatFacet.contains(id, stat)) {
            return 10;
        }
        int minStatValue = Integer.MIN_VALUE;
        Number val = this.statMinValueFacet.getStatMinValue(id, stat);
        if (val != null) {
            minStatValue = val.intValue();
        }
        int maxStatValue = Integer.MAX_VALUE;
        val = this.statMaxValueFacet.getStatMaxValue(id, stat);
        if (val != null) {
            maxStatValue = val.intValue();
        }
        if (!this.unlockedStatFacet.contains(id, stat) && (val = this.statLockFacet.getLockedStat(id, stat)) != null) {
            int base = Math.min(maxStatValue, val.intValue());
            return Math.max(minStatValue, base);
        }
        int z = this.variableCheckingFacet.getVariableValue(id, "BASE." + stat.getKeyName()).intValue();
        if (z != 0) {
            z = Math.min(maxStatValue, z);
            return Math.max(minStatValue, z);
        }
        Integer score = (Integer)this.statValueFacet.get(id, stat);
        int base = Math.min(maxStatValue, score == null ? 0 : score);
        return Math.max(minStatValue, base);
    }

    public int getStatModFor(CharID id, PCStat stat) {
        return this.variableCheckingFacet.getVariableValue(id, stat.getSafe(FormulaKey.STAT_MOD).toString(), "STAT:" + stat.getKeyName()).intValue();
    }

    public int getModFornumber(CharID id, int aNum, PCStat stat) {
        return this.variableCheckingFacet.getVariableValue(id, stat.getSafe(FormulaKey.STAT_MOD).toString(), Integer.toString(aNum)).intValue();
    }

    public int getPartialStatFor(CharID id, PCStat stat, int partialStatBonus) {
        int statValue = this.getBaseStatFor(id, stat);
        statValue += partialStatBonus;
        Number val = this.statMinValueFacet.getStatMinValue(id, stat);
        if (val != null) {
            statValue = Math.max(val.intValue(), statValue);
        }
        if ((val = this.statMaxValueFacet.getStatMaxValue(id, stat)) != null) {
            statValue = Math.min(val.intValue(), statValue);
        }
        return statValue;
    }
}

