/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.Date;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.system.LanguageBundle;

public enum SourceFormat {
    SHORT{

        @Override
        public String getField(CDOMObject cdo) {
            return cdo.get(StringKey.SOURCE_SHORT);
        }

        @Override
        public String getPublisher(Campaign campaign) {
            return "";
        }

        @Override
        public boolean allowsPage() {
            return true;
        }
    }
    ,
    MEDIUM{

        @Override
        public String getField(CDOMObject cdo) {
            return cdo.get(StringKey.SOURCE_LONG);
        }

        @Override
        public String getPublisher(Campaign campaign) {
            return "";
        }

        @Override
        public boolean allowsPage() {
            return true;
        }
    }
    ,
    LONG{

        @Override
        public String getField(CDOMObject cdo) {
            return cdo.get(StringKey.SOURCE_LONG);
        }

        @Override
        public String getPublisher(Campaign campaign) {
            return campaign.getSafe(StringKey.PUB_NAME_LONG);
        }

        @Override
        public boolean allowsPage() {
            return true;
        }
    }
    ,
    DATE{

        @Override
        public String getField(CDOMObject cdo) {
            Date date = cdo.get(ObjectKey.SOURCE_DATE);
            return date == null ? null : date.toString();
        }

        @Override
        public String getPublisher(Campaign campaign) {
            return "";
        }

        @Override
        public boolean allowsPage() {
            return true;
        }
    }
    ,
    PAGE{

        @Override
        public String getField(CDOMObject cdo) {
            return cdo.get(StringKey.SOURCE_PAGE);
        }

        @Override
        public String getPublisher(Campaign campaign) {
            return "";
        }

        @Override
        public boolean allowsPage() {
            return true;
        }
    }
    ,
    WEB{

        @Override
        public String getField(CDOMObject cdo) {
            return cdo.get(StringKey.SOURCE_WEB);
        }

        @Override
        public String getPublisher(Campaign campaign) {
            return campaign.getSafe(StringKey.PUB_NAME_WEB);
        }

        @Override
        public boolean allowsPage() {
            return false;
        }
    };


    public abstract String getPublisher(Campaign var1);

    public abstract String getField(CDOMObject var1);

    public abstract boolean allowsPage();

    public static String formatShort(CDOMObject cdo, int aMaxLen) {
        Campaign campaign;
        String theShortName = cdo.get(StringKey.SOURCE_SHORT);
        if (theShortName == null && (campaign = cdo.get(ObjectKey.SOURCE_CAMPAIGN)) != null) {
            theShortName = campaign.get(StringKey.SOURCE_SHORT);
        }
        if (theShortName != null) {
            int maxLen = Math.min(aMaxLen, theShortName.length());
            return theShortName.substring(0, maxLen);
        }
        return "";
    }

    public static String getFormattedString(CDOMObject cdo, SourceFormat format, boolean includePage) {
        String thePageNumber;
        StringBuilder ret = new StringBuilder(100);
        if (cdo.isType("Custom")) {
            ret.append(LanguageBundle.getString("in_custom")).append(" - ");
        }
        String source = format.getField(cdo);
        String publisher = null;
        Campaign campaign = cdo.get(ObjectKey.SOURCE_CAMPAIGN);
        if (campaign != null) {
            publisher = format.getPublisher(campaign);
            if (source == null) {
                source = format.getField(campaign);
            }
        }
        if (source == null) {
            source = "";
        }
        if (publisher != null && publisher.trim().length() > 0) {
            ret.append(publisher);
            ret.append(" - ");
        }
        ret.append(source);
        if (includePage && format.allowsPage() && (thePageNumber = cdo.get(StringKey.SOURCE_PAGE)) != null) {
            if (ret.length() != 0) {
                ret.append(", ");
            }
            ret.append(thePageNumber);
        }
        return ret.toString();
    }
}

