/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import pcgen.util.Logging;

public enum GroupingState {
    INVALID{

        @Override
        public GroupingState add(GroupingState state) {
            return INVALID;
        }

        @Override
        public GroupingState negate() {
            return INVALID;
        }

        @Override
        public GroupingState reduce() {
            return INVALID;
        }

        @Override
        public GroupingState compound(GroupingState state) {
            return INVALID;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }
    ,
    ALLOWS_NONE{

        @Override
        public GroupingState add(GroupingState state) {
            if (state != EMPTY) {
                Logging.errorPrint("Attempt to add '" + (Object)((Object)state) + "' grouping state to " + "'ALLOWS_NONE' resulted in 'INVALID'.");
                return INVALID;
            }
            return state == EMPTY ? ALLOWS_NONE : INVALID;
        }

        @Override
        public GroupingState negate() {
            return INVALID;
        }

        @Override
        public GroupingState reduce() {
            return ANY;
        }

        @Override
        public GroupingState compound(GroupingState state) {
            return ALLOWS_NONE;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
    ,
    ALLOWS_INTERSECTION{

        @Override
        public GroupingState add(GroupingState state) {
            if (state == this || state == EMPTY || state == ANY) {
                return this;
            }
            Logging.errorPrint("Attempt to add '" + (Object)((Object)state) + "' grouping state to 'ALLOWS_INTERSECTION' " + "resulted in 'INVALID'.");
            return INVALID;
        }

        @Override
        public GroupingState negate() {
            return ANY;
        }

        @Override
        public GroupingState reduce() {
            return ANY;
        }

        @Override
        public GroupingState compound(GroupingState state) {
            return state == ALLOWS_UNION ? INVALID : ANY;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
    ,
    ALLOWS_UNION{

        @Override
        public GroupingState add(GroupingState state) {
            if (state == this || state == EMPTY || state == ANY) {
                return this;
            }
            Logging.errorPrint("Attempt to add '" + (Object)((Object)state) + "' grouping state to 'ALLOWS_UNION' resulted in 'INVALID'.");
            return INVALID;
        }

        @Override
        public GroupingState negate() {
            return ANY;
        }

        @Override
        public GroupingState reduce() {
            return this;
        }

        @Override
        public GroupingState compound(GroupingState state) {
            return state == ALLOWS_INTERSECTION ? INVALID : ANY;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
    ,
    ANY{

        @Override
        public GroupingState add(GroupingState state) {
            if (state == ALLOWS_NONE) {
                Logging.errorPrint("Attempt to add 'ALLOWS_NONE' grouping state to 'ANY' resulted in 'INVALID'.");
                return INVALID;
            }
            return state == EMPTY ? ANY : (state == ALLOWS_NONE ? INVALID : state);
        }

        @Override
        public GroupingState negate() {
            return this;
        }

        @Override
        public GroupingState reduce() {
            return this;
        }

        @Override
        public GroupingState compound(GroupingState state) {
            return this;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
    ,
    EMPTY{

        @Override
        public GroupingState add(GroupingState state) {
            return state;
        }

        @Override
        public GroupingState negate() {
            return ALLOWS_NONE;
        }

        @Override
        public GroupingState reduce() {
            return this;
        }

        @Override
        public GroupingState compound(GroupingState state) {
            return EMPTY;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };


    public abstract GroupingState add(GroupingState var1);

    public abstract GroupingState negate();

    public abstract GroupingState compound(GroupingState var1);

    public abstract boolean isValid();

    public abstract GroupingState reduce();
}

