/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.formula;

import pcgen.base.formula.ReferenceFormula;

public class SubtractingFormula
implements ReferenceFormula<Integer> {
    private final int sub;

    public SubtractingFormula(int decrement) {
        this.sub = decrement;
    }

    @Override
    public Integer resolve(Number ... numbers) {
        if (numbers == null || numbers.length != 1) {
            throw new IllegalArgumentException("SubtractingFormula only has one back-reference");
        }
        return numbers[0].intValue() - this.sub;
    }

    public String toString() {
        if (this.sub >= 0) {
            return "-" + this.sub;
        }
        return "+" + -this.sub;
    }

    public int hashCode() {
        return this.sub;
    }

    public boolean equals(Object obj) {
        return obj instanceof SubtractingFormula && ((SubtractingFormula)obj).sub == this.sub;
    }
}

