"""Run tests for multiple Python versions."""

import sys

import anyio

import dagger


async def test():
    # highlight-start
    versions = ["3.7", "3.8", "3.9", "3.10", "3.11"]
    # highlight-end

    async with dagger.Connection(dagger.Config(log_output=sys.stderr)) as client:
        # get reference to the local project
        src = client.host().directory(".")

        # highlight-start
        for version in versions:
            # highlight-end
            python = (
                client.container()
                # highlight-start
                .from_(f"python:{version}-slim-buster")
                # highlight-end
                # mount cloned repository into image
                .with_directory("/src", src)
                # set current working directory for next commands
                .with_workdir("/src")
                # install test dependencies
                .with_exec(["pip", "install", "-r", "requirements.txt"])
                # run tests
                .with_exec(["pytest", "tests"])
            )

            # highlight-start
            print(f"Starting tests for Python {version}")
            # highlight-end

            # execute
            await python.sync()

            # highlight-start
            print(f"Tests for Python {version} succeeded!")

    print("All tasks have finished")
    # highlight-end


anyio.run(test)
