{{- /* Header template.
A static file to define BaseClient class that will be
inherited by futures objects and common types.
 */ -}}
{{ define "header" -}}
/**
 * This file was auto-generated by `client-gen`.
 * Do not make direct changes to the file.
 */
import { Context, defaultContext } from "../context/context.js"
import { computeQuery } from "./utils.js"

/**
 * @hidden
 */
export type QueryTree = {
  operation: string
  args?: Record<string, unknown>
}

/**
 * @hidden
 */
export type Metadata = {
  [key: string]: {
    is_enum?: boolean
  }
}

interface ClientConfig {
  queryTree?: QueryTree[]
  ctx?: Context
}


class BaseClient {
  protected _queryTree: QueryTree[]
  protected _ctx: Context

  /**
   * @hidden
   */
  constructor({ queryTree, ctx }: ClientConfig = {}) {
    this._queryTree = queryTree || []
    this._ctx = ctx || new Context()
  }

  /**
   * @hidden
   */
  get queryTree() {
    return this._queryTree
  }
}
{{- end }}
