/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.archive;

import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.zkgroup.GenericServerPublicParams;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredential;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialRequestContext;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialResponse;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.archive.ArchiveCredentialPresentation;
import org.whispersystems.signalservice.api.archive.ArchiveGetBackupInfoResponse;
import org.whispersystems.signalservice.api.archive.ArchiveGetMediaItemsResponse;
import org.whispersystems.signalservice.api.archive.ArchiveMediaRequest;
import org.whispersystems.signalservice.api.archive.ArchiveMediaResponse;
import org.whispersystems.signalservice.api.archive.ArchiveServiceCredential;
import org.whispersystems.signalservice.api.archive.ArchiveServiceCredentialsResponse;
import org.whispersystems.signalservice.api.archive.BatchArchiveMediaRequest;
import org.whispersystems.signalservice.api.archive.BatchArchiveMediaResponse;
import org.whispersystems.signalservice.api.archive.DeleteArchivedMediaRequest;
import org.whispersystems.signalservice.api.archive.GetArchiveCdnCredentialsResponse;
import org.whispersystems.signalservice.api.backup.BackupKey;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.internal.push.AttachmentUploadForm;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 92\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0012J*\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00110\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011J6\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\b2\u0006\u0010$\u001a\u00020%J,\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\b2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010*\u001a\b\u0012\u0004\u0012\u00020%0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\b2\u0006\u0010-\u001a\u00020.J\u001e\u0010/\u001a\u0002002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ8\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 J$\u00102\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ,\u00104\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u0006\u0010$\u001a\u00020%2\u0006\u00105\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020.R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/whispersystems/signalservice/api/archive/ArchiveApi;", "", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "(Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "backupServerPublicParams", "Lorg/signal/libsignal/zkgroup/GenericServerPublicParams;", "copyAttachmentToArchive", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/api/archive/BatchArchiveMediaResponse;", "backupKey", "Lorg/whispersystems/signalservice/api/backup/BackupKey;", "aci", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "serviceCredential", "Lorg/whispersystems/signalservice/api/archive/ArchiveServiceCredential;", "items", "", "Lorg/whispersystems/signalservice/api/archive/ArchiveMediaRequest;", "Lorg/whispersystems/signalservice/api/archive/ArchiveMediaResponse;", "item", "debugGetUploadedMediaItemMetadata", "Lorg/whispersystems/signalservice/api/archive/ArchiveGetMediaItemsResponse$StoredMediaObject;", "deleteArchivedMedia", "", "mediaToDelete", "Lorg/whispersystems/signalservice/api/archive/DeleteArchivedMediaRequest$ArchivedMediaObject;", "getArchiveMediaItemsPage", "Lorg/whispersystems/signalservice/api/archive/ArchiveGetMediaItemsResponse;", "limit", "", "cursor", "", "getBackupInfo", "Lorg/whispersystems/signalservice/api/archive/ArchiveGetBackupInfoResponse;", "getBackupResumableUploadUrl", "uploadForm", "Lorg/whispersystems/signalservice/internal/push/AttachmentUploadForm;", "getCdnReadCredentials", "Lorg/whispersystems/signalservice/api/archive/GetArchiveCdnCredentialsResponse;", "cdnNumber", "getMediaUploadForm", "getMessageBackupUploadForm", "getServiceCredentials", "Lorg/whispersystems/signalservice/api/archive/ArchiveServiceCredentialsResponse;", "currentTime", "", "getZkCredential", "Lorg/signal/libsignal/zkgroup/backups/BackupAuthCredential;", "listMediaObjects", "setPublicKey", "triggerBackupIdReservation", "uploadBackupFile", "resumableUploadUrl", "data", "Ljava/io/InputStream;", "dataLength", "Companion", "CredentialPresentationData", "signal-service-java"})
public final class ArchiveApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PushServiceSocket pushServiceSocket;
    @NotNull
    private final GenericServerPublicParams backupServerPublicParams;

    public ArchiveApi(@NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.pushServiceSocket = pushServiceSocket;
        this.backupServerPublicParams = new GenericServerPublicParams(this.pushServiceSocket.getConfiguration().getBackupServerPublicParams());
    }

    @NotNull
    public final NetworkResult<ArchiveServiceCredentialsResponse> getServiceCredentials(long currentTime) {
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.getServiceCredentials$lambda$0(this, currentTime));
    }

    @NotNull
    public final NetworkResult<GetArchiveCdnCredentialsResponse> getCdnReadCredentials(int cdnNumber, @NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.getCdnReadCredentials$lambda$1(this, backupKey, aci, serviceCredential, cdnNumber));
    }

    @NotNull
    public final NetworkResult<Unit> triggerBackupIdReservation(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.triggerBackupIdReservation$lambda$2(backupKey, aci, this));
    }

    @NotNull
    public final NetworkResult<Unit> setPublicKey(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.setPublicKey$lambda$3(this, backupKey, aci, serviceCredential));
    }

    @NotNull
    public final NetworkResult<AttachmentUploadForm> getMessageBackupUploadForm(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.getMessageBackupUploadForm$lambda$4(this, backupKey, aci, serviceCredential));
    }

    @NotNull
    public final NetworkResult<ArchiveGetBackupInfoResponse> getBackupInfo(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.getBackupInfo$lambda$5(this, backupKey, aci, serviceCredential));
    }

    @NotNull
    public final NetworkResult<ArchiveGetMediaItemsResponse> listMediaObjects(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential, int limit, @Nullable String cursor) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.listMediaObjects$lambda$6(this, backupKey, aci, serviceCredential, limit, cursor));
    }

    public static /* synthetic */ NetworkResult listMediaObjects$default(ArchiveApi archiveApi, BackupKey backupKey, ServiceId.ACI aCI, ArchiveServiceCredential archiveServiceCredential, int n, String string, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            string = null;
        }
        return archiveApi.listMediaObjects(backupKey, aCI, archiveServiceCredential, n, string);
    }

    @NotNull
    public final NetworkResult<String> getBackupResumableUploadUrl(@NotNull AttachmentUploadForm uploadForm) {
        Intrinsics.checkNotNullParameter((Object)uploadForm, (String)"uploadForm");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.getBackupResumableUploadUrl$lambda$7(this, uploadForm));
    }

    @NotNull
    public final NetworkResult<Unit> uploadBackupFile(@NotNull AttachmentUploadForm uploadForm, @NotNull String resumableUploadUrl, @NotNull InputStream data, long dataLength) {
        Intrinsics.checkNotNullParameter((Object)uploadForm, (String)"uploadForm");
        Intrinsics.checkNotNullParameter((Object)resumableUploadUrl, (String)"resumableUploadUrl");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.uploadBackupFile$lambda$8(this, uploadForm, resumableUploadUrl, data, dataLength));
    }

    @NotNull
    public final NetworkResult<AttachmentUploadForm> getMediaUploadForm(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.getMediaUploadForm$lambda$9(this, backupKey, aci, serviceCredential));
    }

    @NotNull
    public final NetworkResult<List<ArchiveGetMediaItemsResponse.StoredMediaObject>> debugGetUploadedMediaItemMetadata(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.debugGetUploadedMediaItemMetadata$lambda$10(this, backupKey, aci, serviceCredential));
    }

    @NotNull
    public final NetworkResult<ArchiveGetMediaItemsResponse> getArchiveMediaItemsPage(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential, int limit, @Nullable String cursor) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.getArchiveMediaItemsPage$lambda$11(this, backupKey, aci, serviceCredential, limit, cursor));
    }

    @NotNull
    public final NetworkResult<ArchiveMediaResponse> copyAttachmentToArchive(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential, @NotNull ArchiveMediaRequest item) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.copyAttachmentToArchive$lambda$12(this, backupKey, aci, serviceCredential, item));
    }

    @NotNull
    public final NetworkResult<BatchArchiveMediaResponse> copyAttachmentToArchive(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential, @NotNull List<ArchiveMediaRequest> items) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.copyAttachmentToArchive$lambda$13(this, backupKey, aci, serviceCredential, items));
    }

    @NotNull
    public final NetworkResult<Unit> deleteArchivedMedia(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential, @NotNull List<DeleteArchivedMediaRequest.ArchivedMediaObject> mediaToDelete) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        Intrinsics.checkNotNullParameter(mediaToDelete, (String)"mediaToDelete");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.deleteArchivedMedia$lambda$14(this, backupKey, aci, serviceCredential, mediaToDelete));
    }

    @NotNull
    public final BackupAuthCredential getZkCredential(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceCredential serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)serviceCredential, (String)"serviceCredential");
        BackupAuthCredentialResponse backupAuthResponse = new BackupAuthCredentialResponse(serviceCredential.getCredential());
        BackupAuthCredentialRequestContext backupRequestContext = BackupAuthCredentialRequestContext.create((byte[])backupKey.getValue(), (UUID)aci.getRawUuid());
        BackupAuthCredential backupAuthCredential = backupRequestContext.receiveResponse(backupAuthResponse, Instant.ofEpochSecond(serviceCredential.getRedemptionTime()), this.backupServerPublicParams);
        Intrinsics.checkNotNullExpressionValue((Object)backupAuthCredential, (String)"receiveResponse(...)");
        return backupAuthCredential;
    }

    private static final ArchiveServiceCredentialsResponse getServiceCredentials$lambda$0(ArchiveApi this$0, long $currentTime) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ArchiveServiceCredentialsResponse archiveServiceCredentialsResponse = this$0.pushServiceSocket.getArchiveCredentials($currentTime);
        Intrinsics.checkNotNullExpressionValue((Object)archiveServiceCredentialsResponse, (String)"getArchiveCredentials(...)");
        return archiveServiceCredentialsResponse;
    }

    private static final GetArchiveCdnCredentialsResponse getCdnReadCredentials$lambda$1(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential, int $cdnNumber) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        GetArchiveCdnCredentialsResponse getArchiveCdnCredentialsResponse = this$0.pushServiceSocket.getArchiveCdnReadCredentials($cdnNumber, presentationData.toArchiveCredentialPresentation());
        Intrinsics.checkNotNullExpressionValue((Object)getArchiveCdnCredentialsResponse, (String)"getArchiveCdnReadCredentials(...)");
        return getArchiveCdnCredentialsResponse;
    }

    private static final Unit triggerBackupIdReservation$lambda$2(BackupKey $backupKey, ServiceId.ACI $aci, ArchiveApi this$0) {
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BackupAuthCredentialRequestContext backupRequestContext = BackupAuthCredentialRequestContext.create((byte[])$backupKey.getValue(), (UUID)$aci.getRawUuid());
        this$0.pushServiceSocket.setArchiveBackupId(backupRequestContext.getRequest());
        return Unit.INSTANCE;
    }

    private static final Unit setPublicKey$lambda$3(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        this$0.pushServiceSocket.setArchivePublicKey(presentationData.getPublicKey(), presentationData.toArchiveCredentialPresentation());
        return Unit.INSTANCE;
    }

    private static final AttachmentUploadForm getMessageBackupUploadForm$lambda$4(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        AttachmentUploadForm attachmentUploadForm = this$0.pushServiceSocket.getArchiveMessageBackupUploadForm(presentationData.toArchiveCredentialPresentation());
        Intrinsics.checkNotNullExpressionValue((Object)attachmentUploadForm, (String)"getArchiveMessageBackupUploadForm(...)");
        return attachmentUploadForm;
    }

    private static final ArchiveGetBackupInfoResponse getBackupInfo$lambda$5(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        ArchiveGetBackupInfoResponse archiveGetBackupInfoResponse = this$0.pushServiceSocket.getArchiveBackupInfo(presentationData.toArchiveCredentialPresentation());
        Intrinsics.checkNotNullExpressionValue((Object)archiveGetBackupInfoResponse, (String)"getArchiveBackupInfo(...)");
        return archiveGetBackupInfoResponse;
    }

    private static final ArchiveGetMediaItemsResponse listMediaObjects$lambda$6(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential, int $limit, String $cursor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        ArchiveGetMediaItemsResponse archiveGetMediaItemsResponse = this$0.pushServiceSocket.getArchiveMediaItemsPage(presentationData.toArchiveCredentialPresentation(), $limit, $cursor);
        Intrinsics.checkNotNullExpressionValue((Object)archiveGetMediaItemsResponse, (String)"getArchiveMediaItemsPage(...)");
        return archiveGetMediaItemsResponse;
    }

    private static final String getBackupResumableUploadUrl$lambda$7(ArchiveApi this$0, AttachmentUploadForm $uploadForm) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uploadForm, (String)"$uploadForm");
        String string = this$0.pushServiceSocket.getResumableUploadUrl($uploadForm);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResumableUploadUrl(...)");
        return string;
    }

    private static final Unit uploadBackupFile$lambda$8(ArchiveApi this$0, AttachmentUploadForm $uploadForm, String $resumableUploadUrl, InputStream $data, long $dataLength) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uploadForm, (String)"$uploadForm");
        Intrinsics.checkNotNullParameter((Object)$resumableUploadUrl, (String)"$resumableUploadUrl");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        this$0.pushServiceSocket.uploadBackupFile($uploadForm, $resumableUploadUrl, $data, $dataLength);
        return Unit.INSTANCE;
    }

    private static final AttachmentUploadForm getMediaUploadForm$lambda$9(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        AttachmentUploadForm attachmentUploadForm = this$0.pushServiceSocket.getArchiveMediaUploadForm(presentationData.toArchiveCredentialPresentation());
        Intrinsics.checkNotNullExpressionValue((Object)attachmentUploadForm, (String)"getArchiveMediaUploadForm(...)");
        return attachmentUploadForm;
    }

    private static final List debugGetUploadedMediaItemMetadata$lambda$10(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential) {
        ArchiveGetMediaItemsResponse response;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        List mediaObjects = new ArrayList();
        String cursor = null;
        do {
            response = this$0.getArchiveMediaItemsPage($backupKey, $aci, $serviceCredential, 512, cursor).successOrThrow();
            CollectionsKt.addAll((Collection)mediaObjects, (Iterable)response.getStoredMediaObjects());
        } while ((cursor = response.getCursor()) != null);
        return mediaObjects;
    }

    private static final ArchiveGetMediaItemsResponse getArchiveMediaItemsPage$lambda$11(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential, int $limit, String $cursor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        ArchiveGetMediaItemsResponse archiveGetMediaItemsResponse = this$0.pushServiceSocket.getArchiveMediaItemsPage(presentationData.toArchiveCredentialPresentation(), $limit, $cursor);
        Intrinsics.checkNotNullExpressionValue((Object)archiveGetMediaItemsResponse, (String)"getArchiveMediaItemsPage(...)");
        return archiveGetMediaItemsResponse;
    }

    private static final ArchiveMediaResponse copyAttachmentToArchive$lambda$12(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential, ArchiveMediaRequest $item) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        ArchiveMediaResponse archiveMediaResponse = this$0.pushServiceSocket.archiveAttachmentMedia(presentationData.toArchiveCredentialPresentation(), $item);
        Intrinsics.checkNotNullExpressionValue((Object)archiveMediaResponse, (String)"archiveAttachmentMedia(...)");
        return archiveMediaResponse;
    }

    private static final BatchArchiveMediaResponse copyAttachmentToArchive$lambda$13(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential, List $items) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        BatchArchiveMediaRequest request = new BatchArchiveMediaRequest($items);
        BatchArchiveMediaResponse batchArchiveMediaResponse = this$0.pushServiceSocket.archiveAttachmentMedia(presentationData.toArchiveCredentialPresentation(), request);
        Intrinsics.checkNotNullExpressionValue((Object)batchArchiveMediaResponse, (String)"archiveAttachmentMedia(...)");
        return batchArchiveMediaResponse;
    }

    private static final Unit deleteArchivedMedia$lambda$14(ArchiveApi this$0, BackupKey $backupKey, ServiceId.ACI $aci, ArchiveServiceCredential $serviceCredential, List $mediaToDelete) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$backupKey, (String)"$backupKey");
        Intrinsics.checkNotNullParameter((Object)$aci, (String)"$aci");
        Intrinsics.checkNotNullParameter((Object)$serviceCredential, (String)"$serviceCredential");
        Intrinsics.checkNotNullParameter((Object)$mediaToDelete, (String)"$mediaToDelete");
        BackupAuthCredential zkCredential = this$0.getZkCredential($backupKey, $aci, $serviceCredential);
        CredentialPresentationData presentationData = CredentialPresentationData.Companion.from($backupKey, $aci, zkCredential, this$0.backupServerPublicParams);
        DeleteArchivedMediaRequest request = new DeleteArchivedMediaRequest($mediaToDelete);
        this$0.pushServiceSocket.deleteArchivedMedia(presentationData.toArchiveCredentialPresentation(), request);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final ArchiveApi create(@NotNull PushServiceSocket pushServiceSocket) {
        return Companion.create(pushServiceSocket);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/whispersystems/signalservice/api/archive/ArchiveApi$Companion;", "", "()V", "create", "Lorg/whispersystems/signalservice/api/archive/ArchiveApi;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ArchiveApi create(@NotNull PushServiceSocket pushServiceSocket) {
            Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
            return new ArchiveApi(pushServiceSocket);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/whispersystems/signalservice/api/archive/ArchiveApi$CredentialPresentationData;", "", "privateKey", "Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;", "presentation", "", "signedPresentation", "(Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;[B[B)V", "getPresentation", "()[B", "getPrivateKey", "()Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;", "publicKey", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "getPublicKey", "()Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "getSignedPresentation", "toArchiveCredentialPresentation", "Lorg/whispersystems/signalservice/api/archive/ArchiveCredentialPresentation;", "Companion", "signal-service-java"})
    private static final class CredentialPresentationData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ECPrivateKey privateKey;
        @NotNull
        private final byte[] presentation;
        @NotNull
        private final byte[] signedPresentation;
        @NotNull
        private final ECPublicKey publicKey;

        public CredentialPresentationData(@NotNull ECPrivateKey privateKey, @NotNull byte[] presentation, @NotNull byte[] signedPresentation) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)signedPresentation, (String)"signedPresentation");
            this.privateKey = privateKey;
            this.presentation = presentation;
            this.signedPresentation = signedPresentation;
            ECPublicKey eCPublicKey = this.privateKey.publicKey();
            Intrinsics.checkNotNullExpressionValue((Object)eCPublicKey, (String)"publicKey(...)");
            this.publicKey = eCPublicKey;
        }

        @NotNull
        public final ECPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        @NotNull
        public final byte[] getPresentation() {
            return this.presentation;
        }

        @NotNull
        public final byte[] getSignedPresentation() {
            return this.signedPresentation;
        }

        @NotNull
        public final ECPublicKey getPublicKey() {
            return this.publicKey;
        }

        @NotNull
        public final ArchiveCredentialPresentation toArchiveCredentialPresentation() {
            return new ArchiveCredentialPresentation(this.presentation, this.signedPresentation);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/whispersystems/signalservice/api/archive/ArchiveApi$CredentialPresentationData$Companion;", "", "()V", "from", "Lorg/whispersystems/signalservice/api/archive/ArchiveApi$CredentialPresentationData;", "backupKey", "Lorg/whispersystems/signalservice/api/backup/BackupKey;", "aci", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "credential", "Lorg/signal/libsignal/zkgroup/backups/BackupAuthCredential;", "backupServerPublicParams", "Lorg/signal/libsignal/zkgroup/GenericServerPublicParams;", "signal-service-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CredentialPresentationData from(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull BackupAuthCredential credential, @NotNull GenericServerPublicParams backupServerPublicParams) {
                Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
                Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
                Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
                Intrinsics.checkNotNullParameter((Object)backupServerPublicParams, (String)"backupServerPublicParams");
                ECPrivateKey privateKey = backupKey.deriveAnonymousCredentialPrivateKey(aci);
                byte[] byArray = credential.present(backupServerPublicParams).serialize();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
                byte[] presentation = byArray;
                byte[] byArray2 = privateKey.calculateSignature(presentation);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"calculateSignature(...)");
                byte[] signedPresentation = byArray2;
                return new CredentialPresentationData(privateKey, presentation, signedPresentation);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

