/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import io.reactivex.rxjava3.core.Single;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.signal.core.util.StreamUtil;
import org.signal.core.util.concurrent.FutureTransformers;
import org.signal.core.util.concurrent.ListenableFuture;
import org.signal.core.util.concurrent.SettableFuture;
import org.signal.core.util.stream.LimitedInputStream;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.attachment.AttachmentDownloadResult;
import org.whispersystems.signalservice.api.backup.BackupKey;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherInputStream;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherStreamUtil;
import org.whispersystems.signalservice.api.crypto.ProfileCipherInputStream;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.api.messages.SignalServiceStickerManifest;
import org.whispersystems.signalservice.api.profiles.ProfileAndCredential;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.MissingConfigurationException;
import org.whispersystems.signalservice.internal.ServiceResponse;
import org.whispersystems.signalservice.internal.crypto.PaddingInputStream;
import org.whispersystems.signalservice.internal.push.IdentityCheckRequest;
import org.whispersystems.signalservice.internal.push.IdentityCheckResponse;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.sticker.Pack;
import org.whispersystems.signalservice.internal.util.Util;
import org.whispersystems.signalservice.internal.websocket.ResponseMapper;

public class SignalServiceMessageReceiver {
    private final PushServiceSocket socket;

    public SignalServiceMessageReceiver(PushServiceSocket socket) {
        this.socket = socket;
    }

    public InputStream retrieveAttachment(SignalServiceAttachmentPointer pointer, File destination, long maxSizeBytes) throws IOException, InvalidMessageException, MissingConfigurationException {
        return this.retrieveAttachment(pointer, destination, maxSizeBytes, null).getDataStream();
    }

    public ListenableFuture<ProfileAndCredential> retrieveProfile(SignalServiceAddress address, Optional<ProfileKey> profileKey, @Nullable SealedSenderAccess sealedSenderAccess, SignalServiceProfile.RequestType requestType, Locale locale) {
        if (profileKey.isPresent()) {
            if (!(address.getServiceId() instanceof ServiceId.ACI)) {
                SettableFuture result2 = new SettableFuture();
                result2.setException((Throwable)new ClassCastException("retrieving a versioned profile requires an ACI"));
                return result2;
            }
            ServiceId.ACI aci = (ServiceId.ACI)address.getServiceId();
            if (requestType == SignalServiceProfile.RequestType.PROFILE_AND_CREDENTIAL) {
                return this.socket.retrieveVersionedProfileAndCredential(aci, profileKey.get(), sealedSenderAccess, locale);
            }
            return FutureTransformers.map(this.socket.retrieveVersionedProfile(aci, profileKey.get(), sealedSenderAccess, locale), profile -> new ProfileAndCredential((SignalServiceProfile)profile, SignalServiceProfile.RequestType.PROFILE, Optional.empty()));
        }
        return FutureTransformers.map(this.socket.retrieveProfile(address, sealedSenderAccess, locale), profile -> new ProfileAndCredential((SignalServiceProfile)profile, SignalServiceProfile.RequestType.PROFILE, Optional.empty()));
    }

    public InputStream retrieveProfileAvatar(String path, File destination, ProfileKey profileKey, long maxSizeBytes) throws IOException {
        this.socket.retrieveProfileAvatar(path, destination, maxSizeBytes);
        return new ProfileCipherInputStream(new FileInputStream(destination), profileKey);
    }

    public FileInputStream retrieveGroupsV2ProfileAvatar(String path, File destination, long maxSizeBytes) throws IOException {
        this.socket.retrieveProfileAvatar(path, destination, maxSizeBytes);
        return new FileInputStream(destination);
    }

    public Single<ServiceResponse<IdentityCheckResponse>> performIdentityCheck(@Nonnull IdentityCheckRequest request, @Nonnull ResponseMapper<IdentityCheckResponse> responseMapper) {
        return this.socket.performIdentityCheck(request, responseMapper);
    }

    public AttachmentDownloadResult retrieveAttachment(SignalServiceAttachmentPointer pointer, File destination, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws IOException, InvalidMessageException, MissingConfigurationException {
        if (!pointer.getDigest().isPresent()) {
            throw new InvalidMessageException("No attachment digest!");
        }
        this.socket.retrieveAttachment(pointer.getCdnNumber(), Collections.emptyMap(), pointer.getRemoteId(), destination, maxSizeBytes, listener);
        byte[] iv = new byte[16];
        try (FileInputStream tempStream = new FileInputStream(destination);){
            StreamUtil.readFully((InputStream)tempStream, (byte[])iv);
        }
        return new AttachmentDownloadResult(AttachmentCipherInputStream.createForAttachment(destination, pointer.getSize().orElse(0).intValue(), pointer.getKey(), pointer.getDigest().get(), null, 0), iv);
    }

    public AttachmentDownloadResult retrieveArchivedAttachment(@Nonnull BackupKey.MediaKeyMaterial archivedMediaKeyMaterial, @Nonnull Map<String, String> readCredentialHeaders, @Nonnull File archiveDestination, @Nonnull SignalServiceAttachmentPointer pointer, @Nonnull File attachmentDestination, long maxSizeBytes, boolean ignoreDigest, @Nullable SignalServiceAttachment.ProgressListener listener) throws IOException, InvalidMessageException, MissingConfigurationException {
        if (!ignoreDigest && pointer.getDigest().isEmpty()) {
            throw new InvalidMessageException("No attachment digest!");
        }
        this.socket.retrieveAttachment(pointer.getCdnNumber(), readCredentialHeaders, pointer.getRemoteId(), archiveDestination, maxSizeBytes, listener);
        long originalCipherLength = pointer.getSize().filter(s -> s > 0).map(s -> AttachmentCipherStreamUtil.getCiphertextLength(PaddingInputStream.getPaddedSize(s.intValue()))).orElse(0L);
        try (LimitedInputStream backupDecrypted = AttachmentCipherInputStream.createForArchivedMedia(archivedMediaKeyMaterial, archiveDestination, originalCipherLength);
             FileOutputStream fos = new FileOutputStream(attachmentDestination);){
            StreamUtil.copy((InputStream)backupDecrypted, (OutputStream)fos);
        }
        byte[] iv = new byte[16];
        try (FileInputStream tempStream = new FileInputStream(attachmentDestination);){
            StreamUtil.readFully((InputStream)tempStream, (byte[])iv);
        }
        LimitedInputStream dataStream = AttachmentCipherInputStream.createForAttachment(attachmentDestination, pointer.getSize().orElse(0).intValue(), pointer.getKey(), ignoreDigest ? null : pointer.getDigest().get(), null, 0, ignoreDigest);
        return new AttachmentDownloadResult(dataStream, iv);
    }

    public void retrieveBackup(int cdnNumber, Map<String, String> headers, String cdnPath, File destination, SignalServiceAttachment.ProgressListener listener) throws MissingConfigurationException, IOException {
        this.socket.retrieveBackup(cdnNumber, headers, cdnPath, destination, 1000000000L, listener);
    }

    @Nullable
    public ZonedDateTime getCdnLastModifiedTime(int cdnNumber, Map<String, String> headers, String cdnPath) throws MissingConfigurationException, IOException {
        return this.socket.getCdnLastModifiedTime(cdnNumber, headers, cdnPath);
    }

    public InputStream retrieveSticker(byte[] packId, byte[] packKey, int stickerId) throws IOException, InvalidMessageException {
        byte[] data = this.socket.retrieveSticker(packId, stickerId);
        return AttachmentCipherInputStream.createForStickerData(data, packKey);
    }

    public SignalServiceStickerManifest retrieveStickerManifest(byte[] packId, byte[] packKey) throws IOException, InvalidMessageException {
        byte[] manifestBytes = this.socket.retrieveStickerManifest(packId);
        InputStream cipherStream = AttachmentCipherInputStream.createForStickerData(manifestBytes, packKey);
        Pack pack = (Pack)((Object)Pack.ADAPTER.decode(Util.readFullyAsBytes(cipherStream)));
        ArrayList<SignalServiceStickerManifest.StickerInfo> stickers = new ArrayList<SignalServiceStickerManifest.StickerInfo>(pack.stickers.size());
        SignalServiceStickerManifest.StickerInfo cover = pack.cover != null ? new SignalServiceStickerManifest.StickerInfo(pack.cover.id, pack.cover.emoji, pack.cover.contentType) : null;
        for (Pack.Sticker sticker : pack.stickers) {
            stickers.add(new SignalServiceStickerManifest.StickerInfo(sticker.id, sticker.emoji, sticker.contentType));
        }
        return new SignalServiceStickerManifest(pack.title, pack.author, cover, stickers);
    }
}

