/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import com.squareup.wire.FieldEncoding;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okio.ByteString;
import org.signal.core.util.Base64;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.signal.libsignal.usernames.BaseUsernameException;
import org.signal.libsignal.usernames.Username;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.RemoteConfigResult;
import org.whispersystems.signalservice.api.account.AccountAttributes;
import org.whispersystems.signalservice.api.account.PreKeyCollection;
import org.whispersystems.signalservice.api.account.PreKeyUpload;
import org.whispersystems.signalservice.api.crypto.ProfileCipher;
import org.whispersystems.signalservice.api.crypto.ProfileCipherOutputStream;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.groupsv2.ClientZkOperations;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Api;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Operations;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.messages.calls.TurnServerInfo;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceInfo;
import org.whispersystems.signalservice.api.payments.CurrencyConversions;
import org.whispersystems.signalservice.api.profiles.AvatarUploadParams;
import org.whispersystems.signalservice.api.profiles.ProfileAndCredential;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfileWrite;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.push.exceptions.NoContentException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NotFoundException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.api.registration.RegistrationApi;
import org.whispersystems.signalservice.api.services.CdsiV2Service;
import org.whispersystems.signalservice.api.storage.SignalStorageCipher;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.SignalStorageModels;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.api.storage.StorageManifestKey;
import org.whispersystems.signalservice.api.svr.SecureValueRecoveryV2;
import org.whispersystems.signalservice.api.svr.SecureValueRecoveryV3;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.util.Preconditions;
import org.whispersystems.signalservice.internal.ServiceResponse;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.crypto.PrimaryProvisioningCipher;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.CdsiAuthResponse;
import org.whispersystems.signalservice.internal.push.OneTimePreKeyCounts;
import org.whispersystems.signalservice.internal.push.PaymentAddress;
import org.whispersystems.signalservice.internal.push.ProfileAvatarData;
import org.whispersystems.signalservice.internal.push.ProvisionMessage;
import org.whispersystems.signalservice.internal.push.ProvisioningSocket;
import org.whispersystems.signalservice.internal.push.ProvisioningVersion;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.RemoteConfigResponse;
import org.whispersystems.signalservice.internal.push.ReserveUsernameResponse;
import org.whispersystems.signalservice.internal.push.WhoAmIResponse;
import org.whispersystems.signalservice.internal.push.http.ProfileCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.storage.protos.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.protos.ReadOperation;
import org.whispersystems.signalservice.internal.storage.protos.StorageItem;
import org.whispersystems.signalservice.internal.storage.protos.StorageItems;
import org.whispersystems.signalservice.internal.storage.protos.StorageManifest;
import org.whispersystems.signalservice.internal.storage.protos.WriteOperation;
import org.whispersystems.signalservice.internal.util.DynamicCredentialsProvider;
import org.whispersystems.signalservice.internal.util.StaticCredentialsProvider;

public class SignalServiceAccountManager {
    private static final String TAG = SignalServiceAccountManager.class.getSimpleName();
    private static final int STORAGE_READ_MAX_ITEMS = 1000;
    private final PushServiceSocket pushServiceSocket;
    private final ProvisioningSocket provisioningSocket;
    private final CredentialsProvider credentials;
    private final GroupsV2Operations groupsV2Operations;
    private final SignalServiceConfiguration configuration;

    public static SignalServiceAccountManager createWithStaticCredentials(SignalServiceConfiguration configuration, ServiceId.ACI aci, ServiceId.PNI pni, String e164, int deviceId, String password, String signalAgent, boolean automaticNetworkRetry, int maxGroupSize) {
        StaticCredentialsProvider credentialProvider = new StaticCredentialsProvider(aci, pni, e164, deviceId, password);
        GroupsV2Operations gv2Operations = new GroupsV2Operations(ClientZkOperations.create(configuration), maxGroupSize);
        return new SignalServiceAccountManager(new PushServiceSocket(configuration, credentialProvider, signalAgent, gv2Operations.getProfileOperations(), automaticNetworkRetry), new ProvisioningSocket(configuration, signalAgent), gv2Operations);
    }

    public SignalServiceAccountManager(PushServiceSocket pushServiceSocket, ProvisioningSocket provisioningSocket, GroupsV2Operations groupsV2Operations) {
        this.provisioningSocket = provisioningSocket;
        this.groupsV2Operations = groupsV2Operations;
        this.pushServiceSocket = pushServiceSocket;
        this.credentials = pushServiceSocket.getCredentialsProvider();
        this.configuration = pushServiceSocket.getConfiguration();
    }

    public byte[] getSenderCertificate() throws IOException {
        return this.pushServiceSocket.getSenderCertificate();
    }

    public byte[] getSenderCertificateForPhoneNumberPrivacy() throws IOException {
        return this.pushServiceSocket.getUuidOnlySenderCertificate();
    }

    public SecureValueRecoveryV2 getSecureValueRecoveryV2(String mrEnclave) {
        return new SecureValueRecoveryV2(this.configuration, mrEnclave, this.pushServiceSocket);
    }

    public SecureValueRecoveryV3 getSecureValueRecoveryV3(Network network) {
        return new SecureValueRecoveryV3(network, this.pushServiceSocket);
    }

    public WhoAmIResponse getWhoAmI() throws IOException {
        return this.pushServiceSocket.getWhoAmI();
    }

    public void setGcmId(Optional<String> gcmRegistrationId) throws IOException {
        if (gcmRegistrationId.isPresent()) {
            this.pushServiceSocket.registerGcmId(gcmRegistrationId.get());
        } else {
            this.pushServiceSocket.unregisterGcmId();
        }
    }

    public void requestRegistrationPushChallenge(String sessionId, String gcmRegistrationId) throws IOException {
        this.pushServiceSocket.requestPushChallenge(sessionId, gcmRegistrationId);
    }

    public void setAccountAttributes(@Nonnull AccountAttributes accountAttributes) throws IOException {
        this.pushServiceSocket.setAccountAttributes(accountAttributes);
    }

    public void setPreKeys(PreKeyUpload preKeyUpload) throws IOException {
        this.pushServiceSocket.registerPreKeys(preKeyUpload);
    }

    public OneTimePreKeyCounts getPreKeyCounts(ServiceIdType serviceIdType) throws IOException {
        return this.pushServiceSocket.getAvailablePreKeys(serviceIdType);
    }

    public boolean isIdentifierRegistered(ServiceId identifier) throws IOException {
        return this.pushServiceSocket.isIdentifierRegistered(identifier);
    }

    public String getNewDeviceUuid() throws TimeoutException, IOException {
        return this.provisioningSocket.getProvisioningUuid().uuid;
    }

    public CdsiV2Service.Response getRegisteredUsersWithCdsi(Set<String> previousE164s, Set<String> newE164s, Map<ServiceId, ProfileKey> serviceIds, Optional<byte[]> token, String mrEnclave, Long timeoutMs, @Nullable Network libsignalNetwork, Consumer<byte[]> tokenSaver) throws IOException {
        ServiceResponse serviceResponse;
        CdsiAuthResponse auth = this.pushServiceSocket.getCdsiAuth();
        CdsiV2Service service = new CdsiV2Service(this.configuration, mrEnclave, libsignalNetwork);
        CdsiV2Service.Request request = new CdsiV2Service.Request(previousE164s, newE164s, serviceIds, token);
        Single<ServiceResponse<CdsiV2Service.Response>> single = service.getRegisteredUsers(auth.getUsername(), auth.getPassword(), request, tokenSaver);
        try {
            serviceResponse = timeoutMs == null ? (ServiceResponse)single.blockingGet() : (ServiceResponse)single.timeout(timeoutMs.longValue(), TimeUnit.MILLISECONDS).blockingGet();
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                throw new IOException("Interrupted", cause);
            }
            if (cause instanceof TimeoutException) {
                throw new IOException("Timed out");
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception when retrieving registered users!", e);
        }
        if (serviceResponse.getResult().isPresent()) {
            return (CdsiV2Service.Response)serviceResponse.getResult().get();
        }
        if (serviceResponse.getApplicationError().isPresent()) {
            if (serviceResponse.getApplicationError().get() instanceof IOException) {
                throw (IOException)serviceResponse.getApplicationError().get();
            }
            throw new IOException(serviceResponse.getApplicationError().get());
        }
        if (serviceResponse.getExecutionError().isPresent()) {
            throw new IOException(serviceResponse.getExecutionError().get());
        }
        throw new IOException("Missing result!");
    }

    public Optional<SignalStorageManifest> getStorageManifest(StorageKey storageKey) throws IOException {
        try {
            String authToken = this.pushServiceSocket.getStorageAuth();
            StorageManifest storageManifest = this.pushServiceSocket.getStorageManifest(authToken);
            return Optional.of(SignalStorageModels.remoteToLocalStorageManifest(storageManifest, storageKey));
        }
        catch (InvalidKeyException | NotFoundException e) {
            Log.w((String)TAG, (String)"Error while fetching manifest.", (Throwable)e);
            return Optional.empty();
        }
    }

    public long getStorageManifestVersion() throws IOException {
        try {
            String authToken = this.pushServiceSocket.getStorageAuth();
            StorageManifest storageManifest = this.pushServiceSocket.getStorageManifest(authToken);
            return storageManifest.version;
        }
        catch (NotFoundException e) {
            return 0L;
        }
    }

    public Optional<SignalStorageManifest> getStorageManifestIfDifferentVersion(StorageKey storageKey, long manifestVersion) throws IOException, InvalidKeyException {
        try {
            String authToken = this.pushServiceSocket.getStorageAuth();
            StorageManifest storageManifest = this.pushServiceSocket.getStorageManifestIfDifferentVersion(authToken, manifestVersion);
            if (storageManifest.value_.size() == 0) {
                Log.w((String)TAG, (String)"Got an empty storage manifest!");
                return Optional.empty();
            }
            return Optional.of(SignalStorageModels.remoteToLocalStorageManifest(storageManifest, storageKey));
        }
        catch (NoContentException e) {
            return Optional.empty();
        }
    }

    public List<SignalStorageRecord> readStorageRecords(StorageKey storageKey, List<StorageId> storageKeys) throws IOException, InvalidKeyException {
        if (storageKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SignalStorageRecord> result2 = new ArrayList<SignalStorageRecord>();
        HashMap<ByteString, Integer> typeMap = new HashMap<ByteString, Integer>();
        LinkedList<ReadOperation> readOperations = new LinkedList<ReadOperation>();
        LinkedList<ByteString> readKeys = new LinkedList<ByteString>();
        for (StorageId key : storageKeys) {
            typeMap.put(ByteString.of((byte[])key.getRaw()), key.getType());
            if (readKeys.size() >= 1000) {
                Log.i((String)TAG, (String)"Going over max read items. Starting a new read operation.");
                readOperations.add(new ReadOperation.Builder().readKey(readKeys).build());
                readKeys = new LinkedList();
            }
            if (StorageId.isKnownType(key.getType())) {
                readKeys.add(ByteString.of((byte[])key.getRaw()));
                continue;
            }
            result2.add(SignalStorageRecord.forUnknown(key));
        }
        if (readKeys.size() > 0) {
            readOperations.add(new ReadOperation.Builder().readKey(readKeys).build());
        }
        Log.i((String)TAG, (String)("Reading " + storageKeys.size() + " items split over " + readOperations.size() + " page(s)."));
        String authToken = this.pushServiceSocket.getStorageAuth();
        for (ReadOperation readOperation : readOperations) {
            StorageItems items = this.pushServiceSocket.readStorageItems(authToken, readOperation);
            for (StorageItem item : items.items) {
                Integer type = (Integer)typeMap.get(item.key);
                if (type != null) {
                    result2.add(SignalStorageModels.remoteToLocalStorageRecord(item, type, storageKey));
                    continue;
                }
                Log.w((String)TAG, (String)"No type found! Skipping.");
            }
        }
        return result2;
    }

    public Optional<SignalStorageManifest> resetStorageRecords(StorageKey storageKey, SignalStorageManifest manifest, List<SignalStorageRecord> allRecords) throws IOException, InvalidKeyException {
        return this.writeStorageRecords(storageKey, manifest, allRecords, Collections.emptyList(), true);
    }

    public Optional<SignalStorageManifest> writeStorageRecords(StorageKey storageKey, SignalStorageManifest manifest, List<SignalStorageRecord> inserts, List<byte[]> deletes) throws IOException, InvalidKeyException {
        return this.writeStorageRecords(storageKey, manifest, inserts, deletes, false);
    }

    public void enableRegistrationLock(MasterKey masterKey) throws IOException {
        this.pushServiceSocket.setRegistrationLockV2(masterKey.deriveRegistrationLock());
    }

    public void disableRegistrationLock() throws IOException {
        this.pushServiceSocket.disableRegistrationLockV2();
    }

    private Optional<SignalStorageManifest> writeStorageRecords(StorageKey storageKey, SignalStorageManifest manifest, List<SignalStorageRecord> inserts, List<byte[]> deletes, boolean clearAll) throws IOException, InvalidKeyException {
        ManifestRecord.Builder manifestRecordBuilder = new ManifestRecord.Builder().sourceDevice(manifest.getSourceDeviceId()).version(manifest.getVersion());
        manifestRecordBuilder.identifiers(manifest.getStorageIds().stream().map(id -> {
            ManifestRecord.Identifier.Builder builder = new ManifestRecord.Identifier.Builder().raw(ByteString.of((byte[])id.getRaw()));
            if (!id.isUnknown()) {
                builder.type(ManifestRecord.Identifier.Type.Companion.fromValue(id.getType()));
            } else {
                builder.type(ManifestRecord.Identifier.Type.UNKNOWN);
                builder.addUnknownField(2, FieldEncoding.VARINT, id.getType());
            }
            return builder.build();
        }).collect(Collectors.toList()));
        String authToken = this.pushServiceSocket.getStorageAuth();
        StorageManifestKey manifestKey = storageKey.deriveManifestKey(manifest.getVersion());
        byte[] encryptedRecord = SignalStorageCipher.encrypt(manifestKey, manifestRecordBuilder.build().encode());
        StorageManifest storageManifest = new StorageManifest.Builder().version(manifest.getVersion()).value_(ByteString.of((byte[])encryptedRecord)).build();
        WriteOperation.Builder writeBuilder = new WriteOperation.Builder().manifest(storageManifest);
        writeBuilder.insertItem(inserts.stream().map(insert -> SignalStorageModels.localToRemoteStorageRecord(insert, storageKey)).collect(Collectors.toList()));
        if (clearAll) {
            writeBuilder.clearAll(true);
        } else {
            writeBuilder.deleteKey(deletes.stream().map(delete -> ByteString.of((byte[])delete)).collect(Collectors.toList()));
        }
        Optional<StorageManifest> conflict = this.pushServiceSocket.writeStorageContacts(authToken, writeBuilder.build());
        if (conflict.isPresent()) {
            StorageManifestKey conflictKey = storageKey.deriveManifestKey(conflict.get().version);
            byte[] rawManifestRecord = SignalStorageCipher.decrypt(conflictKey, conflict.get().value_.toByteArray());
            ManifestRecord record = (ManifestRecord)((Object)ManifestRecord.ADAPTER.decode(rawManifestRecord));
            ArrayList<StorageId> ids = new ArrayList<StorageId>(record.identifiers.size());
            for (ManifestRecord.Identifier id2 : record.identifiers) {
                ids.add(StorageId.forType(id2.raw.toByteArray(), id2.type.getValue()));
            }
            SignalStorageManifest conflictManifest = new SignalStorageManifest(record.version, record.sourceDevice, ids);
            return Optional.of(conflictManifest);
        }
        return Optional.empty();
    }

    public RemoteConfigResult getRemoteConfig() throws IOException {
        RemoteConfigResponse response = this.pushServiceSocket.getRemoteConfig();
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (RemoteConfigResponse.Config config : response.getConfig()) {
            out.put(config.getName(), config.getValue() != null ? config.getValue() : Boolean.valueOf(config.isEnabled()));
        }
        return new RemoteConfigResult(out, response.getServerEpochTime());
    }

    public String getAccountDataReport() throws IOException {
        return this.pushServiceSocket.getAccountDataReport();
    }

    public String getNewDeviceVerificationCode() throws IOException {
        return this.pushServiceSocket.getNewDeviceVerificationCode();
    }

    public NewDeviceRegistrationReturn getNewDeviceRegistration(IdentityKeyPair tempIdentity) throws TimeoutException, IOException {
        MasterKey masterKey;
        ProfileKey profileKey;
        ProvisionMessage msg = this.provisioningSocket.getProvisioningMessage(tempIdentity);
        String number = msg.number;
        ServiceId.ACI aci = ServiceId.ACI.parseOrThrow(msg.aci);
        ServiceId.PNI pni = ServiceId.PNI.parseOrThrow(msg.pni);
        if (this.credentials instanceof DynamicCredentialsProvider) {
            ((DynamicCredentialsProvider)this.credentials).setE164(number);
        }
        IdentityKeyPair aciIdentity = this.getIdentityKeyPair(msg.aciIdentityKeyPublic.toByteArray(), msg.aciIdentityKeyPrivate.toByteArray());
        IdentityKeyPair pniIdentity = msg.pniIdentityKeyPublic != null && msg.pniIdentityKeyPrivate != null ? this.getIdentityKeyPair(msg.pniIdentityKeyPublic.toByteArray(), msg.pniIdentityKeyPrivate.toByteArray()) : null;
        try {
            profileKey = msg.profileKey != null ? new ProfileKey(msg.profileKey.toByteArray()) : null;
        }
        catch (InvalidInputException e) {
            throw new IOException("Failed to decrypt profile key", e);
        }
        try {
            masterKey = msg.masterKey != null ? new MasterKey(msg.masterKey.toByteArray()) : null;
        }
        catch (AssertionError e) {
            throw new IOException("Failed to decrypt master key", (Throwable)((Object)e));
        }
        String provisioningCode = msg.provisioningCode;
        boolean readReceipts = msg.readReceipts != null && msg.readReceipts != false;
        return new NewDeviceRegistrationReturn(provisioningCode, aciIdentity, pniIdentity, number, aci, pni, profileKey, masterKey, readReceipts);
    }

    private IdentityKeyPair getIdentityKeyPair(byte[] publicKeyBytes, byte[] privateKeyBytes) throws IOException {
        ECPrivateKey privateKey;
        ECPublicKey publicKey;
        if (publicKeyBytes.length == 32) {
            byte[] type = new byte[]{5};
            publicKeyBytes = ByteUtil.combine((byte[][])new byte[][]{type, publicKeyBytes});
        }
        try {
            publicKey = Curve.decodePoint((byte[])publicKeyBytes, (int)0);
            privateKey = Curve.decodePrivatePoint((byte[])privateKeyBytes);
        }
        catch (InvalidKeyException e) {
            throw new IOException("Failed to decrypt key", e);
        }
        return new IdentityKeyPair(new IdentityKey(publicKey), privateKey);
    }

    public int finishNewDeviceRegistration(String provisioningCode, AccountAttributes accountAttributes, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys) throws IOException {
        int deviceId = this.pushServiceSocket.finishNewDeviceRegistration(provisioningCode, accountAttributes, aciPreKeys, pniPreKeys);
        if (this.credentials instanceof DynamicCredentialsProvider) {
            ((DynamicCredentialsProvider)this.credentials).setDeviceId(deviceId);
        }
        return deviceId;
    }

    public void addDevice(String deviceIdentifier, ECPublicKey deviceKey, IdentityKeyPair aciIdentityKeyPair, IdentityKeyPair pniIdentityKeyPair, ProfileKey profileKey, MasterKey masterKey, String code) throws InvalidKeyException, IOException {
        String e164 = this.credentials.getE164();
        ServiceId.ACI aci = this.credentials.getAci();
        ServiceId.PNI pni = this.credentials.getPni();
        Preconditions.checkArgument(e164 != null, "Missing e164!");
        Preconditions.checkArgument(aci != null, "Missing ACI!");
        Preconditions.checkArgument(pni != null, "Missing PNI!");
        PrimaryProvisioningCipher cipher = new PrimaryProvisioningCipher(deviceKey);
        ProvisionMessage.Builder message = new ProvisionMessage.Builder().aciIdentityKeyPublic(ByteString.of((byte[])aciIdentityKeyPair.getPublicKey().serialize())).aciIdentityKeyPrivate(ByteString.of((byte[])aciIdentityKeyPair.getPrivateKey().serialize())).pniIdentityKeyPublic(ByteString.of((byte[])pniIdentityKeyPair.getPublicKey().serialize())).pniIdentityKeyPrivate(ByteString.of((byte[])pniIdentityKeyPair.getPrivateKey().serialize())).aci(aci.toString()).pni(pni.toStringWithoutPrefix()).number(e164).profileKey(ByteString.of((byte[])profileKey.serialize())).provisioningCode(code).provisioningVersion(ProvisioningVersion.CURRENT.getValue()).masterKey(ByteString.of((byte[])masterKey.serialize()));
        byte[] ciphertext = cipher.encrypt(message.build());
        this.pushServiceSocket.sendProvisioningMessage(deviceIdentifier, ciphertext);
    }

    public List<DeviceInfo> getDevices() throws IOException {
        return this.pushServiceSocket.getDevices();
    }

    public void removeDevice(int deviceId) throws IOException {
        this.pushServiceSocket.removeDevice(deviceId);
    }

    public TurnServerInfo getTurnServerInfo() throws IOException {
        return this.pushServiceSocket.getTurnServerInfo();
    }

    public void checkNetworkConnection() throws IOException {
        this.pushServiceSocket.pingStorageService();
    }

    public CurrencyConversions getCurrencyConversions() throws IOException {
        return this.pushServiceSocket.getCurrencyConversions();
    }

    public void reportSpam(ServiceId serviceId, String serverGuid, String reportingToken) throws IOException {
        this.pushServiceSocket.reportSpam(serviceId, serverGuid, reportingToken);
    }

    public Optional<String> setVersionedProfile(ServiceId.ACI aci, ProfileKey profileKey, String name, String about, String aboutEmoji, Optional<PaymentAddress> paymentsAddress, AvatarUploadParams avatar, List<String> visibleBadgeIds, boolean phoneNumberSharing) throws IOException {
        if (name == null) {
            name = "";
        }
        ProfileCipher profileCipher = new ProfileCipher(profileKey);
        byte[] ciphertextName = profileCipher.encryptString(name, ProfileCipher.getTargetNameLength(name));
        byte[] ciphertextAbout = profileCipher.encryptString(about, ProfileCipher.getTargetAboutLength(about));
        byte[] ciphertextEmoji = profileCipher.encryptString(aboutEmoji, 32);
        byte[] ciphertextMobileCoinAddress = paymentsAddress.map(address -> profileCipher.encryptWithLength(address.encode(), 554)).orElse(null);
        byte[] cipherTextPhoneNumberSharing = profileCipher.encryptBoolean(phoneNumberSharing);
        ProfileAvatarData profileAvatarData = null;
        if (avatar.stream != null && !avatar.keepTheSame) {
            profileAvatarData = new ProfileAvatarData(avatar.stream.getStream(), ProfileCipherOutputStream.getCiphertextLength(avatar.stream.getLength()), avatar.stream.getContentType(), new ProfileCipherOutputStreamFactory(profileKey));
        }
        return this.pushServiceSocket.writeProfile(new SignalServiceProfileWrite(profileKey.getProfileKeyVersion(aci.getLibSignalAci()).serialize(), ciphertextName, ciphertextAbout, ciphertextEmoji, ciphertextMobileCoinAddress, cipherTextPhoneNumberSharing, avatar.hasAvatar, avatar.keepTheSame, profileKey.getCommitment(aci.getLibSignalAci()).serialize(), visibleBadgeIds), profileAvatarData);
    }

    public Optional<ExpiringProfileKeyCredential> resolveProfileKeyCredential(ServiceId.ACI serviceId, ProfileKey profileKey, Locale locale) throws NonSuccessfulResponseCodeException, PushNetworkException {
        try {
            ProfileAndCredential credential = (ProfileAndCredential)this.pushServiceSocket.retrieveVersionedProfileAndCredential(serviceId, profileKey, SealedSenderAccess.NONE, locale).get(10L, TimeUnit.SECONDS);
            return credential.getExpiringProfileKeyCredential();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new PushNetworkException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NonSuccessfulResponseCodeException) {
                throw (NonSuccessfulResponseCodeException)e.getCause();
            }
            if (e.getCause() instanceof PushNetworkException) {
                throw (PushNetworkException)e.getCause();
            }
            throw new PushNetworkException(e);
        }
    }

    public ServiceId.ACI getAciByUsername(Username username) throws IOException {
        return this.pushServiceSocket.getAciByUsernameHash(Base64.encodeUrlSafeWithoutPadding((byte[])username.getHash()));
    }

    public ReserveUsernameResponse reserveUsername(List<String> usernameHashes) throws IOException {
        return this.pushServiceSocket.reserveUsername(usernameHashes);
    }

    public UsernameLinkComponents confirmUsernameAndCreateNewLink(Username username) throws IOException {
        try {
            Username.UsernameLink link = username.generateLink();
            UUID serverId = this.pushServiceSocket.confirmUsernameAndCreateNewLink(username, link);
            return new UsernameLinkComponents(link.getEntropy(), serverId);
        }
        catch (BaseUsernameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UsernameLinkComponents reclaimUsernameAndLink(Username username, UsernameLinkComponents linkComponents) throws IOException {
        try {
            Username.UsernameLink link = username.generateLink(linkComponents.getEntropy());
            UUID serverId = this.pushServiceSocket.confirmUsernameAndCreateNewLink(username, link);
            return new UsernameLinkComponents(link.getEntropy(), serverId);
        }
        catch (BaseUsernameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UsernameLinkComponents updateUsernameLink(Username.UsernameLink newUsernameLink) throws IOException {
        UUID serverId = this.pushServiceSocket.createUsernameLink(Base64.encodeUrlSafeWithoutPadding((byte[])newUsernameLink.getEncryptedUsername()), true);
        return new UsernameLinkComponents(newUsernameLink.getEntropy(), serverId);
    }

    public void deleteUsername() throws IOException {
        this.pushServiceSocket.deleteUsername();
    }

    public UsernameLinkComponents createUsernameLink(Username username) throws IOException {
        try {
            Username.UsernameLink link = username.generateLink();
            UUID serverId = this.pushServiceSocket.createUsernameLink(Base64.encodeUrlSafeWithPadding((byte[])link.getEncryptedUsername()), false);
            return new UsernameLinkComponents(link.getEntropy(), serverId);
        }
        catch (BaseUsernameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void deleteUsernameLink() throws IOException {
        this.pushServiceSocket.deleteUsernameLink();
    }

    public byte[] getEncryptedUsernameFromLinkServerId(UUID serverId) throws IOException {
        return this.pushServiceSocket.getEncryptedUsernameFromLinkServerId(serverId);
    }

    public void deleteAccount() throws IOException {
        this.pushServiceSocket.deleteAccount();
    }

    public void requestRateLimitPushChallenge() throws IOException {
        this.pushServiceSocket.requestRateLimitPushChallenge();
    }

    public void submitRateLimitPushChallenge(String challenge) throws IOException {
        this.pushServiceSocket.submitRateLimitPushChallenge(challenge);
    }

    public void submitRateLimitRecaptchaChallenge(String challenge, String recaptchaToken) throws IOException {
        this.pushServiceSocket.submitRateLimitRecaptchaChallenge(challenge, recaptchaToken);
    }

    public void cancelInFlightRequests() {
        this.pushServiceSocket.cancelInFlightRequests();
    }

    public GroupsV2Api getGroupsV2Api() {
        return new GroupsV2Api(this.pushServiceSocket, this.groupsV2Operations);
    }

    public RegistrationApi getRegistrationApi() {
        return new RegistrationApi(this.pushServiceSocket);
    }

    public AuthCredentials getPaymentsAuthorization() throws IOException {
        return this.pushServiceSocket.getPaymentsAuthorization();
    }

    public static class NewDeviceRegistrationReturn {
        private final String provisioningCode;
        private final IdentityKeyPair aciIdentity;
        private final IdentityKeyPair pniIdentity;
        private final String number;
        private final ServiceId.ACI aci;
        private final ServiceId.PNI pni;
        private final ProfileKey profileKey;
        private final MasterKey masterKey;
        private final boolean readReceipts;

        NewDeviceRegistrationReturn(String provisioningCode, IdentityKeyPair aciIdentity, IdentityKeyPair pniIdentity, String number, ServiceId.ACI aci, ServiceId.PNI pni, ProfileKey profileKey, MasterKey masterKey, boolean readReceipts) {
            this.provisioningCode = provisioningCode;
            this.aciIdentity = aciIdentity;
            this.pniIdentity = pniIdentity;
            this.number = number;
            this.aci = aci;
            this.pni = pni;
            this.profileKey = profileKey;
            this.masterKey = masterKey;
            this.readReceipts = readReceipts;
        }

        public String getProvisioningCode() {
            return this.provisioningCode;
        }

        public IdentityKeyPair getAciIdentity() {
            return this.aciIdentity;
        }

        public IdentityKeyPair getPniIdentity() {
            return this.pniIdentity;
        }

        public String getNumber() {
            return this.number;
        }

        public ServiceId.ACI getAci() {
            return this.aci;
        }

        public ServiceId.PNI getPni() {
            return this.pni;
        }

        public ProfileKey getProfileKey() {
            return this.profileKey;
        }

        public MasterKey getMasterKey() {
            return this.masterKey;
        }

        public boolean isReadReceipts() {
            return this.readReceipts;
        }
    }
}

