/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import java.util.UUID;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class SenderKeyDistributionMessage
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.SenderKeyDistributionMessage_Destroy(this.unsafeHandle);
    }

    public SenderKeyDistributionMessage(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    public SenderKeyDistributionMessage(byte[] serialized) throws InvalidMessageException, InvalidVersionException, LegacyMessageException, InvalidKeyException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidMessageException.class, InvalidVersionException.class, LegacyMessageException.class, InvalidKeyException.class, () -> Native.SenderKeyDistributionMessage_Deserialize(serialized));
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.SenderKeyDistributionMessage_GetSerialized(guard.nativeHandle()));
            return byArray;
        }
    }

    public UUID getDistributionId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            UUID uUID = FilterExceptions.filterExceptions(() -> Native.SenderKeyDistributionMessage_GetDistributionId(guard.nativeHandle()));
            return uUID;
        }
    }

    public int getIteration() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.SenderKeyDistributionMessage_GetIteration(guard.nativeHandle()));
            return n;
        }
    }

    public byte[] getChainKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.SenderKeyDistributionMessage_GetChainKey(guard.nativeHandle()));
            return byArray;
        }
    }

    public ECPublicKey getSignatureKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECPublicKey eCPublicKey = new ECPublicKey(FilterExceptions.filterExceptions(() -> Native.SenderKeyDistributionMessage_GetSignatureKey(guard.nativeHandle())));
            return eCPublicKey;
        }
    }

    public int getChainId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.SenderKeyDistributionMessage_GetChainId(guard.nativeHandle()));
            return n;
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

