/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.OverlappingFileLockException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.asamk.SignalControl;
import org.asamk.signal.BaseConfig;
import org.asamk.signal.DbusConfig;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.UserAlreadyExistsException;
import org.asamk.signal.manager.api.VerificationMethodNotAvailableException;
import org.freedesktop.dbus.DBusPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbusSignalControlImpl
implements SignalControl {
    private static final Logger logger = LoggerFactory.getLogger(DbusSignalControlImpl.class);
    private final MultiAccountManager c;
    private final String objectPath;

    public DbusSignalControlImpl(MultiAccountManager c, String objectPath) {
        this.c = c;
        this.objectPath = objectPath;
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    @Override
    public void register(String number, boolean voiceVerification) throws SignalControl.Error.Failure, SignalControl.Error.InvalidNumber {
        this.registerWithCaptcha(number, voiceVerification, null);
    }

    @Override
    public void registerWithCaptcha(String number, boolean voiceVerification, String captcha) throws SignalControl.Error.Failure, SignalControl.Error.InvalidNumber {
        if (!Manager.isValidNumber((String)number, null)) {
            throw new SignalControl.Error.InvalidNumber("Invalid account (phone number), make sure you include the country code.");
        }
        try (RegistrationManager registrationManager = this.c.getNewRegistrationManager(number);){
            registrationManager.register(voiceVerification, captcha, false);
        }
        catch (RateLimitException e) {
            String message = "Rate limit reached";
            throw new SignalControl.Error.Failure(message);
        }
        catch (CaptchaRequiredException e) {
            String message = captcha == null ? "Captcha required for verification." : "Invalid captcha given.";
            throw new SignalControl.Error.RequiresCaptcha(message);
        }
        catch (NonNormalizedPhoneNumberException e) {
            throw new SignalControl.Error.InvalidNumber(e.getMessage());
        }
        catch (OverlappingFileLockException e) {
            throw new SignalControl.Error.Failure("Account is already in use");
        }
        catch (IOException | VerificationMethodNotAvailableException e) {
            throw new SignalControl.Error.Failure(e.getClass().getSimpleName() + " " + e.getMessage());
        }
    }

    @Override
    public void verify(String number, String verificationCode) throws SignalControl.Error.Failure, SignalControl.Error.InvalidNumber {
        this.verifyWithPin(number, verificationCode, null);
    }

    @Override
    public void verifyWithPin(String number, String verificationCode, String pin) throws SignalControl.Error.Failure, SignalControl.Error.InvalidNumber {
        try (RegistrationManager registrationManager = this.c.getNewRegistrationManager(number);){
            registrationManager.verifyAccount(verificationCode, pin);
        }
        catch (OverlappingFileLockException e) {
            throw new SignalControl.Error.Failure("Account is already in use");
        }
        catch (IOException e) {
            throw new SignalControl.Error.Failure(e.getClass().getSimpleName() + " " + e.getMessage());
        }
        catch (PinLockedException e) {
            throw new SignalControl.Error.Failure("Verification failed! This number is locked with a pin. Hours remaining until reset: " + e.getTimeRemaining() / 1000L / 60L / 60L);
        }
        catch (IncorrectPinException e) {
            throw new SignalControl.Error.Failure("Verification failed! Invalid pin, tries remaining: " + e.getTriesRemaining());
        }
    }

    @Override
    public String link(String newDeviceName) throws SignalControl.Error.Failure {
        URI deviceLinkUri;
        try {
            deviceLinkUri = this.c.getNewProvisioningDeviceLinkUri();
        }
        catch (IOException | TimeoutException e) {
            throw new SignalControl.Error.Failure(e.getClass().getSimpleName() + " " + e.getMessage());
        }
        Thread.ofPlatform().name("dbus-link").start(() -> {
            ProvisioningManager provisioningManager = this.c.getProvisioningManagerFor(deviceLinkUri);
            try {
                provisioningManager.finishDeviceLink(newDeviceName);
            }
            catch (IOException | TimeoutException | UserAlreadyExistsException e) {
                logger.warn("Failed to finish linking", e);
            }
        });
        return deviceLinkUri.toString();
    }

    @Override
    public String startLink() throws SignalControl.Error.Failure {
        try {
            URI deviceLinkUri = this.c.getNewProvisioningDeviceLinkUri();
            return deviceLinkUri.toString();
        }
        catch (IOException | TimeoutException e) {
            throw new SignalControl.Error.Failure(e.getClass().getSimpleName() + " " + e.getMessage());
        }
    }

    @Override
    public String finishLink(String deviceLinkUri, String newDeviceName) throws SignalControl.Error.Failure {
        try {
            ProvisioningManager provisioningManager = this.c.getProvisioningManagerFor(new URI(deviceLinkUri));
            return provisioningManager.finishDeviceLink(newDeviceName);
        }
        catch (IOException | URISyntaxException | TimeoutException | UserAlreadyExistsException e) {
            throw new SignalControl.Error.Failure(e.getClass().getSimpleName() + " " + e.getMessage());
        }
    }

    @Override
    public String version() {
        return BaseConfig.PROJECT_VERSION;
    }

    @Override
    public List<DBusPath> listAccounts() {
        return this.c.getAccountNumbers().stream().map(u -> new DBusPath(DbusConfig.getObjectPath(u))).toList();
    }

    @Override
    public DBusPath getAccount(String number) {
        return new DBusPath(DbusConfig.getObjectPath(number));
    }
}

