/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.DefaultSettings;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.asamk.signal.BaseConfig;
import org.asamk.signal.DbusConfig;
import org.asamk.signal.OutputType;
import org.asamk.signal.ServiceEnvironmentCli;
import org.asamk.signal.TrustNewIdentityCli;
import org.asamk.signal.commands.Command;
import org.asamk.signal.commands.CommandHandler;
import org.asamk.signal.commands.Commands;
import org.asamk.signal.commands.LocalCommand;
import org.asamk.signal.commands.MultiLocalCommand;
import org.asamk.signal.commands.ProvisioningCommand;
import org.asamk.signal.commands.RegistrationCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.dbus.DbusCommandHandler;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.Settings;
import org.asamk.signal.manager.SignalAccountFiles;
import org.asamk.signal.manager.api.AccountCheckException;
import org.asamk.signal.manager.api.NotRegisteredException;
import org.asamk.signal.manager.api.ServiceEnvironment;
import org.asamk.signal.manager.api.TrustNewIdentity;
import org.asamk.signal.output.JsonWriterImpl;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriterImpl;
import org.asamk.signal.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static final Logger logger = LoggerFactory.getLogger(App.class);
    private final Namespace ns;

    static ArgumentParser buildArgumentParser() {
        ArgumentParser parser = ArgumentParsers.newFor((String)"signal-cli", (DefaultSettings)DefaultSettings.VERSION_0_9_0_DEFAULT_SETTINGS).includeArgumentNamesAsKeysInResult(true).build().defaultHelp(true).description("Commandline interface for Signal.").version(BaseConfig.PROJECT_NAME + " " + BaseConfig.PROJECT_VERSION);
        parser.addArgument(new String[]{"--version"}).help("Show package version.").action((ArgumentAction)Arguments.version());
        parser.addArgument(new String[]{"-v", "--verbose"}).help("Raise log level and include lib signal logs. Specify multiple times for even more logs.").action((ArgumentAction)Arguments.count());
        parser.addArgument(new String[]{"--log-file"}).type(File.class).help("Write log output to the given file. If --verbose is also given, the detailed logs will only be written to the log file.");
        parser.addArgument(new String[]{"--scrub-log"}).action((ArgumentAction)Arguments.storeTrue()).help("Scrub possibly sensitive information from the log, like phone numbers and UUIDs.");
        parser.addArgument(new String[]{"-c", "--config"}).help("Set the path, where to store the config (Default: $XDG_DATA_HOME/signal-cli , $HOME/.local/share/signal-cli).");
        parser.addArgument(new String[]{"-a", "--account", "-u", "--username"}).help("Specify your phone number, that will be your identifier.");
        MutuallyExclusiveGroup mut = parser.addMutuallyExclusiveGroup();
        mut.addArgument(new String[]{"--dbus"}).dest("global-dbus").help("Make request via user dbus.").action((ArgumentAction)Arguments.storeTrue());
        mut.addArgument(new String[]{"--dbus-system"}).dest("global-dbus-system").help("Make request via system dbus.").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--bus-name"}).dest("global-bus-name").setDefault((Object)DbusConfig.getBusname()).help("Specify the D-Bus bus name to connect to.");
        parser.addArgument(new String[]{"-o", "--output"}).help("Choose to output in plain text or JSON").type((ArgumentType)Arguments.enumStringType(OutputType.class));
        parser.addArgument(new String[]{"--service-environment"}).help("Choose the server environment to use.").type((ArgumentType)Arguments.enumStringType(ServiceEnvironmentCli.class)).setDefault((Object)ServiceEnvironmentCli.LIVE);
        parser.addArgument(new String[]{"--trust-new-identities"}).help("Choose when to trust new identities.").type((ArgumentType)Arguments.enumStringType(TrustNewIdentityCli.class)).setDefault((Object)TrustNewIdentityCli.ON_FIRST_USE);
        parser.addArgument(new String[]{"--disable-send-log"}).help("Disable message send log (for resending messages that recipient couldn't decrypt)").action((ArgumentAction)Arguments.storeTrue());
        Subparsers subparsers = parser.addSubparsers().title("subcommands").dest("command");
        Commands.getCommandSubparserAttachers().forEach((key, value) -> {
            Subparser subparser = subparsers.addParser(key);
            value.attachToSubparser(subparser);
        });
        return parser;
    }

    public App(Namespace ns) {
        this.ns = ns;
    }

    public void init() throws CommandException {
        logger.debug("Starting {}", (Object)(BaseConfig.PROJECT_NAME + " " + BaseConfig.PROJECT_VERSION));
        String commandKey = this.ns.getString("command");
        Command command = Commands.getCommand(commandKey);
        if (command == null) {
            throw new UserErrorException("Command not implemented!");
        }
        OutputWriter outputWriter = this.getOutputWriter(command);
        CommandHandler commandHandler = new CommandHandler(this.ns, outputWriter);
        String account = this.ns.getString("account");
        boolean useDbus = Boolean.TRUE.equals(this.ns.getBoolean("global-dbus"));
        boolean useDbusSystem = Boolean.TRUE.equals(this.ns.getBoolean("global-dbus-system"));
        if (useDbus || useDbusSystem) {
            String busName = this.ns.getString("global-bus-name");
            DbusCommandHandler.initDbusClient(command, account, useDbusSystem, busName, commandHandler);
            return;
        }
        if (!Manager.isSignalClientAvailable()) {
            throw new UserErrorException("Missing required native library dependency: libsignal-client");
        }
        SignalAccountFiles signalAccountFiles = this.loadSignalAccountFiles();
        this.handleCommand(command, commandHandler, account, signalAccountFiles);
    }

    private void handleCommand(Command command, CommandHandler commandHandler, String account, SignalAccountFiles signalAccountFiles) throws CommandException {
        if (command instanceof ProvisioningCommand) {
            ProvisioningCommand provisioningCommand = (ProvisioningCommand)command;
            if (account != null) {
                throw new UserErrorException("You cannot specify a account (phone number) when linking");
            }
            this.handleProvisioningCommand(provisioningCommand, signalAccountFiles, commandHandler);
            return;
        }
        if (account == null) {
            if (command instanceof MultiLocalCommand) {
                MultiLocalCommand multiLocalCommand = (MultiLocalCommand)command;
                this.handleMultiLocalCommand(multiLocalCommand, signalAccountFiles, commandHandler);
                return;
            }
            account = App.getAccountIfOnlyOne(signalAccountFiles);
        } else if (!Manager.isValidNumber((String)account, null)) {
            throw new UserErrorException("Invalid account (phone number), make sure you include the country code.");
        }
        if (command instanceof RegistrationCommand) {
            RegistrationCommand registrationCommand = (RegistrationCommand)command;
            this.handleRegistrationCommand(registrationCommand, account, signalAccountFiles, commandHandler);
            return;
        }
        if (command instanceof LocalCommand) {
            LocalCommand localCommand = (LocalCommand)command;
            this.handleLocalCommand(localCommand, account, signalAccountFiles, commandHandler);
            return;
        }
        throw new UserErrorException("Command only works in multi-account mode");
    }

    private static String getAccountIfOnlyOne(SignalAccountFiles signalAccountFiles) throws IOErrorException, UserErrorException {
        Set accounts;
        try {
            accounts = signalAccountFiles.getAllLocalAccountNumbers();
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to load local accounts file", e);
        }
        if (accounts.isEmpty()) {
            throw new UserErrorException("No local users found, you first need to register or link an account");
        }
        if (accounts.size() > 1) {
            throw new UserErrorException("Multiple users found, you need to specify an account (phone number) with -a");
        }
        return (String)accounts.stream().findFirst().get();
    }

    private OutputWriter getOutputWriter(Command command) throws UserErrorException {
        JsonWriterImpl outputWriter;
        OutputType outputTypeInput = (OutputType)((Object)this.ns.get("output"));
        OutputType outputType = outputTypeInput == null ? (OutputType)command.getSupportedOutputTypes().stream().findFirst().orElse(null) : outputTypeInput;
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, IOUtils.getConsoleCharset()));
        OutputWriter outputWriter2 = outputType == null ? null : (outputWriter = outputType == OutputType.JSON ? new JsonWriterImpl(writer) : new PlainTextWriterImpl(writer));
        if (outputWriter != null && !command.getSupportedOutputTypes().contains((Object)outputType)) {
            throw new UserErrorException("Command doesn't support output type " + String.valueOf((Object)outputType));
        }
        return outputWriter;
    }

    private SignalAccountFiles loadSignalAccountFiles() throws IOErrorException {
        String config = this.ns.getString("config");
        File configPath = config != null ? new File(config) : App.getDefaultConfigPath();
        ServiceEnvironmentCli serviceEnvironmentCli = (ServiceEnvironmentCli)((Object)this.ns.get("service-environment"));
        ServiceEnvironment serviceEnvironment = serviceEnvironmentCli == ServiceEnvironmentCli.LIVE ? ServiceEnvironment.LIVE : ServiceEnvironment.STAGING;
        TrustNewIdentityCli trustNewIdentityCli = (TrustNewIdentityCli)((Object)this.ns.get("trust-new-identities"));
        TrustNewIdentity trustNewIdentity = trustNewIdentityCli == TrustNewIdentityCli.ON_FIRST_USE ? TrustNewIdentity.ON_FIRST_USE : (trustNewIdentityCli == TrustNewIdentityCli.ALWAYS ? TrustNewIdentity.ALWAYS : TrustNewIdentity.NEVER);
        boolean disableSendLog = Boolean.TRUE.equals(this.ns.getBoolean("disable-send-log"));
        try {
            return new SignalAccountFiles(configPath, serviceEnvironment, BaseConfig.USER_AGENT, new Settings(trustNewIdentity, disableSendLog));
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to read local accounts list", e);
        }
    }

    private void handleProvisioningCommand(ProvisioningCommand command, SignalAccountFiles signalAccountFiles, CommandHandler commandHandler) throws CommandException {
        ProvisioningManager pm = signalAccountFiles.initProvisioningManager();
        commandHandler.handleProvisioningCommand(command, pm);
    }

    private void handleRegistrationCommand(RegistrationCommand command, String account, SignalAccountFiles signalAccountFiles, CommandHandler commandHandler) throws CommandException {
        try (RegistrationManager rm = this.loadRegistrationManager(account, signalAccountFiles);){
            commandHandler.handleRegistrationCommand(command, rm);
        }
        catch (IOException e) {
            logger.warn("Cleanup failed", (Throwable)e);
        }
    }

    private void handleLocalCommand(LocalCommand command, String account, SignalAccountFiles signalAccountFiles, CommandHandler commandHandler) throws CommandException {
        try (Manager m = this.loadManager(account, signalAccountFiles);){
            commandHandler.handleLocalCommand(command, m);
        }
    }

    private void handleMultiLocalCommand(MultiLocalCommand command, SignalAccountFiles signalAccountFiles, CommandHandler commandHandler) throws CommandException {
        try (MultiAccountManager multiAccountManager = signalAccountFiles.initMultiAccountManager();){
            commandHandler.handleMultiLocalCommand(command, multiAccountManager);
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to load local accounts file", e);
        }
    }

    private RegistrationManager loadRegistrationManager(String account, SignalAccountFiles signalAccountFiles) throws UnexpectedErrorException {
        try {
            return signalAccountFiles.initRegistrationManager(account);
        }
        catch (Throwable e) {
            throw new UnexpectedErrorException("Error loading or creating state file: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
    }

    private Manager loadManager(String account, SignalAccountFiles signalAccountFiles) throws CommandException {
        logger.trace("Loading account file for {}", (Object)account);
        try {
            return signalAccountFiles.initManager(account);
        }
        catch (NotRegisteredException e) {
            throw new UserErrorException("User " + account + " is not registered.");
        }
        catch (AccountCheckException ace) {
            Throwable throwable = ace.getCause();
            if (throwable instanceof IOException) {
                IOException e = (IOException)throwable;
                throw new IOErrorException("Error while checking account " + account + ": " + e.getMessage(), e);
            }
            throw new UnexpectedErrorException("Error while checking account " + account + ": " + ace.getMessage(), ace);
        }
        catch (Throwable e) {
            throw new UnexpectedErrorException("Error loading state file for user " + account + ": " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
    }

    private static File getDefaultConfigPath() {
        return new File(IOUtils.getDataHomeDir(), "signal-cli");
    }
}

