/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.network;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.proxy.ListenerBoundEvent;
import com.velocitypowered.api.event.proxy.ListenerCloseEvent;
import com.velocitypowered.api.network.ListenerType;
import com.velocitypowered.natives.util.Natives;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.network.BackendChannelInitializer;
import com.velocitypowered.proxy.network.BackendChannelInitializerHolder;
import com.velocitypowered.proxy.network.Endpoint;
import com.velocitypowered.proxy.network.ServerChannelInitializer;
import com.velocitypowered.proxy.network.ServerChannelInitializerHolder;
import com.velocitypowered.proxy.network.TransportType;
import com.velocitypowered.proxy.network.netty.SeparatePoolInetNameResolver;
import com.velocitypowered.proxy.protocol.netty.GS4QueryHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.RequestFilter;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ConnectionManager {
    private static final WriteBufferWaterMark SERVER_WRITE_MARK = new WriteBufferWaterMark(0x100000, 0x200000);
    private static final Logger LOGGER = LogManager.getLogger(ConnectionManager.class);
    private final Map<InetSocketAddress, Endpoint> endpoints = new HashMap<InetSocketAddress, Endpoint>();
    private final TransportType transportType;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final VelocityServer server;
    public final ServerChannelInitializerHolder serverChannelInitializer;
    public final BackendChannelInitializerHolder backendChannelInitializer;
    private final SeparatePoolInetNameResolver resolver;
    private final AsyncHttpClient httpClient;

    public ConnectionManager(VelocityServer server) {
        this.server = server;
        this.transportType = TransportType.bestType();
        this.bossGroup = this.transportType.createEventLoopGroup(TransportType.Type.BOSS);
        this.workerGroup = this.transportType.createEventLoopGroup(TransportType.Type.WORKER);
        this.serverChannelInitializer = new ServerChannelInitializerHolder(new ServerChannelInitializer(this.server));
        this.backendChannelInitializer = new BackendChannelInitializerHolder(new BackendChannelInitializer(this.server));
        this.resolver = new SeparatePoolInetNameResolver(GlobalEventExecutor.INSTANCE);
        this.httpClient = Dsl.asyncHttpClient(Dsl.config().setEventLoopGroup(this.workerGroup).setUserAgent(server.getVersion().getName() + "/" + server.getVersion().getVersion()).addRequestFilter(new RequestFilter(){

            @Override
            public <T> FilterContext<T> filter(FilterContext<T> ctx) {
                return new FilterContext.FilterContextBuilder<T>(ctx).request(((RequestBuilder)new RequestBuilder(ctx.getRequest()).setNameResolver(ConnectionManager.this.resolver)).build()).build();
            }
        }).build());
    }

    public void logChannelInformation() {
        LOGGER.info("Connections will use {} channels, {} compression, {} ciphers", (Object)this.transportType, (Object)Natives.compress.getLoadedVariant(), (Object)Natives.cipher.getLoadedVariant());
    }

    public void bind(InetSocketAddress address) {
        ServerBootstrap bootstrap = (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(this.transportType.serverSocketChannelFactory)).group(this.bossGroup, this.workerGroup).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, SERVER_WRITE_MARK).childHandler((ChannelHandler)this.serverChannelInitializer.get()).childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.IP_TOS, 24).localAddress(address);
        if (this.transportType == TransportType.EPOLL && this.server.getConfiguration().useTcpFastOpen()) {
            bootstrap.option(EpollChannelOption.TCP_FASTOPEN, 3);
        }
        bootstrap.bind().addListener(future -> {
            Channel channel = future.channel();
            if (future.isSuccess()) {
                this.endpoints.put(address, new Endpoint(channel, ListenerType.MINECRAFT));
                LOGGER.info("Listening on {}", (Object)channel.localAddress());
                this.server.getEventManager().fireAndForget(new ListenerBoundEvent(address, ListenerType.MINECRAFT));
            } else {
                LOGGER.error("Can't bind to {}", (Object)address, (Object)future.cause());
            }
        });
    }

    public void queryBind(String hostname, int port) {
        InetSocketAddress address = new InetSocketAddress(hostname, port);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(this.transportType.datagramChannelFactory)).group(this.workerGroup)).handler(new GS4QueryHandler(this.server))).localAddress(address);
        bootstrap.bind().addListener(future -> {
            Channel channel = future.channel();
            if (future.isSuccess()) {
                this.endpoints.put(address, new Endpoint(channel, ListenerType.QUERY));
                LOGGER.info("Listening for GS4 query on {}", (Object)channel.localAddress());
                this.server.getEventManager().fireAndForget(new ListenerBoundEvent(address, ListenerType.QUERY));
            } else {
                LOGGER.error("Can't bind to {}", (Object)bootstrap.config().localAddress(), (Object)future.cause());
            }
        });
    }

    public Bootstrap createWorker(@Nullable EventLoopGroup group) {
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(this.transportType.socketChannelFactory)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.server.getConfiguration().getConnectTimeout())).group(group == null ? this.workerGroup : group)).resolver(this.resolver.asGroup());
        if (this.transportType == TransportType.EPOLL && this.server.getConfiguration().useTcpFastOpen()) {
            bootstrap.option(EpollChannelOption.TCP_FASTOPEN_CONNECT, true);
        }
        return bootstrap;
    }

    public void close(InetSocketAddress oldBind) {
        Endpoint endpoint = this.endpoints.remove(oldBind);
        this.server.getEventManager().fire(new ListenerCloseEvent(oldBind, endpoint.getType())).join();
        Channel serverChannel = endpoint.getChannel();
        Preconditions.checkState(serverChannel != null, "Endpoint %s not registered", (Object)oldBind);
        LOGGER.info("Closing endpoint {}", (Object)serverChannel.localAddress());
        serverChannel.close().syncUninterruptibly();
    }

    public void shutdown() {
        for (Map.Entry<InetSocketAddress, Endpoint> entry : this.endpoints.entrySet()) {
            InetSocketAddress address = entry.getKey();
            Endpoint endpoint = entry.getValue();
            this.server.getEventManager().fire(new ListenerCloseEvent(address, endpoint.getType())).join();
            try {
                LOGGER.info("Closing endpoint {}", (Object)address);
                endpoint.getChannel().close().sync();
            }
            catch (InterruptedException e) {
                LOGGER.info("Interrupted whilst closing endpoint", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.resolver.shutdown();
    }

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public ServerChannelInitializerHolder getServerChannelInitializer() {
        return this.serverChannelInitializer;
    }

    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    public BackendChannelInitializerHolder getBackendChannelInitializer() {
        return this.backendChannelInitializer;
    }
}

