/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept ptrace syscall
 *
 * Notes:
 *  - Enforce Exploit Detection validation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 5.XI.2020
 *
 * Author:
 * - Mariusz Zaborski (https://oshogbo.vexillium.org/)
 *
 */

#include "../../../../p_lkrg_main.h"


char p_security_ptrace_access_kretprobe_state = 0;

static struct kretprobe p_security_ptrace_access_kretprobe = {
    .kp.symbol_name = "security_ptrace_access_check",
    .handler = p_security_ptrace_access_ret,
    .entry_handler = p_security_ptrace_access_entry,
    .data_size = sizeof(struct p_security_ptrace_access_data),
};

int p_security_ptrace_access_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   p_tasks_read_lock(&p_flags);
   if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
      // This process is on the ED list - validate 'off' flag
      p_ed_validate_off_flag_wrap(p_tmp);
   }
   p_tasks_read_unlock(&p_flags);

   p_ed_enforce_validation();

   return 0;
}


int p_security_ptrace_access_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

//   p_ed_enforce_validation();

   return 0;
}


GENERATE_INSTALL_FUNC(security_ptrace_access)
