//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckdatabasescope?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKDatabaseScope(pub NSInteger);
impl CKDatabaseScope {
    #[doc(alias = "CKDatabaseScopePublic")]
    pub const Public: Self = Self(1);
    #[doc(alias = "CKDatabaseScopePrivate")]
    pub const Private: Self = Self(2);
    #[doc(alias = "CKDatabaseScopeShared")]
    pub const Shared: Self = Self(3);
}

unsafe impl Encode for CKDatabaseScope {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKDatabaseScope {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckdatabase?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKDatabase;
);

unsafe impl Send for CKDatabase {}

unsafe impl Sync for CKDatabase {}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKDatabase {}
);

impl CKDatabase {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
        #[unsafe(method(addOperation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addOperation(&self, operation: &CKDatabaseOperation);

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(databaseScope))]
        #[unsafe(method_family = none)]
        pub unsafe fn databaseScope(&self) -> CKDatabaseScope;
    );
}

/// ConvenienceMethods.
///
/// Convenience APIs
///
///
/// These calls operate on a single item in the default zone and allow for simple operations.
/// If you'd like to batch your requests, add dependencies between requests, set priorities, or schedule operations on your own queue, take a look at the corresponding
/// `CKOperation.`This work is treated as having
/// `NSQualityOfServiceUserInitiated`quality of service.
impl CKDatabase {
    extern_methods!(
        #[cfg(all(feature = "CKRecord", feature = "CKRecordID", feature = "block2"))]
        /// `CKFetchRecordsOperation`and
        /// `CKModifyRecordsOperation`are the more configurable,
        /// `CKOperation`-based alternatives to these methods
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchRecordWithID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchRecordWithID_completionHandler(
            &self,
            record_id: &CKRecordID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKRecord, *mut NSError)>,
        );

        #[cfg(all(feature = "CKRecord", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(saveRecord:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveRecord_completionHandler(
            &self,
            record: &CKRecord,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKRecord, *mut NSError)>,
        );

        #[cfg(all(feature = "CKRecordID", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(deleteRecordWithID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deleteRecordWithID_completionHandler(
            &self,
            record_id: &CKRecordID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKRecordID, *mut NSError)>,
        );

        #[cfg(all(
            feature = "CKQuery",
            feature = "CKRecord",
            feature = "CKRecordZoneID",
            feature = "block2"
        ))]
        /// `CKQueryOperation`is the more configurable,
        /// `CKOperation`-based alternative to this method
        /// Queries can potentially return a large number of records, and the server will return those records in batches. This convenience API will only fetch the first batch of results (equivalent to using
        /// `CKQueryOperationMaximumResults).`If you would like to fetch all results, use
        /// `CKQueryOperation`and its
        /// `CKQueryCursor`instead.
        /// Queries invoked within a
        /// `sharedCloudDatabase`must specify a
        /// `zoneID.`Cross-zone queries are not supported in a
        /// `sharedCloudDatabase`Queries that do not specify a
        /// `zoneID`will perform a query across all zones in the database.
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(performQuery:inZoneWithID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performQuery_inZoneWithID_completionHandler(
            &self,
            query: &CKQuery,
            zone_id: Option<&CKRecordZoneID>,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSArray<CKRecord>, *mut NSError)>,
        );

        #[cfg(all(feature = "CKRecordZone", feature = "block2"))]
        /// `CKFetchRecordZonesOperation`and
        /// `CKModifyRecordZonesOperation`are the more configurable,
        /// `CKOperation`-based alternatives to these methods
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchAllRecordZonesWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchAllRecordZonesWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSArray<CKRecordZone>, *mut NSError)>,
        );

        #[cfg(all(
            feature = "CKRecordZone",
            feature = "CKRecordZoneID",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchRecordZoneWithID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchRecordZoneWithID_completionHandler(
            &self,
            zone_id: &CKRecordZoneID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKRecordZone, *mut NSError)>,
        );

        #[cfg(all(feature = "CKRecordZone", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(saveRecordZone:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveRecordZone_completionHandler(
            &self,
            zone: &CKRecordZone,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKRecordZone, *mut NSError)>,
        );

        #[cfg(all(feature = "CKRecordZoneID", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(deleteRecordZoneWithID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deleteRecordZoneWithID_completionHandler(
            &self,
            zone_id: &CKRecordZoneID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKRecordZoneID, *mut NSError)>,
        );

        #[cfg(all(feature = "CKSubscription", feature = "block2"))]
        /// `CKFetchSubscriptionsOperation`and
        /// `CKModifySubscriptionsOperation`are the more configurable,
        /// `CKOperation`-based alternative to these methods
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchSubscriptionWithID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchSubscriptionWithID_completionHandler(
            &self,
            subscription_id: &CKSubscriptionID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKSubscription, *mut NSError)>,
        );

        #[cfg(all(feature = "CKSubscription", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchAllSubscriptionsWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchAllSubscriptionsWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSArray<CKSubscription>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "CKSubscription", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(saveSubscription:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn saveSubscription_completionHandler(
            &self,
            subscription: &CKSubscription,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKSubscription, *mut NSError)>,
        );

        #[cfg(all(feature = "CKSubscription", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(deleteSubscriptionWithID:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deleteSubscriptionWithID_completionHandler(
            &self,
            subscription_id: &CKSubscriptionID,
            completion_handler: &block2::DynBlock<dyn Fn(*mut CKSubscriptionID, *mut NSError)>,
        );
    );
}
