/*
 * Decompiled with CFR 0.152.
 */
package boundrotamers;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public class NDFloatTable {
    static final float GSN_REACH = 2.5f;
    String ourName;
    int nDim;
    float[] minVal;
    float[] maxVal;
    int[] nBins;
    boolean[] doWrap;
    int realcount;
    float[] lookupTable;
    float[] wBin;
    float tgf_a;
    float tgf_b;
    float tgf_b_2;
    float tgf_mask_2;
    int[] tgf_start;
    int[] tgf_end;
    int[] tgf_curr;
    float[] tgf_pt;

    public NDFloatTable(String string, int n, float[] fArray, float[] fArray2, int[] nArray, boolean[] blArray) {
        int n2;
        this.ourName = string;
        this.nDim = n;
        this.minVal = new float[this.nDim];
        System.arraycopy(fArray, 0, this.minVal, 0, this.nDim);
        this.maxVal = new float[this.nDim];
        System.arraycopy(fArray2, 0, this.maxVal, 0, this.nDim);
        this.nBins = new int[this.nDim];
        System.arraycopy(nArray, 0, this.nBins, 0, this.nDim);
        this.doWrap = new boolean[this.nDim];
        System.arraycopy(blArray, 0, this.doWrap, 0, this.nDim);
        this.wBin = new float[this.nDim];
        for (n2 = 0; n2 < this.nDim; ++n2) {
            this.wBin[n2] = (this.maxVal[n2] - this.minVal[n2]) / (float)this.nBins[n2];
        }
        this.tgf_start = new int[this.nDim];
        this.tgf_end = new int[this.nDim];
        this.tgf_curr = new int[this.nDim];
        n2 = 1;
        for (int i = 0; i < this.nDim; ++i) {
            n2 *= this.nBins[i];
        }
        this.lookupTable = new float[n2];
        this.zero();
    }

    int wrapbin(int n, int n2) {
        if (this.doWrap[n2]) {
            if ((n %= this.nBins[n2]) < 0) {
                return n + this.nBins[n2];
            }
            return n;
        }
        return n;
    }

    int bin2index(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.nDim - 1; ++n2) {
            n = this.wrapbin(nArray[n2], n2);
            if (n < 0 || n >= this.nBins[n2]) {
                return -1;
            }
            n3 += n;
            n3 *= this.nBins[n2 + 1];
        }
        n = this.wrapbin(nArray[n2], n2);
        if (n < 0 || n >= this.nBins[n2]) {
            return -1;
        }
        return n3 += n;
    }

    int bin2index_limit(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.nDim - 1; ++n2) {
            n = Math.min(this.nBins[n2] - 1, Math.max(this.wrapbin(nArray[n2], n2), 0));
            n3 += n;
            n3 *= this.nBins[n2 + 1];
        }
        n = Math.min(this.nBins[n2] - 1, Math.max(this.wrapbin(nArray[n2], n2), 0));
        return n3 += n;
    }

    int[] index2bin(int n) {
        int[] nArray = new int[this.nDim];
        for (int i = this.nDim - 1; i >= 0; --i) {
            nArray[i] = n % this.nBins[i];
            n -= nArray[i];
            n /= this.nBins[i];
        }
        return nArray;
    }

    public void setValueAt(int[] nArray, float f) {
        this.lookupTable[this.bin2index((int[])nArray)] = f;
    }

    public float valueAt(int[] nArray) {
        return this.lookupTable[this.bin2index(nArray)];
    }

    public float maxValue() {
        float f = this.lookupTable[0];
        for (int i = 1; i < this.lookupTable.length; ++i) {
            if (!(this.lookupTable[i] > f)) continue;
            f = this.lookupTable[i];
        }
        return f;
    }

    public float totalCount() {
        float f = 0.0f;
        for (int i = 0; i < this.lookupTable.length; ++i) {
            f += this.lookupTable[i];
        }
        return f;
    }

    public int realCount() {
        return this.realcount;
    }

    public float valueAt(float[] fArray) {
        int n;
        float f = 0.0f;
        int n2 = 1 << this.nDim;
        int[] nArray = this.whereIs(fArray);
        float[] fArray2 = this.centerOf(nArray);
        int[] nArray2 = new int[this.nDim];
        int[] nArray3 = new int[this.nDim];
        float[] fArray3 = new float[this.nDim];
        for (n = 0; n < this.nDim; ++n) {
            nArray2[n] = fArray[n] < fArray2[n] ? nArray[n] - 1 : nArray[n] + 1;
            fArray3[n] = Math.abs((fArray[n] - fArray2[n]) / this.wBin[n]);
        }
        for (int i = 0; i < n2; ++i) {
            float f2 = 1.0f;
            for (n = 0; n < this.nDim; ++n) {
                if ((i & 1 << n) == 0) {
                    nArray3[n] = nArray[n];
                    f2 *= 1.0f - fArray3[n];
                    continue;
                }
                nArray3[n] = nArray2[n];
                f2 *= fArray3[n];
            }
            f += f2 * this.lookupTable[this.bin2index_limit(nArray3)];
        }
        return f;
    }

    public boolean contains(float[] fArray) {
        for (int i = 0; i < this.nDim; ++i) {
            if (this.doWrap[i] || !(fArray[i] < this.minVal[i]) && !(fArray[i] > this.maxVal[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int[] nArray) {
        for (int i = 0; i < this.nDim; ++i) {
            if (this.doWrap[i] || nArray[i] >= 0 && nArray[i] < this.nBins[i]) continue;
            return false;
        }
        return true;
    }

    public int[] whereIs(float[] fArray) {
        int[] nArray = new int[this.nDim];
        for (int i = 0; i < this.nDim; ++i) {
            nArray[i] = Math.min((int)Math.floor((fArray[i] - this.minVal[i]) / this.wBin[i]), this.nBins[i] - 1);
        }
        return nArray;
    }

    public float[] centerOf(int[] nArray) {
        float[] fArray = new float[this.nDim];
        for (int i = 0; i < this.nDim; ++i) {
            fArray[i] = this.minVal[i] + this.wBin[i] * ((float)nArray[i] + 0.5f);
        }
        return fArray;
    }

    public static float distanceSquared(float[] fArray, float[] fArray2) {
        int n = Math.min(fArray.length, fArray2.length);
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            float f2 = fArray[i] - fArray2[i];
            f += f2 * f2;
        }
        return f;
    }

    public void tallySimple(float[] fArray) {
        ++this.realcount;
        int n = this.bin2index(this.whereIs(fArray));
        this.lookupTable[n] = this.lookupTable[n] + 1.0f;
    }

    public void tallyGaussian(float[] fArray, float f) {
        this.tgf_b = f / 1.5174f;
        this.tgf_a = 1.0f / (float)Math.pow((double)this.tgf_b * 1.7725, this.nDim);
        this.tallyGaussian(fArray, f, this.tgf_a);
    }

    public void tallyGaussian(float[] fArray, float f, float f2) {
        ++this.realcount;
        this.tgf_pt = fArray;
        this.tgf_b = f / 1.5174f;
        this.tgf_b_2 = this.tgf_b * this.tgf_b;
        this.tgf_a = f2;
        float f3 = 2.5f * f;
        for (int i = 0; i < this.nDim; ++i) {
            this.tgf_start[i] = Math.round((fArray[i] - this.minVal[i] - f3) / this.wBin[i]);
            this.tgf_end[i] = Math.round((fArray[i] - this.minVal[i] + f3) / this.wBin[i]);
            this.tgf_curr[i] = this.tgf_start[i];
        }
        this.tgfRecursiveLoop(0);
    }

    void tgfRecursiveLoop(int n) {
        if (n < this.nDim) {
            this.tgf_curr[n] = this.tgf_start[n];
            while (this.tgf_curr[n] <= this.tgf_end[n]) {
                this.tgfRecursiveLoop(n + 1);
                int n2 = n;
                this.tgf_curr[n2] = this.tgf_curr[n2] + 1;
            }
        } else {
            int n3 = this.bin2index(this.tgf_curr);
            if (n3 != -1) {
                float[] fArray = this.centerOf(this.tgf_curr);
                float f = NDFloatTable.distanceSquared(fArray, this.tgf_pt);
                float f2 = this.tgf_a * (float)Math.exp(-f / this.tgf_b_2);
                int n4 = n3;
                this.lookupTable[n4] = this.lookupTable[n4] + f2;
            }
        }
    }

    public void tallyCosine(float[] fArray, float f) {
        float f2 = 1.0f / (float)Math.pow(f, this.nDim);
        this.tallyCosine(fArray, f, f2);
    }

    public void tallyCosine(float[] fArray, float f, float f2) {
        ++this.realcount;
        this.tgf_pt = fArray;
        this.tgf_b = f / (float)Math.PI;
        this.tgf_a = f2;
        this.tgf_mask_2 = f * f;
        for (int i = 0; i < this.nDim; ++i) {
            this.tgf_start[i] = Math.round((fArray[i] - this.minVal[i] - f) / this.wBin[i]);
            this.tgf_end[i] = Math.round((fArray[i] - this.minVal[i] + f) / this.wBin[i]);
            this.tgf_curr[i] = this.tgf_start[i];
        }
        this.cosRecursiveLoop(0);
    }

    void cosRecursiveLoop(int n) {
        if (n < this.nDim) {
            this.tgf_curr[n] = this.tgf_start[n];
            while (this.tgf_curr[n] <= this.tgf_end[n]) {
                this.cosRecursiveLoop(n + 1);
                int n2 = n;
                this.tgf_curr[n2] = this.tgf_curr[n2] + 1;
            }
        } else {
            float[] fArray;
            float f;
            int n3 = this.bin2index(this.tgf_curr);
            if (n3 != -1 && (f = NDFloatTable.distanceSquared(fArray = this.centerOf(this.tgf_curr), this.tgf_pt)) < this.tgf_mask_2) {
                f = (float)Math.sqrt(f);
                float f2 = this.tgf_a * (float)(Math.cos(f / this.tgf_b) + 1.0);
                int n4 = n3;
                this.lookupTable[n4] = this.lookupTable[n4] + f2;
            }
        }
    }

    public void zero() {
        this.realcount = 0;
        for (int i = 0; i < this.lookupTable.length; ++i) {
            this.lookupTable[i] = 0.0f;
        }
    }

    public void scale(float f) {
        int n = 0;
        while (n < this.lookupTable.length) {
            int n2 = n++;
            this.lookupTable[n2] = this.lookupTable[n2] * f;
        }
    }

    public void normalize() {
        float f = 1.0f;
        for (int i = 0; i < this.nDim; ++i) {
            f *= this.wBin[i];
        }
        this.scale((float)this.realcount / f / this.totalCount());
    }

    public void standardize(float f) {
        this.scale(f / this.maxValue());
    }

    public void transformLog() {
        for (int i = 0; i < this.lookupTable.length; ++i) {
            this.lookupTable[i] = (float)Math.log(this.lookupTable[i] + 1.0f);
        }
    }

    public void fractionLessThan(float[] fArray) {
        double d = fArray.length;
        Arrays.sort(fArray);
        for (int i = 0; i < this.lookupTable.length; ++i) {
            double d2 = Arrays.binarySearch(fArray, this.lookupTable[i]);
            if (d2 < 0.0) {
                d2 = Math.abs(d2 + 1.0);
            }
            this.lookupTable[i] = (float)(d2 / d);
        }
    }

    public void writeBinary(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeBytes(this.ourName);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeInt(this.nDim);
        for (n = 0; n < this.nDim; ++n) {
            dataOutputStream.writeFloat(this.minVal[n]);
        }
        for (n = 0; n < this.nDim; ++n) {
            dataOutputStream.writeFloat(this.maxVal[n]);
        }
        for (n = 0; n < this.nDim; ++n) {
            dataOutputStream.writeInt(this.nBins[n]);
        }
        for (n = 0; n < this.nDim; ++n) {
            dataOutputStream.writeBoolean(this.doWrap[n]);
        }
        dataOutputStream.writeInt(this.realcount);
        for (n = 0; n < this.lookupTable.length; ++n) {
            dataOutputStream.writeFloat(this.lookupTable[n]);
        }
    }

    public NDFloatTable(DataInputStream dataInputStream) throws IOException {
        int n;
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = (char)dataInputStream.readUnsignedByte()) != '\u0000') {
            stringBuffer.append(c);
        }
        this.ourName = stringBuffer.toString();
        this.nDim = dataInputStream.readInt();
        this.minVal = new float[this.nDim];
        this.maxVal = new float[this.nDim];
        this.nBins = new int[this.nDim];
        this.doWrap = new boolean[this.nDim];
        for (n = 0; n < this.nDim; ++n) {
            this.minVal[n] = dataInputStream.readFloat();
        }
        for (n = 0; n < this.nDim; ++n) {
            this.maxVal[n] = dataInputStream.readFloat();
        }
        for (n = 0; n < this.nDim; ++n) {
            this.nBins[n] = dataInputStream.readInt();
        }
        for (n = 0; n < this.nDim; ++n) {
            this.doWrap[n] = dataInputStream.readBoolean();
        }
        this.realcount = dataInputStream.readInt();
        this.wBin = new float[this.nDim];
        for (n = 0; n < this.nDim; ++n) {
            this.wBin[n] = (this.maxVal[n] - this.minVal[n]) / (float)this.nBins[n];
        }
        this.tgf_start = new int[this.nDim];
        this.tgf_end = new int[this.nDim];
        this.tgf_curr = new int[this.nDim];
        int n2 = 1;
        for (n = 0; n < this.nDim; ++n) {
            n2 *= this.nBins[n];
        }
        this.lookupTable = new float[n2];
        this.realcount = 0;
        for (n = 0; n < this.lookupTable.length; ++n) {
            this.lookupTable[n] = dataInputStream.readFloat();
        }
    }

    public void writeText(PrintStream printStream) {
        int n;
        printStream.println("# Table name/description");
        printStream.println("\"" + this.ourName + "\"");
        printStream.println("# Number of dimensions");
        printStream.println(this.nDim);
        printStream.println("# For each dimension, 1 to " + this.nDim + ": lower_bound  upper_bound  number_of_bins  wrapping");
        for (n = 0; n < this.nDim; ++n) {
            printStream.print(this.minVal[n]);
            printStream.print(" ");
            printStream.print(this.maxVal[n]);
            printStream.print(" ");
            printStream.print(this.nBins[n]);
            printStream.print(" ");
            printStream.print(this.doWrap[n]);
            printStream.println();
        }
        printStream.println("# List of table values. For each dimension, define step_size as");
        printStream.println("#     (upper_bound - lower_bound) / number_of_bins ");
        printStream.println("#");
        printStream.println("# In each dimension, sampling starts at lower_bound + (step_size/2),");
        printStream.println("# continues at intervals of step_size, and does not exceed upper_bound.");
        printStream.println("# There are thus number_of_bins samples along that dimension.");
        printStream.println("#");
        printStream.println("# Index for dimension 1 increases most slowly, index for dimension " + this.nDim);
        printStream.println("# increases most quickly. Line breaks are arbitrary (for readability).");
        printStream.println("#");
        printStream.println("# More details from http://kinemage.biochem.duke.edu");
        n = 0;
        while (n < this.lookupTable.length) {
            printStream.print(this.lookupTable[n]);
            if (++n % 6 == 0) {
                printStream.println();
                continue;
            }
            printStream.print(" ");
        }
    }

    public String getName() {
        return this.ourName;
    }

    public void setName(String string) {
        this.ourName = string;
    }

    public int getDimensions() {
        return this.nDim;
    }

    public float[] getMinBounds() {
        float[] fArray = new float[this.nDim];
        System.arraycopy(this.minVal, 0, fArray, 0, this.nDim);
        return fArray;
    }

    public float[] getMaxBounds() {
        float[] fArray = new float[this.nDim];
        System.arraycopy(this.maxVal, 0, fArray, 0, this.nDim);
        return fArray;
    }

    public int[] getBins() {
        int[] nArray = new int[this.nDim];
        System.arraycopy(this.nBins, 0, nArray, 0, this.nDim);
        return nArray;
    }

    public boolean[] getWrap() {
        boolean[] blArray = new boolean[this.nDim];
        System.arraycopy(this.doWrap, 0, blArray, 0, this.nDim);
        return blArray;
    }

    void echo(String string) {
        System.err.println(string);
    }
}

